/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.extractor.ogg;

import androidx.annotation.Nullable;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.ParsableByteArray;
import androidx.media3.common.util.Util;
import androidx.media3.extractor.ExtractorInput;
import androidx.media3.extractor.FlacFrameReader;
import androidx.media3.extractor.FlacMetadataReader;
import androidx.media3.extractor.FlacSeekTableSeekMap;
import androidx.media3.extractor.FlacStreamMetadata;
import androidx.media3.extractor.SeekMap;
import androidx.media3.extractor.ogg.OggSeeker;
import androidx.media3.extractor.ogg.StreamReader;
import java.util.Arrays;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;

final class FlacReader
extends StreamReader {
    private static final byte AUDIO_PACKET_TYPE = -1;
    private static final int FRAME_HEADER_SAMPLE_NUMBER_OFFSET = 4;
    @Nullable
    private FlacStreamMetadata streamMetadata;
    @Nullable
    private FlacOggSeeker flacOggSeeker;

    FlacReader() {
    }

    public static boolean verifyBitstreamType(ParsableByteArray data) {
        return data.bytesLeft() >= 5 && data.readUnsignedByte() == 127 && data.readUnsignedInt() == 1179402563L;
    }

    @Override
    protected void reset(boolean headerData) {
        super.reset(headerData);
        if (headerData) {
            this.streamMetadata = null;
            this.flacOggSeeker = null;
        }
    }

    private static boolean isAudioPacket(byte[] data) {
        return data[0] == -1;
    }

    @Override
    protected long preparePayload(ParsableByteArray packet) {
        if (!FlacReader.isAudioPacket(packet.getData())) {
            return -1L;
        }
        return this.getFlacFrameBlockSize(packet);
    }

    @Override
    @EnsuresNonNullIf(expression={"#3.format"}, result=false)
    protected boolean readHeaders(ParsableByteArray packet, long position, StreamReader.SetupData setupData) {
        byte[] data = packet.getData();
        FlacStreamMetadata streamMetadata = this.streamMetadata;
        if (streamMetadata == null) {
            this.streamMetadata = streamMetadata = new FlacStreamMetadata(data, 17);
            byte[] metadata = Arrays.copyOfRange(data, 9, packet.limit());
            setupData.format = streamMetadata.getFormat(metadata, null);
            return true;
        }
        if ((data[0] & 0x7F) == 3) {
            FlacStreamMetadata.SeekTable seekTable = FlacMetadataReader.readSeekTableMetadataBlock(packet);
            this.streamMetadata = streamMetadata = streamMetadata.copyWithSeekTable(seekTable);
            this.flacOggSeeker = new FlacOggSeeker(streamMetadata, seekTable);
            return true;
        }
        if (FlacReader.isAudioPacket(data)) {
            if (this.flacOggSeeker != null) {
                this.flacOggSeeker.setFirstFrameOffset(position);
                setupData.oggSeeker = this.flacOggSeeker;
            }
            Assertions.checkNotNull((Object)setupData.format);
            return false;
        }
        return true;
    }

    private int getFlacFrameBlockSize(ParsableByteArray packet) {
        int blockSizeKey = (packet.getData()[2] & 0xFF) >> 4;
        if (blockSizeKey == 6 || blockSizeKey == 7) {
            packet.skipBytes(4);
            packet.readUtf8EncodedLong();
        }
        int result = FlacFrameReader.readFrameBlockSizeSamplesFromKey(packet, blockSizeKey);
        packet.setPosition(0);
        return result;
    }

    private static final class FlacOggSeeker
    implements OggSeeker {
        private FlacStreamMetadata streamMetadata;
        private FlacStreamMetadata.SeekTable seekTable;
        private long firstFrameOffset;
        private long pendingSeekGranule;

        public FlacOggSeeker(FlacStreamMetadata streamMetadata, FlacStreamMetadata.SeekTable seekTable) {
            this.streamMetadata = streamMetadata;
            this.seekTable = seekTable;
            this.firstFrameOffset = -1L;
            this.pendingSeekGranule = -1L;
        }

        public void setFirstFrameOffset(long firstFrameOffset) {
            this.firstFrameOffset = firstFrameOffset;
        }

        @Override
        public long read(ExtractorInput input) {
            if (this.pendingSeekGranule >= 0L) {
                long result = -(this.pendingSeekGranule + 2L);
                this.pendingSeekGranule = -1L;
                return result;
            }
            return -1L;
        }

        @Override
        public void startSeek(long targetGranule) {
            long[] seekPointGranules = this.seekTable.pointSampleNumbers;
            int index = Util.binarySearchFloor((long[])seekPointGranules, (long)targetGranule, (boolean)true, (boolean)true);
            this.pendingSeekGranule = seekPointGranules[index];
        }

        @Override
        public SeekMap createSeekMap() {
            Assertions.checkState((this.firstFrameOffset != -1L ? 1 : 0) != 0);
            return new FlacSeekTableSeekMap(this.streamMetadata, this.firstFrameOffset);
        }
    }
}

