/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.extractor.text.ttml;

import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.text.style.AbsoluteSizeSpan;
import android.text.style.BackgroundColorSpan;
import android.text.style.ForegroundColorSpan;
import android.text.style.RelativeSizeSpan;
import android.text.style.StrikethroughSpan;
import android.text.style.StyleSpan;
import android.text.style.TypefaceSpan;
import android.text.style.UnderlineSpan;
import androidx.annotation.Nullable;
import androidx.media3.common.text.HorizontalTextInVerticalContextSpan;
import androidx.media3.common.text.RubySpan;
import androidx.media3.common.text.SpanUtil;
import androidx.media3.common.text.TextEmphasisSpan;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.Log;
import androidx.media3.common.util.Util;
import androidx.media3.extractor.text.ttml.DeleteTextSpan;
import androidx.media3.extractor.text.ttml.TextEmphasis;
import androidx.media3.extractor.text.ttml.TtmlNode;
import androidx.media3.extractor.text.ttml.TtmlStyle;
import java.util.ArrayDeque;
import java.util.Map;

final class TtmlRenderUtil {
    private static final String TAG = "TtmlRenderUtil";

    @Nullable
    public static TtmlStyle resolveStyle(@Nullable TtmlStyle style, @Nullable String[] styleIds, Map<String, TtmlStyle> globalStyles) {
        if (style == null) {
            if (styleIds == null) {
                return null;
            }
            if (styleIds.length == 1) {
                return globalStyles.get(styleIds[0]);
            }
            if (styleIds.length > 1) {
                TtmlStyle chainedStyle = new TtmlStyle();
                for (String id : styleIds) {
                    chainedStyle.chain(globalStyles.get(id));
                }
                return chainedStyle;
            }
        } else {
            if (styleIds != null && styleIds.length == 1) {
                return style.chain(globalStyles.get(styleIds[0]));
            }
            if (styleIds != null && styleIds.length > 1) {
                for (String id : styleIds) {
                    style.chain(globalStyles.get(id));
                }
                return style;
            }
        }
        return style;
    }

    public static void applyStylesToSpan(Spannable builder, int start, int end, TtmlStyle style, @Nullable TtmlNode parent, Map<String, TtmlStyle> globalStyles, int verticalType) {
        if (style.getStyle() != -1) {
            builder.setSpan((Object)new StyleSpan(style.getStyle()), start, end, 33);
        }
        if (style.isLinethrough()) {
            builder.setSpan((Object)new StrikethroughSpan(), start, end, 33);
        }
        if (style.isUnderline()) {
            builder.setSpan((Object)new UnderlineSpan(), start, end, 33);
        }
        if (style.hasFontColor()) {
            SpanUtil.addOrReplaceSpan((Spannable)builder, (Object)new ForegroundColorSpan(style.getFontColor()), (int)start, (int)end, (int)33);
        }
        if (style.hasBackgroundColor()) {
            SpanUtil.addOrReplaceSpan((Spannable)builder, (Object)new BackgroundColorSpan(style.getBackgroundColor()), (int)start, (int)end, (int)33);
        }
        if (style.getFontFamily() != null) {
            SpanUtil.addOrReplaceSpan((Spannable)builder, (Object)new TypefaceSpan(style.getFontFamily()), (int)start, (int)end, (int)33);
        }
        if (style.getTextEmphasis() != null) {
            int markFill;
            int markShape;
            TextEmphasis textEmphasis = (TextEmphasis)Assertions.checkNotNull((Object)style.getTextEmphasis());
            if (textEmphasis.markShape == -1) {
                markShape = verticalType == 2 || verticalType == 1 ? 3 : 1;
                markFill = 1;
            } else {
                markShape = textEmphasis.markShape;
                markFill = textEmphasis.markFill;
            }
            int position = textEmphasis.position == -2 ? 1 : textEmphasis.position;
            SpanUtil.addOrReplaceSpan((Spannable)builder, (Object)new TextEmphasisSpan(markShape, markFill, position), (int)start, (int)end, (int)33);
        }
        switch (style.getRubyType()) {
            case 2: {
                int rubyPosition;
                TtmlNode textNode;
                TtmlNode containerNode = TtmlRenderUtil.findRubyContainerNode(parent, globalStyles);
                if (containerNode == null || (textNode = TtmlRenderUtil.findRubyTextNode(containerNode, globalStyles)) == null) break;
                if (textNode.getChildCount() != 1 || textNode.getChild((int)0).text == null) {
                    Log.i((String)TAG, (String)"Skipping rubyText node without exactly one text child.");
                    break;
                }
                String rubyText = (String)Util.castNonNull((Object)textNode.getChild((int)0).text);
                TtmlStyle textStyle = TtmlRenderUtil.resolveStyle(textNode.style, textNode.getStyleIds(), globalStyles);
                int n = rubyPosition = textStyle != null ? textStyle.getRubyPosition() : -1;
                if (rubyPosition == -1) {
                    TtmlStyle containerStyle = TtmlRenderUtil.resolveStyle(containerNode.style, containerNode.getStyleIds(), globalStyles);
                    rubyPosition = containerStyle != null ? containerStyle.getRubyPosition() : rubyPosition;
                }
                builder.setSpan((Object)new RubySpan(rubyText, rubyPosition), start, end, 33);
                break;
            }
            case 3: 
            case 4: {
                builder.setSpan((Object)new DeleteTextSpan(), start, end, 33);
                break;
            }
        }
        if (style.getTextCombine()) {
            SpanUtil.addOrReplaceSpan((Spannable)builder, (Object)new HorizontalTextInVerticalContextSpan(), (int)start, (int)end, (int)33);
        }
        switch (style.getFontSizeUnit()) {
            case 1: {
                SpanUtil.addOrReplaceSpan((Spannable)builder, (Object)new AbsoluteSizeSpan((int)style.getFontSize(), true), (int)start, (int)end, (int)33);
                break;
            }
            case 2: {
                SpanUtil.addOrReplaceSpan((Spannable)builder, (Object)new RelativeSizeSpan(style.getFontSize()), (int)start, (int)end, (int)33);
                break;
            }
            case 3: {
                SpanUtil.addOrReplaceSpan((Spannable)builder, (Object)new RelativeSizeSpan(style.getFontSize() / 100.0f), (int)start, (int)end, (int)33);
                break;
            }
        }
    }

    @Nullable
    private static TtmlNode findRubyTextNode(TtmlNode rubyContainerNode, Map<String, TtmlStyle> globalStyles) {
        ArrayDeque<TtmlNode> childNodesStack = new ArrayDeque<TtmlNode>();
        childNodesStack.push(rubyContainerNode);
        while (!childNodesStack.isEmpty()) {
            TtmlNode childNode = (TtmlNode)childNodesStack.pop();
            TtmlStyle style = TtmlRenderUtil.resolveStyle(childNode.style, childNode.getStyleIds(), globalStyles);
            if (style != null && style.getRubyType() == 3) {
                return childNode;
            }
            for (int i = childNode.getChildCount() - 1; i >= 0; --i) {
                childNodesStack.push(childNode.getChild(i));
            }
        }
        return null;
    }

    @Nullable
    private static TtmlNode findRubyContainerNode(@Nullable TtmlNode node, Map<String, TtmlStyle> globalStyles) {
        while (node != null) {
            TtmlStyle style = TtmlRenderUtil.resolveStyle(node.style, node.getStyleIds(), globalStyles);
            if (style != null && style.getRubyType() == 1) {
                return node;
            }
            node = node.parent;
        }
        return null;
    }

    static void endParagraph(SpannableStringBuilder builder) {
        int position;
        for (position = builder.length() - 1; position >= 0 && builder.charAt(position) == ' '; --position) {
        }
        if (position >= 0 && builder.charAt(position) != '\n') {
            builder.append('\n');
        }
    }

    static String applyTextElementSpacePolicy(String in) {
        String out = in.replaceAll("\r\n", "\n");
        out = out.replaceAll(" *\n *", "\n");
        out = out.replaceAll("\n", " ");
        out = out.replaceAll("[ \t\\x0B\f\r]+", " ");
        return out;
    }

    private TtmlRenderUtil() {
    }
}

