/*
 * Decompiled with CFR 0.152.
 */
package com.twobigears.audio360exo2;

import androidx.media3.decoder.DecoderInputBuffer;
import androidx.media3.decoder.DecoderOutputBuffer;
import androidx.media3.decoder.SimpleDecoder;
import androidx.media3.decoder.SimpleDecoderOutputBuffer;
import com.twobigears.audio360exo2.OpusDecoderException;
import com.twobigears.audio360exo2.OpusJNI;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;

public final class OpusDecoder
extends SimpleDecoder<DecoderInputBuffer, SimpleDecoderOutputBuffer, OpusDecoderException> {
    private static final int MAX_OPUS_CHANNELS = 255;
    private static final int DEFAULT_SEEK_PRE_ROLL_SAMPLES = 3840;
    private static final int SAMPLE_RATE = 48000;
    private final int channelCount;
    private final int headerSkipSamples;
    private final int headerSeekPreRollSamples;
    private final long nativeDecoderContext;
    private int skipSamples;

    public OpusDecoder(int numInputBuffers, int numOutputBuffers, int initialInputBufferSize, List<byte[]> initializationData) throws OpusDecoderException {
        super(new DecoderInputBuffer[numInputBuffers], (DecoderOutputBuffer[])new SimpleDecoderOutputBuffer[numOutputBuffers]);
        int numCoupled;
        int numStreams;
        if (!OpusJNI.IS_AVAILABLE) {
            throw new OpusDecoderException("Failed to load decoder native libraries.");
        }
        byte[] headerBytes = initializationData.get(0);
        if (headerBytes.length < 19) {
            throw new OpusDecoderException("Header size is too small.");
        }
        this.channelCount = headerBytes[9] & 0xFF;
        int preskip = OpusDecoder.readLittleEndian16(headerBytes, 10);
        int gain = OpusDecoder.readLittleEndian16(headerBytes, 16);
        byte[] streamMap = new byte[255];
        if (headerBytes[18] == 0) {
            if (this.channelCount > 2) {
                throw new OpusDecoderException("Invalid Header, missing stream map.");
            }
            numStreams = 1;
            numCoupled = this.channelCount == 2 ? 1 : 0;
            streamMap[0] = 0;
            streamMap[1] = 1;
        } else {
            if (headerBytes.length < 21 + this.channelCount) {
                throw new OpusDecoderException("Header size is too small.");
            }
            numStreams = headerBytes[19] & 0xFF;
            numCoupled = headerBytes[20] & 0xFF;
            System.arraycopy(headerBytes, 21, streamMap, 0, this.channelCount);
        }
        if (initializationData.size() == 3) {
            if (initializationData.get(1).length != 8 || initializationData.get(2).length != 8) {
                throw new OpusDecoderException("Invalid Codec Delay or Seek Preroll");
            }
            long codecDelayNs = ByteBuffer.wrap(initializationData.get(1)).order(ByteOrder.nativeOrder()).getLong();
            long seekPreRollNs = ByteBuffer.wrap(initializationData.get(2)).order(ByteOrder.nativeOrder()).getLong();
            this.headerSkipSamples = OpusDecoder.nsToSamples(codecDelayNs);
            this.headerSeekPreRollSamples = OpusDecoder.nsToSamples(seekPreRollNs);
        } else {
            this.headerSkipSamples = preskip;
            this.headerSeekPreRollSamples = 3840;
        }
        this.nativeDecoderContext = OpusJNI.opusInit(48000, this.channelCount, numStreams, numCoupled, gain, streamMap);
        if (this.nativeDecoderContext == 0L) {
            throw new OpusDecoderException("Failed to initialize decoder");
        }
        this.setInitialInputBufferSize(initialInputBufferSize);
    }

    public String getName() {
        return "libopus";
    }

    public DecoderInputBuffer createInputBuffer() {
        return new DecoderInputBuffer(2);
    }

    public SimpleDecoderOutputBuffer createOutputBuffer() {
        return new SimpleDecoderOutputBuffer(arg_0 -> ((OpusDecoder)this).releaseOutputBuffer(arg_0));
    }

    protected OpusDecoderException createUnexpectedDecodeException(Throwable error) {
        return new OpusDecoderException("Unexpected Opus decoder exception", error);
    }

    public OpusDecoderException decode(DecoderInputBuffer inputBuffer, SimpleDecoderOutputBuffer outputBuffer, boolean reset) {
        ByteBuffer inputData;
        int result;
        if (reset) {
            OpusJNI.opusReset(this.nativeDecoderContext);
            int n = this.skipSamples = inputBuffer.timeUs == 0L ? this.headerSkipSamples : this.headerSeekPreRollSamples;
        }
        if ((result = OpusJNI.opusDecode(this.nativeDecoderContext, inputBuffer.timeUs, inputData = inputBuffer.data, inputData.limit(), outputBuffer, 48000, this.channelCount)) < 0) {
            return new OpusDecoderException("Decode error: " + result);
        }
        ByteBuffer outputData = outputBuffer.data;
        outputData.position(0);
        outputData.limit(result);
        if (this.skipSamples > 0) {
            int bytesPerSample = this.channelCount * 2;
            int skipBytes = this.skipSamples * bytesPerSample;
            if (result <= skipBytes) {
                this.skipSamples -= result / bytesPerSample;
                outputBuffer.addFlag(Integer.MIN_VALUE);
                outputData.position(result);
            } else {
                this.skipSamples = 0;
                outputData.position(skipBytes);
            }
        }
        return null;
    }

    public void release() {
        super.release();
        OpusJNI.opusClose(this.nativeDecoderContext);
    }

    private static int nsToSamples(long ns) {
        return (int)(ns * 48000L / 1000000000L);
    }

    private static int readLittleEndian16(byte[] input, int offset) {
        int value = input[offset] & 0xFF;
        return value |= (input[offset + 1] & 0xFF) << 8;
    }

    public int getChannelCount() {
        return this.channelCount;
    }

    public int getSampleRate() {
        return 48000;
    }
}

