/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.common.util;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Handler;
import android.os.Looper;
import android.telephony.TelephonyCallback;
import android.telephony.TelephonyDisplayInfo;
import android.telephony.TelephonyManager;
import androidx.annotation.GuardedBy;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.concurrent.CopyOnWriteArrayList;

@UnstableApi
public final class NetworkTypeObserver {
    @Nullable
    private static NetworkTypeObserver staticInstance;
    private final Handler mainHandler = new Handler(Looper.getMainLooper());
    private final CopyOnWriteArrayList<WeakReference<Listener>> listeners = new CopyOnWriteArrayList();
    private final Object networkTypeLock = new Object();
    @GuardedBy(value="networkTypeLock")
    private int networkType = 0;

    public static synchronized NetworkTypeObserver getInstance(Context context) {
        if (staticInstance == null) {
            staticInstance = new NetworkTypeObserver(context);
        }
        return staticInstance;
    }

    @VisibleForTesting
    public static synchronized void resetForTests() {
        staticInstance = null;
    }

    private NetworkTypeObserver(Context context) {
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
        context.registerReceiver((BroadcastReceiver)new Receiver(), filter);
    }

    public void register(Listener listener) {
        this.removeClearedReferences();
        this.listeners.add(new WeakReference<Listener>(listener));
        this.mainHandler.post(() -> listener.onNetworkTypeChanged(this.getNetworkType()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNetworkType() {
        Object object = this.networkTypeLock;
        synchronized (object) {
            return this.networkType;
        }
    }

    private void removeClearedReferences() {
        for (WeakReference<Listener> listenerReference : this.listeners) {
            if (listenerReference.get() != null) continue;
            this.listeners.remove(listenerReference);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateNetworkType(int networkType) {
        Iterator<WeakReference<Listener>> iterator = this.networkTypeLock;
        synchronized (iterator) {
            if (this.networkType == networkType) {
                return;
            }
            this.networkType = networkType;
        }
        for (WeakReference<Listener> listenerReference : this.listeners) {
            Listener listener = (Listener)listenerReference.get();
            if (listener != null) {
                listener.onNetworkTypeChanged(networkType);
                continue;
            }
            this.listeners.remove(listenerReference);
        }
    }

    private static int getNetworkTypeFromConnectivityManager(Context context) {
        NetworkInfo networkInfo;
        ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        if (connectivityManager == null) {
            return 0;
        }
        try {
            networkInfo = connectivityManager.getActiveNetworkInfo();
        }
        catch (SecurityException e) {
            return 0;
        }
        if (networkInfo == null || !networkInfo.isConnected()) {
            return 1;
        }
        switch (networkInfo.getType()) {
            case 1: {
                return 2;
            }
            case 6: {
                return 5;
            }
            case 0: 
            case 4: 
            case 5: {
                return NetworkTypeObserver.getMobileNetworkType(networkInfo);
            }
            case 9: {
                return 7;
            }
        }
        return 8;
    }

    private static int getMobileNetworkType(NetworkInfo networkInfo) {
        switch (networkInfo.getSubtype()) {
            case 1: 
            case 2: {
                return 3;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 17: {
                return 4;
            }
            case 13: {
                return 5;
            }
            case 20: {
                return Util.SDK_INT >= 29 ? 9 : 0;
            }
            case 18: {
                return 2;
            }
        }
        return 6;
    }

    @RequiresApi(value=31)
    private static final class Api31 {
        private Api31() {
        }

        public static void disambiguate4gAnd5gNsa(Context context, NetworkTypeObserver instance) {
            try {
                TelephonyManager telephonyManager = Assertions.checkNotNull((TelephonyManager)context.getSystemService("phone"));
                DisplayInfoCallback callback = new DisplayInfoCallback(instance);
                telephonyManager.registerTelephonyCallback(context.getMainExecutor(), (TelephonyCallback)callback);
                telephonyManager.unregisterTelephonyCallback((TelephonyCallback)callback);
            }
            catch (RuntimeException e) {
                instance.updateNetworkType(5);
            }
        }

        private static final class DisplayInfoCallback
        extends TelephonyCallback
        implements TelephonyCallback.DisplayInfoListener {
            private final NetworkTypeObserver instance;

            public DisplayInfoCallback(NetworkTypeObserver instance) {
                this.instance = instance;
            }

            public void onDisplayInfoChanged(TelephonyDisplayInfo telephonyDisplayInfo) {
                int overrideNetworkType = telephonyDisplayInfo.getOverrideNetworkType();
                boolean is5gNsa = overrideNetworkType == 3 || overrideNetworkType == 4 || overrideNetworkType == 5;
                this.instance.updateNetworkType(is5gNsa ? 10 : 5);
            }
        }
    }

    private final class Receiver
    extends BroadcastReceiver {
        private Receiver() {
        }

        public void onReceive(Context context, Intent intent) {
            int networkType = NetworkTypeObserver.getNetworkTypeFromConnectivityManager(context);
            if (Util.SDK_INT >= 31 && networkType == 5) {
                Api31.disambiguate4gAnd5gNsa(context, NetworkTypeObserver.this);
            } else {
                NetworkTypeObserver.this.updateNetworkType(networkType);
            }
        }
    }

    public static interface Listener {
        public void onNetworkTypeChanged(int var1);
    }
}

