/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer.rtsp.reader;

import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.Log;
import androidx.media3.common.util.ParsableByteArray;
import androidx.media3.common.util.Util;
import androidx.media3.exoplayer.rtsp.RtpPacket;
import androidx.media3.exoplayer.rtsp.RtpPayloadFormat;
import androidx.media3.exoplayer.rtsp.reader.RtpPayloadReader;
import androidx.media3.exoplayer.rtsp.reader.RtpReaderUtils;
import androidx.media3.extractor.ExtractorOutput;
import androidx.media3.extractor.TrackOutput;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

final class RtpAmrReader
implements RtpPayloadReader {
    private static final String TAG = "RtpAmrReader";
    private static final int[] AMR_NB_FRAME_TYPE_INDEX_TO_FRAME_SIZE = new int[]{13, 14, 16, 18, 20, 21, 27, 32, 6, 7, 6, 6, 1, 1, 1, 1};
    private static final int[] AMR_WB_FRAME_TYPE_INDEX_TO_FRAME_SIZE = new int[]{18, 24, 33, 37, 41, 47, 51, 59, 61, 6, 1, 1, 1, 1, 1, 1};
    private final RtpPayloadFormat payloadFormat;
    private final boolean isWideBand;
    private final int sampleRate;
    private @MonotonicNonNull TrackOutput trackOutput;
    private long firstReceivedTimestamp;
    private long startTimeOffsetUs;
    private int previousSequenceNumber;

    public RtpAmrReader(RtpPayloadFormat payloadFormat) {
        this.payloadFormat = payloadFormat;
        this.isWideBand = "audio/amr-wb".equals(Assertions.checkNotNull((Object)payloadFormat.format.sampleMimeType));
        this.sampleRate = payloadFormat.clockRate;
        this.firstReceivedTimestamp = -9223372036854775807L;
        this.previousSequenceNumber = -1;
        this.startTimeOffsetUs = 0L;
    }

    @Override
    public void createTracks(ExtractorOutput extractorOutput, int trackId) {
        this.trackOutput = extractorOutput.track(trackId, 1);
        this.trackOutput.format(this.payloadFormat.format);
    }

    @Override
    public void onReceivingFirstPacket(long timestamp, int sequenceNumber) {
        this.firstReceivedTimestamp = timestamp;
    }

    @Override
    public void consume(ParsableByteArray data, long timestamp, int sequenceNumber, boolean rtpMarker) {
        int expectedSequenceNumber;
        Assertions.checkStateNotNull((Object)this.trackOutput);
        if (this.previousSequenceNumber != -1 && sequenceNumber != (expectedSequenceNumber = RtpPacket.getNextSequenceNumber(this.previousSequenceNumber))) {
            Log.w((String)TAG, (String)Util.formatInvariant((String)"Received RTP packet with unexpected sequence number. Expected: %d; received: %d.", (Object[])new Object[]{expectedSequenceNumber, sequenceNumber}));
        }
        data.skipBytes(1);
        int frameType = data.peekUnsignedByte() >> 3 & 0xF;
        int frameSize = RtpAmrReader.getFrameSize(frameType, this.isWideBand);
        int sampleSize = data.bytesLeft();
        Assertions.checkArgument((sampleSize == frameSize ? 1 : 0) != 0, (Object)"compound payload not supported currently");
        this.trackOutput.sampleData(data, sampleSize);
        long sampleTimeUs = RtpReaderUtils.toSampleTimeUs(this.startTimeOffsetUs, timestamp, this.firstReceivedTimestamp, this.sampleRate);
        this.trackOutput.sampleMetadata(sampleTimeUs, 1, sampleSize, 0, null);
        this.previousSequenceNumber = sequenceNumber;
    }

    @Override
    public void seek(long nextRtpTimestamp, long timeUs) {
        this.firstReceivedTimestamp = nextRtpTimestamp;
        this.startTimeOffsetUs = timeUs;
    }

    public static int getFrameSize(int frameType, boolean isWideBand) {
        Assertions.checkArgument((frameType >= 0 && frameType <= 8 || frameType == 15 ? 1 : 0) != 0, (Object)("Illegal AMR " + (isWideBand ? "WB" : "NB") + " frame type " + frameType));
        return isWideBand ? AMR_WB_FRAME_TYPE_INDEX_TO_FRAME_SIZE[frameType] : AMR_NB_FRAME_TYPE_INDEX_TO_FRAME_SIZE[frameType];
    }
}

