/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer.workmanager;

import android.content.Context;
import android.content.Intent;
import androidx.annotation.RequiresApi;
import androidx.media3.common.MediaLibraryInfo;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.Log;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import androidx.media3.exoplayer.scheduler.Requirements;
import androidx.media3.exoplayer.scheduler.Scheduler;
import androidx.work.Constraints;
import androidx.work.Data;
import androidx.work.ExistingWorkPolicy;
import androidx.work.ListenableWorker;
import androidx.work.NetworkType;
import androidx.work.OneTimeWorkRequest;
import androidx.work.WorkManager;
import androidx.work.Worker;
import androidx.work.WorkerParameters;

@UnstableApi
public final class WorkManagerScheduler
implements Scheduler {
    private static final String TAG = "WorkManagerScheduler";
    private static final String KEY_SERVICE_ACTION = "service_action";
    private static final String KEY_SERVICE_PACKAGE = "service_package";
    private static final String KEY_REQUIREMENTS = "requirements";
    private static final int SUPPORTED_REQUIREMENTS;
    private final WorkManager workManager;
    private final String workName;

    public WorkManagerScheduler(Context context, String workName) {
        this.workName = workName;
        this.workManager = WorkManager.getInstance((Context)context.getApplicationContext());
    }

    public boolean schedule(Requirements requirements, String servicePackage, String serviceAction) {
        Constraints constraints = WorkManagerScheduler.buildConstraints(requirements);
        Data inputData = WorkManagerScheduler.buildInputData(requirements, servicePackage, serviceAction);
        OneTimeWorkRequest workRequest = WorkManagerScheduler.buildWorkRequest(constraints, inputData);
        this.workManager.enqueueUniqueWork(this.workName, ExistingWorkPolicy.REPLACE, workRequest);
        return true;
    }

    public boolean cancel() {
        this.workManager.cancelUniqueWork(this.workName);
        return true;
    }

    public Requirements getSupportedRequirements(Requirements requirements) {
        return requirements.filterRequirements(SUPPORTED_REQUIREMENTS);
    }

    private static Constraints buildConstraints(Requirements requirements) {
        Requirements filteredRequirements = requirements.filterRequirements(SUPPORTED_REQUIREMENTS);
        if (!filteredRequirements.equals((Object)requirements)) {
            Log.w((String)TAG, (String)("Ignoring unsupported requirements: " + (filteredRequirements.getRequirements() ^ requirements.getRequirements())));
        }
        Constraints.Builder builder = new Constraints.Builder();
        if (requirements.isUnmeteredNetworkRequired()) {
            builder.setRequiredNetworkType(NetworkType.UNMETERED);
        } else if (requirements.isNetworkRequired()) {
            builder.setRequiredNetworkType(NetworkType.CONNECTED);
        } else {
            builder.setRequiredNetworkType(NetworkType.NOT_REQUIRED);
        }
        if (Util.SDK_INT >= 23 && requirements.isIdleRequired()) {
            WorkManagerScheduler.setRequiresDeviceIdle(builder);
        }
        if (requirements.isChargingRequired()) {
            builder.setRequiresCharging(true);
        }
        if (requirements.isStorageNotLowRequired()) {
            builder.setRequiresStorageNotLow(true);
        }
        return builder.build();
    }

    @RequiresApi(value=23)
    private static void setRequiresDeviceIdle(Constraints.Builder builder) {
        builder.setRequiresDeviceIdle(true);
    }

    private static Data buildInputData(Requirements requirements, String servicePackage, String serviceAction) {
        Data.Builder builder = new Data.Builder();
        builder.putInt(KEY_REQUIREMENTS, requirements.getRequirements());
        builder.putString(KEY_SERVICE_PACKAGE, servicePackage);
        builder.putString(KEY_SERVICE_ACTION, serviceAction);
        return builder.build();
    }

    private static OneTimeWorkRequest buildWorkRequest(Constraints constraints, Data inputData) {
        OneTimeWorkRequest.Builder builder = new OneTimeWorkRequest.Builder(SchedulerWorker.class);
        builder.setConstraints(constraints);
        builder.setInputData(inputData);
        return (OneTimeWorkRequest)builder.build();
    }

    static {
        MediaLibraryInfo.registerModule((String)"media3.exoplayer.workmanager");
        SUPPORTED_REQUIREMENTS = 3 | (Util.SDK_INT >= 23 ? 4 : 0) | 8 | 0x10;
    }

    public static final class SchedulerWorker
    extends Worker {
        private final WorkerParameters workerParams;
        private final Context context;

        public SchedulerWorker(Context context, WorkerParameters workerParams) {
            super(context, workerParams);
            this.workerParams = workerParams;
            this.context = context;
        }

        public ListenableWorker.Result doWork() {
            Data inputData = (Data)Assertions.checkNotNull((Object)this.workerParams.getInputData());
            Requirements requirements = new Requirements(inputData.getInt(WorkManagerScheduler.KEY_REQUIREMENTS, 0));
            int notMetRequirements = requirements.getNotMetRequirements(this.context);
            if (notMetRequirements == 0) {
                String serviceAction = (String)Assertions.checkNotNull((Object)inputData.getString(WorkManagerScheduler.KEY_SERVICE_ACTION));
                String servicePackage = (String)Assertions.checkNotNull((Object)inputData.getString(WorkManagerScheduler.KEY_SERVICE_PACKAGE));
                Intent intent = new Intent(serviceAction).setPackage(servicePackage);
                Util.startForegroundService((Context)this.context, (Intent)intent);
                return ListenableWorker.Result.success();
            }
            Log.w((String)WorkManagerScheduler.TAG, (String)("Requirements not met: " + notMetRequirements));
            return ListenableWorker.Result.retry();
        }
    }
}

