/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.extractor.text;

import androidx.annotation.Nullable;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.decoder.DecoderInputBuffer;
import androidx.media3.decoder.DecoderOutputBuffer;
import androidx.media3.decoder.SimpleDecoder;
import androidx.media3.extractor.text.Subtitle;
import androidx.media3.extractor.text.SubtitleDecoder;
import androidx.media3.extractor.text.SubtitleDecoderException;
import androidx.media3.extractor.text.SubtitleInputBuffer;
import androidx.media3.extractor.text.SubtitleOutputBuffer;
import java.nio.ByteBuffer;

@UnstableApi
public abstract class SimpleSubtitleDecoder
extends SimpleDecoder<SubtitleInputBuffer, SubtitleOutputBuffer, SubtitleDecoderException>
implements SubtitleDecoder {
    private final String name;

    protected SimpleSubtitleDecoder(String name) {
        super((DecoderInputBuffer[])new SubtitleInputBuffer[2], (DecoderOutputBuffer[])new SubtitleOutputBuffer[2]);
        this.name = name;
        this.setInitialInputBufferSize(1024);
    }

    public final String getName() {
        return this.name;
    }

    @Override
    public void setPositionUs(long positionUs) {
    }

    protected final SubtitleInputBuffer createInputBuffer() {
        return new SubtitleInputBuffer();
    }

    protected final SubtitleOutputBuffer createOutputBuffer() {
        return new SubtitleOutputBuffer(){

            public void release() {
                SimpleSubtitleDecoder.this.releaseOutputBuffer(this);
            }
        };
    }

    protected final SubtitleDecoderException createUnexpectedDecodeException(Throwable error) {
        return new SubtitleDecoderException("Unexpected decode error", error);
    }

    @Nullable
    protected final SubtitleDecoderException decode(SubtitleInputBuffer inputBuffer, SubtitleOutputBuffer outputBuffer, boolean reset) {
        try {
            ByteBuffer inputData = (ByteBuffer)Assertions.checkNotNull((Object)inputBuffer.data);
            Subtitle subtitle = this.decode(inputData.array(), inputData.limit(), reset);
            outputBuffer.setContent(inputBuffer.timeUs, subtitle, inputBuffer.subsampleOffsetUs);
            outputBuffer.clearFlag(Integer.MIN_VALUE);
            return null;
        }
        catch (SubtitleDecoderException e) {
            return e;
        }
    }

    protected abstract Subtitle decode(byte[] var1, int var2, boolean var3) throws SubtitleDecoderException;
}

