/*
 * Decompiled with CFR 0.152.
 */
package com.renderheads.AVPro.Video;

import android.app.Activity;
import android.app.ActivityManager;
import android.content.Context;
import android.content.pm.FeatureInfo;
import android.view.Surface;
import com.renderheads.AVPro.Video.AVPLog;
import com.renderheads.AVPro.Video.Manager$1;
import com.renderheads.AVPro.Video.Player_Base;
import com.renderheads.AVPro.Video.Player_ExoPlayer;
import com.renderheads.AVPro.Video.Player_MediaPlayer;
import java.io.UnsupportedEncodingException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.crypto.Cipher;
import javax.crypto.SecretKeyFactory;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

public class Manager {
    public static final int MEDIAPLAYER = 1;
    public static final int EXOPLAYER = 2;
    private static Map<Integer, Player_Base> s_Players = new HashMap<Integer, Player_Base>();
    private static Random s_PlayerIndexRandom = new Random();
    private static Random s_Random = new Random();
    private static Context s_Context = null;
    private static Manager s_Interface = null;
    private static double[] m_aDefaultStateValues = new double[9];
    private static double[] m_aDefaultAssetInfo = new double[8];
    private static double[] m_aDefaultCachedMediaStatusValues = new double[2];

    public Manager() {
        if (s_Interface == null) {
            s_Interface = this;
        }
    }

    public static void Deinitialise() {
        s_Interface = null;
    }

    public static void SetContext(Context context) {
        s_Context = context;
    }

    /*
     * WARNING - void declaration
     */
    public static int MakePlayer(int n, boolean bl, int n2, int n3, int n4, int n5, boolean bl2, int n6, int n7, int n8, int n9, int n10, double d, double d2, boolean bl3, boolean bl4) {
        void var17_23;
        int n11;
        boolean bl5 = false;
        int n12 = 1;
        int n13 = 10000;
        for (int i = 0; n12 != 0 && i < n13; ++i) {
            n12 = s_PlayerIndexRandom.nextInt(65534) + 1;
            boolean bl6 = s_Players.containsKey(n12);
            if (!bl6) {
                n11 = n12;
            }
            n12 = bl6 ? 1 : 0;
        }
        AVPLog.Debug("[AVProVideo] : MakePlayer: index is " + n11, new Object[0]);
        if (n11 < 1) {
            AVPLog.Error("[AVProVideo] : MakePlayer: FAILED to find available player index", new Object[0]);
            return n11;
        }
        if (n != 1) {
            if (n == 2) {
                Player_ExoPlayer player_ExoPlayer;
                Player_ExoPlayer player_ExoPlayer2 = player_ExoPlayer;
                double d3 = d;
                Player_ExoPlayer player_ExoPlayer3 = player_ExoPlayer2;
                player_ExoPlayer3(n11, s_Random, true);
                player_ExoPlayer3.SetShowPosterFrame(false);
                Context context = s_Context;
                d = n10;
                float f = (float)d3;
                float f2 = (float)d2;
                player_ExoPlayer.Initialise(context, bl, n2, n3, n4, n5, bl2, n6, n7, n8, n9, d, f, f2, (boolean)var17_23);
                s_Players.put(new Integer(n11), player_ExoPlayer2);
            }
        } else {
            Player_MediaPlayer player_MediaPlayer;
            Player_MediaPlayer player_MediaPlayer2 = player_MediaPlayer;
            double d4 = d;
            player_MediaPlayer2(n11, s_Random, true);
            Context context = s_Context;
            d = n10;
            float f = (float)d4;
            float f3 = (float)d2;
            player_MediaPlayer.Initialise(context, bl, n2, n3, n4, n5, bl2, n6, n7, n8, n9, d, f, f3, (boolean)var17_23);
            s_Players.put(new Integer(n11), player_MediaPlayer2);
        }
        return n11;
    }

    public static void DestroyPlayer(int n) {
        Player_Base player_Base = Manager.GetAVProClassForPlayerIndex(n);
        if (player_Base != null) {
            int n2 = n;
            player_Base.Deinitialise();
            Manager.RemovePlayer(n2);
            Manager.nativeDestroy(n2);
        }
    }

    private static void RemovePlayer(int n) {
        AVPLog.Debug("[AVProVideo] : RemovePlayer : playerIndex = " + n, new Object[0]);
        if (s_Players.containsKey(n)) {
            s_Players.remove(n);
        }
    }

    private static Player_Base GetAVProClassForPlayerIndex(int n) {
        Player_Base player_Base = null;
        Map<Integer, Player_Base> map = s_Players;
        if (map != null && map.containsKey(n)) {
            player_Base = s_Players.get(n);
        }
        return player_Base;
    }

    public static int Player_GetVideoDimensions(int n) {
        Player_Base player_Base = Manager.GetAVProClassForPlayerIndex(n);
        if (player_Base != null) {
            return player_Base.GetVideoDimensions();
        }
        return 0;
    }

    public static void Player_Update(int n) {
        ((Activity)s_Context).runOnUiThread((Runnable)new Manager$1(n));
    }

    public static double[] Player_GetState(int n) {
        Player_Base player_Base = Manager.GetAVProClassForPlayerIndex(n);
        if (player_Base != null) {
            return player_Base.GetCurrentStateValues();
        }
        return m_aDefaultStateValues;
    }

    public static void Player_CloseVideo(int n) {
        AVPLog.Debug("[AVProVideo] : Player_CloseVideo", new Object[0]);
        Player_Base player_Base = Manager.GetAVProClassForPlayerIndex(n);
        if (player_Base != null) {
            player_Base.CloseVideo();
        }
    }

    public static void Player_Seek(int n, double d, double d2, double d3) {
        Player_Base player_Base = Manager.GetAVProClassForPlayerIndex(n);
        if (player_Base != null) {
            long l;
            long l2 = (long)(d2 * 1000000.0);
            if (l2 < 0L) {
                l2 = Long.MAX_VALUE;
            }
            if ((l = (long)(d3 * 1000000.0)) < 0L) {
                l = Long.MAX_VALUE;
            }
            player_Base.SeekWithTolerances(d, l2, l);
        }
    }

    public static void Player_SetHeadRotation(int n, double d, double d2, double d3, double d4) {
        Player_Base player_Base = Manager.GetAVProClassForPlayerIndex(n);
        if (player_Base != null) {
            float f = (float)d;
            float f2 = (float)d2;
            float f3 = (float)d3;
            float f4 = (float)d4;
            player_Base.SetHeadRotation(f, f2, f3, f4);
        }
    }

    public static void Player_SetPositionTrackingEnabled(int n, boolean bl) {
        Player_Base player_Base = Manager.GetAVProClassForPlayerIndex(n);
        if (player_Base != null) {
            player_Base.SetPositionTrackingEnabled(bl);
        }
    }

    public static void Player_SetAudioFocusEnabled(int n, boolean bl) {
        Player_Base player_Base = Manager.GetAVProClassForPlayerIndex(n);
        if (player_Base != null) {
            player_Base.SetFocusEnabled(bl);
        }
    }

    public static void Player_SetAudioFocusProperties(int n, double d, double d2) {
        Player_Base player_Base = Manager.GetAVProClassForPlayerIndex(n);
        if (player_Base != null) {
            float f = (float)d;
            player_Base.SetFocusProps(f, (float)d2);
        }
    }

    public static void Player_SetAudioFocusRotation(int n, double d, double d2, double d3, double d4) {
        Player_Base player_Base = Manager.GetAVProClassForPlayerIndex(n);
        if (player_Base != null) {
            float f = (float)d;
            float f2 = (float)d2;
            float f3 = (float)d3;
            float f4 = (float)d4;
            player_Base.SetFocusRotation(f, f2, f3, f4);
        }
    }

    public static void Player_ResetAudioFocus(int n) {
        Player_Base player_Base = Manager.GetAVProClassForPlayerIndex(n);
        if (player_Base != null) {
            Player_Base player_Base2 = player_Base;
            player_Base2.SetFocusProps(0.0f, 90.0f);
            player_Base2.SetFocusEnabled(false);
            player_Base2.SetFocusRotation(0.0f, 0.0f, 0.0f, 1.0f);
        }
    }

    public static void Player_SetKeyServerAuthToken(int n, String string) {
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = objectArray;
        objectArray[0] = n;
        objectArray[1] = string;
        AVPLog.Debug("[AVProVideo] : Player_SetKeyServerAuthToken : playerIndex = {0} : token = {1}", objectArray2);
        Player_Base player_Base = Manager.GetAVProClassForPlayerIndex(n);
        if (player_Base != null) {
            player_Base.SetKeyServerAuthToken(string);
        }
    }

    public static void Player_SetDecryptionKey(int n, byte[] byArray, int n2) {
        Object[] objectArray = new Object[3];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = n;
        objectArray2[1] = byArray;
        objectArray[2] = n2;
        AVPLog.Debug("[AVProVideo] : Player_SetDecryptionKey : playerIndex = {0} : token = {1} : length = {2}", objectArray2);
        Player_Base player_Base = Manager.GetAVProClassForPlayerIndex(n);
        if (player_Base != null) {
            player_Base.SetOverrideDecryptionKey(byArray);
        }
    }

    public static boolean Player_OpenURL(int n, String string, String string2, int n2, int n3) {
        boolean bl = false;
        Object[] objectArray = new Object[3];
        Object[] objectArray2 = objectArray;
        objectArray[0] = n;
        objectArray[1] = string;
        objectArray[2] = string2;
        AVPLog.Debug("[AVProVideo] : Player_OpenURL : playerIndex = {0} : url = {1} : header = {2}", objectArray2);
        Player_Base player_Base = Manager.GetAVProClassForPlayerIndex(n);
        if (player_Base != null) {
            Player_Base player_Base2 = player_Base;
            player_Base2.SetSetting_FileOffset(n2);
            player_Base2.SetSetting_ForcedFileFormat(n3);
            bl = player_Base2.OpenVideoFromFile(string, string2);
        }
        return bl;
    }

    public static byte[] Player_GetCurrentTextCueAsByteArray(int n) {
        byte[] byArray = null;
        Player_Base player_Base = Manager.GetAVProClassForPlayerIndex(n);
        if (player_Base != null) {
            try {
                byArray = player_Base.GetCurrentTextCue().getBytes("UTF-16LE");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Object[] objectArray = new Object[1];
                Object[] objectArray2 = objectArray;
                objectArray[0] = ((Object)unsupportedEncodingException).toString();
                AVPLog.Debug("[AVProVideo] : GetCurrentTextCueAsByteArray : getBytes has thrown an exception : {0}", objectArray2);
            }
        }
        return byArray;
    }

    public static void Player_SetRate(int n, float f) {
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = n;
        objectArray[1] = Float.valueOf(f);
        AVPLog.Debug("[AVProVideo] : Player_SetRate : playerIndex = {0} : rate = {1}", objectArray2);
        Player_Base player_Base = Manager.GetAVProClassForPlayerIndex(n);
        if (player_Base != null) {
            if (f == 0.0f) {
                if (!player_Base.IsPaused()) {
                    player_Base.Pause();
                }
            } else if (!player_Base.IsPlaying()) {
                player_Base.Play();
            }
            player_Base.SetPlaybackRate(f);
        }
    }

    public static void Player_SetVolume(int n, float f) {
        Player_Base player_Base = Manager.GetAVProClassForPlayerIndex(n);
        if (player_Base != null) {
            player_Base.SetVolume(f);
        }
    }

    public static boolean Player_SetTrack(int n, int n2, int n3) {
        int n4 = n;
        Object[] objectArray = new Object[3];
        Object object = objectArray;
        object[0] = n;
        object[1] = n2;
        objectArray[2] = n3;
        AVPLog.Debug("[AVProVideo] : Player_SetTrack : playerIndex = {0} : type = {1} : index = {2}", (Object[])object);
        n = 0;
        object = Manager.GetAVProClassForPlayerIndex(n4);
        if (object != null) {
            if (n2 != 0) {
                if (n2 != 1) {
                    if (n2 == 2) {
                        ((Player_Base)object).SetTextTrack(n3);
                        n = 1;
                    }
                } else {
                    ((Player_Base)object).SetAudioTrack(n3);
                    n = 1;
                }
            } else {
                ((Player_Base)object).SetVideoTrack(n3);
                n = 1;
            }
        }
        return n != 0;
    }

    public static double[] Player_GetAssetInfo(int n) {
        AVPLog.Debug("[AVProVideo] : Player_GetAssetInfo", new Object[0]);
        Player_Base player_Base = Manager.GetAVProClassForPlayerIndex(n);
        if (player_Base != null) {
            return player_Base.GetAssetInfo();
        }
        return m_aDefaultAssetInfo;
    }

    public static Object[] Player_GetVideoTrackInfo(int n, int n2) {
        AVPLog.Verbose("[AVProVideo] : Player_GetVideoTrackInfo", new Object[0]);
        Player_Base player_Base = Manager.GetAVProClassForPlayerIndex(n);
        if (player_Base != null) {
            return player_Base.GetVideoTrackInfoNew(n2);
        }
        return null;
    }

    public static Object[] Player_GetAudioTrackInfo(int n, int n2) {
        AVPLog.Debug("[AVProVideo] : Player_GetAudioTrackInfo", new Object[0]);
        Player_Base player_Base = Manager.GetAVProClassForPlayerIndex(n);
        if (player_Base != null) {
            return player_Base.GetAudioTrackInfoNew(n2);
        }
        return null;
    }

    public static Object[] Player_GetTextTrackInfo(int n, int n2) {
        AVPLog.Debug("[AVProVideo] : Player_GetTextTrackInfo", new Object[0]);
        Player_Base player_Base = Manager.GetAVProClassForPlayerIndex(n);
        if (player_Base != null) {
            return player_Base.GetTextTrackInfoNew(n2);
        }
        return null;
    }

    public static void Player_SetFlags(int n, int n2) {
        AVPLog.Debug("Player_SetFlags - playerIndex: {0}, flags: {1}", new Object[0]);
        Player_Base player_Base = Manager.GetAVProClassForPlayerIndex(n);
        if (player_Base != null) {
            boolean bl = (n2 & 1) != 0;
            player_Base.SetLooping(bl);
            n2 = (n2 & 2) != 0 ? 1 : 0;
            player_Base.MuteAudio(n2 != 0);
        }
    }

    public static void Player_SetPlayerSettings(int n, boolean bl, int n2, int n3, int n4, boolean bl2, boolean bl3) {
        AVPLog.Debug("[AVProVideo] : Player_SetPlayerSettings", new Object[0]);
        Player_Base player_Base = Manager.GetAVProClassForPlayerIndex(n);
        if (player_Base != null) {
            Player_Base player_Base2 = player_Base;
            player_Base2.SetSetting_AudioSubsystem(n2);
            player_Base2.SetSetting_Audio360ChannelIndex(n3);
            player_Base2.SetSetting_Audio360LatencyMS(n4);
            player_Base2.SetSetting_ForceRtpTCP(bl2);
            player_Base2.SetSetting_ForceEnableMediaCodecAsynchronousQueueing(bl3);
        }
    }

    public static void Player_AddMediaToCache(int n, String string, String string2, double d, int n2, int n3) {
        AVPLog.Debug("[AVProVideo] : Player_AddMediaToCache", new Object[0]);
        Player_Base player_Base = Manager.GetAVProClassForPlayerIndex(n);
        if (player_Base != null) {
            player_Base.AddMediaToCache(string, string2, d, n2, n3);
        }
    }

    public static void Player_CancelDownloadOfMediaToCache(int n, String string) {
        AVPLog.Debug("[AVProVideo] : Player_CancelDownloadOfMediaToCache", new Object[0]);
        Player_Base player_Base = Manager.GetAVProClassForPlayerIndex(n);
        if (player_Base != null) {
            player_Base.CancelDownloadOfMediaToCache(string);
        }
    }

    public static void Player_RemoveMediaFromCache(int n, String string) {
        AVPLog.Debug("[AVProVideo] : Player_RemoveMediaFromCache", new Object[0]);
        Player_Base player_Base = Manager.GetAVProClassForPlayerIndex(n);
        if (player_Base != null) {
            player_Base.RemoveMediaFromCache(string);
        }
    }

    public static double[] Player_GetCachedMediaStatus(int n, String string) {
        Player_Base player_Base = Manager.GetAVProClassForPlayerIndex(n);
        if (player_Base != null) {
            return player_Base.GetCachedMediaStatus(string);
        }
        return m_aDefaultCachedMediaStatusValues;
    }

    public static void RenderPlayer(int n) {
        if (s_Interface == null) {
            return;
        }
        Player_Base player_Base = Manager.GetAVProClassForPlayerIndex(n);
        if (player_Base != null) {
            player_Base.Render();
        }
    }

    public static void WaitForNewFramePlayer(int n) {
        Player_Base player_Base = Manager.GetAVProClassForPlayerIndex(n);
        if (player_Base != null) {
            player_Base.WaitForNewFrame();
        }
    }

    public static int _GetCurrentAudioTrackNumChannels(int n) {
        Player_Base player_Base = Manager.GetAVProClassForPlayerIndex(n);
        if (player_Base != null) {
            return player_Base.GetCurrentAudioTrackNumChannels();
        }
        return 0;
    }

    public static float[] _GrabAudio(int n, int n2, int n3) {
        Player_Base player_Base = Manager.GetAVProClassForPlayerIndex(n);
        if (player_Base != null) {
            return player_Base.GrabAudio(n2, n3);
        }
        return null;
    }

    public static int _GetWidth(int n) {
        int n2 = n;
        n = 0;
        Player_Base player_Base = Manager.GetAVProClassForPlayerIndex(n2);
        if (player_Base != null) {
            n = player_Base.GetWidth();
        }
        return n;
    }

    public static int _GetHeight(int n) {
        int n2 = n;
        n = 0;
        Player_Base player_Base = Manager.GetAVProClassForPlayerIndex(n2);
        if (player_Base != null) {
            n = player_Base.GetHeight();
        }
        return n;
    }

    public static double _GetDuration(int n) {
        double d = 0.0;
        Player_Base player_Base = Manager.GetAVProClassForPlayerIndex(n);
        if (player_Base != null) {
            d = player_Base.GetDurationS();
        }
        return d;
    }

    public static int _GetLastErrorCode(int n) {
        int n2 = n;
        n = 0;
        Player_Base player_Base = Manager.GetAVProClassForPlayerIndex(n2);
        if (player_Base != null) {
            n = player_Base.GetLastErrorCode();
        }
        return n;
    }

    public static int _GetFrameCount(int n) {
        int n2 = n;
        n = 0;
        Player_Base player_Base = Manager.GetAVProClassForPlayerIndex(n2);
        if (player_Base != null) {
            n = player_Base.GetFrameCount();
        }
        return n;
    }

    public static float _GetVideoDisplayRate(int n) {
        float f = 0.0f;
        Player_Base player_Base = Manager.GetAVProClassForPlayerIndex(n);
        if (player_Base != null) {
            f = player_Base.GetDisplayRate();
        }
        return f;
    }

    public static boolean _CanPlay(int n) {
        int n2 = n;
        n = 0;
        Player_Base player_Base = Manager.GetAVProClassForPlayerIndex(n2);
        if (player_Base != null) {
            n = player_Base.CanPlay() ? 1 : 0;
        }
        return n != 0;
    }

    public static boolean _IsPlaying(int n) {
        int n2 = n;
        n = 0;
        Player_Base player_Base = Manager.GetAVProClassForPlayerIndex(n2);
        if (player_Base != null) {
            n = player_Base.IsPlaying() ? 1 : 0;
        }
        return n != 0;
    }

    public static boolean _IsPaused(int n) {
        int n2 = n;
        n = 0;
        Player_Base player_Base = Manager.GetAVProClassForPlayerIndex(n2);
        if (player_Base != null) {
            n = player_Base.IsPaused() ? 1 : 0;
        }
        return n != 0;
    }

    public static double[] Player_GetSeekableTimeRanges(int n) {
        double[] dArray = null;
        Player_Base player_Base = Manager.GetAVProClassForPlayerIndex(n);
        if (player_Base != null) {
            dArray = player_Base.GetSeekableTimeRanges();
        }
        return dArray;
    }

    public static double[] Player_GetBufferedTimeRanges(int n) {
        double[] dArray = null;
        Player_Base player_Base = Manager.GetAVProClassForPlayerIndex(n);
        if (player_Base != null) {
            dArray = player_Base.GetBufferedTimeRanges();
        }
        return dArray;
    }

    public static void _Update(int n) {
        Player_Base player_Base = Manager.GetAVProClassForPlayerIndex(n);
        if (player_Base != null) {
            player_Base.Update();
        }
    }

    public static int _GetCurrentVideoTrackBitrate(int n) {
        int n2 = n;
        n = 0;
        Player_Base player_Base = Manager.GetAVProClassForPlayerIndex(n2);
        if (player_Base != null) {
            n = player_Base.GetCurrentVideoTrackBitrate();
        }
        return n;
    }

    public static byte[] SHA256(byte[] byArray) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            messageDigest.update(byArray);
            return messageDigest.digest();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = noSuchAlgorithmException.getLocalizedMessage();
            AVPLog.Error("SHA256: no such algorithm, exception: {0}", objectArray2);
            return null;
        }
    }

    public static int KeyDerivationPBKDF(ByteBuffer object, ByteBuffer objectArray, int n, ByteBuffer byteBuffer) {
        byte[] byArray;
        CharBuffer charBuffer;
        SecretKeyFactory secretKeyFactory;
        ByteBuffer byteBuffer2;
        try {
            byteBuffer2 = byteBuffer;
            secretKeyFactory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA256");
            charBuffer = StandardCharsets.UTF_8.decode((ByteBuffer)object);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Object[] objectArray2 = new Object[2];
            objectArray = objectArray2;
            objectArray[0] = "PBKDF2WithHmacSHA256";
            objectArray2[1] = noSuchAlgorithmException.getLocalizedMessage();
            AVPLog.Error("No such algorithm {0}, error: {1}", objectArray);
            return -1;
        }
        char[] cArray = new char[((Buffer)object).capacity()];
        object = cArray;
        charBuffer.get(cArray);
        byte[] byArray2 = new byte[objectArray.capacity()];
        objectArray = byArray2;
        objectArray.get(byArray2);
        int n2 = byteBuffer.capacity() * 8;
        try {
            byArray = secretKeyFactory.generateSecret(new PBEKeySpec((char[])object, (byte[])objectArray, n, n2)).getEncoded();
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            Object[] objectArray3 = new Object[1];
            objectArray = objectArray3;
            objectArray3[0] = invalidKeySpecException.getLocalizedMessage();
            AVPLog.Error("KeyDerivationPBKDF: invalid key spec, error: {0}", objectArray);
            return -1;
        }
        object = byArray;
        byteBuffer2.put(byArray);
        return ((Object)object).length;
    }

    public static Cipher CreateCryptor(int n, byte[] object, byte[] byArray) {
        IvParameterSpec ivParameterSpec;
        SecretKeySpec secretKeySpec;
        Cipher cipher;
        if (n != 2) {
            AVPLog.Debug("Only decrypt mode is supported currently", new Object[0]);
            return null;
        }
        try {
            cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[1];
            object = objectArray;
            objectArray[0] = exception.getLocalizedMessage();
            AVPLog.Error("Failed to create cipher, exception: {0}", object);
            return null;
        }
        SecretKeySpec secretKeySpec2 = secretKeySpec;
        secretKeySpec = new SecretKeySpec((byte[])object, "AES");
        object = ivParameterSpec;
        try {
            ivParameterSpec = new IvParameterSpec(byArray);
            cipher.init(n, (Key)secretKeySpec2, (AlgorithmParameterSpec)object);
            return cipher;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[1];
            object = objectArray;
            objectArray[0] = exception.getLocalizedMessage();
            AVPLog.Error("Failed to initialise cipher, exception: {0}", object);
            return null;
        }
    }

    public static int UpdateCryptor(Cipher cipher, ByteBuffer objectArray, ByteBuffer byteBuffer) {
        try {
            return cipher.update((ByteBuffer)objectArray, byteBuffer);
        }
        catch (Exception exception) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = exception;
            AVPLog.Error("An unknown exception occurred, error: {0}", objectArray);
            return -1;
        }
        catch (ShortBufferException shortBufferException) {
            Object[] objectArray3 = new Object[1];
            objectArray = objectArray3;
            objectArray3[0] = shortBufferException;
            AVPLog.Error("outBuf is not large enough, error: {0}", objectArray);
            return -1;
        }
        catch (ProviderException providerException) {
            Object[] objectArray4 = new Object[1];
            objectArray = objectArray4;
            objectArray4[0] = providerException.getLocalizedMessage();
            AVPLog.Error("error: {0}", objectArray);
            Object[] objectArray5 = new Object[1];
            objectArray = objectArray5;
            objectArray5[0] = providerException.getCause();
            AVPLog.Error("cause: {0}", objectArray);
            return -1;
        }
    }

    public static int FinaliseCryptor(Cipher object, ByteBuffer objectArray) {
        byte[] byArray;
        Object[] objectArray2;
        try {
            objectArray2 = objectArray;
            byArray = ((Cipher)object).doFinal();
        }
        catch (Exception exception) {
            Object[] objectArray3 = new Object[1];
            objectArray = objectArray3;
            objectArray3[0] = exception.getLocalizedMessage();
            AVPLog.Error("Failed to finalise, error: {0}", objectArray);
            return -1;
        }
        object = byArray;
        objectArray2.put(byArray);
        return ((Object)object).length;
    }

    private static int getGlVersionFromDeviceConfig(Context context) {
        int n = 1;
        if (context != null && (context = (ActivityManager)context.getSystemService("activity")) != null && (context = context.getDeviceConfigurationInfo()) != null) {
            int n2 = context.reqGlEsVersion;
            if (n2 >= 196608) {
                n = 3;
            } else if (n2 >= 131072) {
                n = 2;
            }
        }
        return n;
    }

    private static int getVersionFromPackageManager(Context featureInfoArray) {
        if (featureInfoArray != null && (featureInfoArray = featureInfoArray.getPackageManager().getSystemAvailableFeatures()) != null && featureInfoArray.length > 0) {
            for (FeatureInfo featureInfo : featureInfoArray) {
                if (featureInfo.name != null) continue;
                int n = featureInfo.reqGlEsVersion;
                if (n != 0) {
                    return Manager.getMajorVersion(n);
                }
                return 1;
            }
        }
        return 1;
    }

    private static int getMajorVersion(int n) {
        return (n & 0xFFFF0000) >> 16;
    }

    private static native void nativeInit();

    private static native void nativeDestroy(int var0);

    public static native void AudioCaptureBuffer_Initialise(int var0, int var1);

    public static native void AudioCaptureBuffer_Destroy(int var0);

    public static native boolean AudioCaptureBuffer_OfferBytes(int var0, float[] var1, int var2);

    public static native int AudioCaptureBuffer_GetSpaceUsed(int var0);

    public static native int AudioCaptureBuffer_Poll(float[] var0, int var1);

    public static native void AudioCaptureBuffer_Reset(int var0);

    public static native Surface CreateSurface(int var0, int var1, int var2);

    public static /* synthetic */ Player_Base access$000(int n) {
        return Manager.GetAVProClassForPlayerIndex(n);
    }

    static {
        System.loadLibrary("AVProVideo2Native");
        Manager.nativeInit();
    }

    public void SetPlayerSurface(int n, Surface surface) {
        Object object = Manager.GetAVProClassForPlayerIndex(n);
        if (object == null) {
            Object[] objectArray = new Object[1];
            object = objectArray;
            objectArray[0] = n;
            AVPLog.Error("Failed to get player with id: {0}", object);
            return;
        }
        object.SetSurface(surface);
    }
}

