/*
 * Decompiled with CFR 0.152.
 */
package com.twobigears.audio360;

import com.twobigears.audio360.AssetAccessMode;
import com.twobigears.audio360.AssetDescriptor;
import com.twobigears.audio360.Audio360JNI;
import com.twobigears.audio360.AudioAssetHandle;
import com.twobigears.audio360.AudioFormatDecoder;
import com.twobigears.audio360.EngineError;
import com.twobigears.audio360.IOStream;

public class AudioAssetManager {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected AudioAssetManager(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(AudioAssetManager obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                Audio360JNI.delete_AudioAssetManager(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public EngineError loadAudio(AudioAssetHandle handle, String fileNameAndPath, AssetDescriptor ad, AssetAccessMode mode) {
        return EngineError.swigToEnum(Audio360JNI.AudioAssetManager_loadAudio(this.swigCPtr, this, AudioAssetHandle.getCPtr(handle), handle, fileNameAndPath, AssetDescriptor.getCPtr(ad), ad, mode.swigValue()));
    }

    public IOStream getNewStream(AudioAssetHandle handle) {
        long cPtr = Audio360JNI.AudioAssetManager_getNewStream(this.swigCPtr, this, AudioAssetHandle.getCPtr(handle), handle);
        return cPtr == 0L ? null : new IOStream(cPtr, false);
    }

    public AudioFormatDecoder getNewDecoder(AudioAssetHandle handle, int bufferSize, float sampleRate) {
        long cPtr = Audio360JNI.AudioAssetManager_getNewDecoder(this.swigCPtr, this, AudioAssetHandle.getCPtr(handle), handle, bufferSize, sampleRate);
        return cPtr == 0L ? null : new AudioFormatDecoder(cPtr, false);
    }

    public boolean unloadAudio(AudioAssetHandle handle) {
        return Audio360JNI.AudioAssetManager_unloadAudio(this.swigCPtr, this, AudioAssetHandle.getCPtr(handle), handle);
    }

    public AssetAccessMode getMode(AudioAssetHandle handle) {
        return AssetAccessMode.swigToEnum(Audio360JNI.AudioAssetManager_getMode(this.swigCPtr, this, AudioAssetHandle.getCPtr(handle), handle));
    }

    public String getFormat(AudioAssetHandle handle) {
        return Audio360JNI.AudioAssetManager_getFormat(this.swigCPtr, this, AudioAssetHandle.getCPtr(handle), handle);
    }

    public long getBytesInMemory() {
        return Audio360JNI.AudioAssetManager_getBytesInMemory(this.swigCPtr, this);
    }
}

