/*
 * Decompiled with CFR 0.152.
 */
package com.twobigears.audio360;

import android.content.Context;
import com.twobigears.audio360.Audio360JNI;
import com.twobigears.audio360.AudioAssetManager;
import com.twobigears.audio360.AudioObject;
import com.twobigears.audio360.ChannelMap;
import com.twobigears.audio360.EngineError;
import com.twobigears.audio360.EngineInitSettings;
import com.twobigears.audio360.EngineStatistics;
import com.twobigears.audio360.EventListener;
import com.twobigears.audio360.LoudnessStatistics;
import com.twobigears.audio360.Options;
import com.twobigears.audio360.PCMType;
import com.twobigears.audio360.SWIGTYPE_p_f_p_float_size_t_size_t_p_void__void;
import com.twobigears.audio360.SWIGTYPE_p_p_void;
import com.twobigears.audio360.SWIGTYPE_p_void;
import com.twobigears.audio360.SpatDecoderFile;
import com.twobigears.audio360.SpatDecoderQueue;
import com.twobigears.audio360.TBQuat;
import com.twobigears.audio360.TBVector;
import java.nio.ByteBuffer;

public class AudioEngine {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;
    private EventListener eventListener_;
    public static final int AUDIO360_MAX_BUS_NAME_SIZE = 256;

    protected AudioEngine(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(AudioEngine obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                Audio360JNI.delete_AudioEngine(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public void setEventListener(EventListener listener) {
        if (this.eventListener_ != null) {
            this.eventListener_.delete();
            this.eventListener_ = null;
        }
        this.eventListener_ = listener;
        this.setEventListenerInternal(this.eventListener_);
    }

    public EngineError start() {
        return EngineError.swigToEnum(Audio360JNI.AudioEngine_start(this.swigCPtr, this));
    }

    public EngineError suspend() {
        return EngineError.swigToEnum(Audio360JNI.AudioEngine_suspend(this.swigCPtr, this));
    }

    public EngineError setNumBinaural(int numBinaural) {
        return EngineError.swigToEnum(Audio360JNI.AudioEngine_setNumBinaural(this.swigCPtr, this, numBinaural));
    }

    public int getNumBinaural() {
        return Audio360JNI.AudioEngine_getNumBinaural(this.swigCPtr, this);
    }

    public void setListenerRotation(TBVector forwardVector, TBVector upVector) {
        Audio360JNI.AudioEngine_setListenerRotation__SWIG_0(this.swigCPtr, this, TBVector.getCPtr(forwardVector), forwardVector, TBVector.getCPtr(upVector), upVector);
    }

    public void setListenerRotation(TBQuat quat) {
        Audio360JNI.AudioEngine_setListenerRotation__SWIG_1(this.swigCPtr, this, TBQuat.getCPtr(quat), quat);
    }

    public void setListenerRotation(float yaw, float pitch, float roll) {
        Audio360JNI.AudioEngine_setListenerRotation__SWIG_2(this.swigCPtr, this, yaw, pitch, roll);
    }

    public void setListenerPosition(TBVector position) {
        Audio360JNI.AudioEngine_setListenerPosition(this.swigCPtr, this, TBVector.getCPtr(position), position);
    }

    public TBVector getListenerPosition() {
        return new TBVector(Audio360JNI.AudioEngine_getListenerPosition(this.swigCPtr, this), true);
    }

    public TBQuat getListenerRotation() {
        return new TBQuat(Audio360JNI.AudioEngine_getListenerRotation(this.swigCPtr, this), true);
    }

    public TBVector getListenerForward() {
        return new TBVector(Audio360JNI.AudioEngine_getListenerForward(this.swigCPtr, this), true);
    }

    public TBVector getListenerUp() {
        return new TBVector(Audio360JNI.AudioEngine_getListenerUp(this.swigCPtr, this), true);
    }

    public void setListenerScale(float scale) {
        Audio360JNI.AudioEngine_setListenerScale(this.swigCPtr, this, scale);
    }

    public float getListenerScale() {
        return Audio360JNI.AudioEngine_getListenerScale(this.swigCPtr, this);
    }

    public void update() {
        Audio360JNI.AudioEngine_update(this.swigCPtr, this);
    }

    public EngineError enablePositionalTracking(boolean enable, TBVector initialListenerPosition) {
        return EngineError.swigToEnum(Audio360JNI.AudioEngine_enablePositionalTracking(this.swigCPtr, this, enable, TBVector.getCPtr(initialListenerPosition), initialListenerPosition));
    }

    public boolean positionalTrackingEnabled() {
        return Audio360JNI.AudioEngine_positionalTrackingEnabled(this.swigCPtr, this);
    }

    public int getBufferSize() {
        return Audio360JNI.AudioEngine_getBufferSize(this.swigCPtr, this);
    }

    public float getSampleRate() {
        return Audio360JNI.AudioEngine_getSampleRate(this.swigCPtr, this);
    }

    public EngineError getAudioMix(ByteBuffer buffer, int numOfSamples, int numOfChannels) {
        return EngineError.swigToEnum(Audio360JNI.AudioEngine_getAudioMix(this.swigCPtr, this, buffer, numOfSamples, numOfChannels));
    }

    public EngineError setAudioInputMixCallback(SWIGTYPE_p_f_p_float_size_t_size_t_p_void__void callback, SWIGTYPE_p_void userData) {
        return EngineError.swigToEnum(Audio360JNI.AudioEngine_setAudioInputMixCallback(this.swigCPtr, this, SWIGTYPE_p_f_p_float_size_t_size_t_p_void__void.getCPtr(callback), SWIGTYPE_p_void.getCPtr(userData)));
    }

    public void destroySpatDecoderQueue(SpatDecoderQueue spatDecoder) {
        Audio360JNI.AudioEngine_destroySpatDecoderQueue(this.swigCPtr, this, SpatDecoderQueue.getCPtr(spatDecoder), spatDecoder);
    }

    public EngineError createSpatDecoderFile(SpatDecoderFile spatDecoder, Options options) {
        return EngineError.swigToEnum(Audio360JNI.AudioEngine_createSpatDecoderFile__SWIG_0(this.swigCPtr, this, SpatDecoderFile.getCPtr(spatDecoder), spatDecoder, options.swigValue()));
    }

    public void destroySpatDecoderFile(SpatDecoderFile spatDecoder) {
        Audio360JNI.AudioEngine_destroySpatDecoderFile(this.swigCPtr, this, SpatDecoderFile.getCPtr(spatDecoder), spatDecoder);
    }

    public EngineError createAudioObject(AudioObject audioObject, Options options) {
        return EngineError.swigToEnum(Audio360JNI.AudioEngine_createAudioObject__SWIG_0(this.swigCPtr, this, AudioObject.getCPtr(audioObject), audioObject, options.swigValue()));
    }

    public void destroyAudioObject(AudioObject audioObject) {
        Audio360JNI.AudioEngine_destroyAudioObject(this.swigCPtr, this, AudioObject.getCPtr(audioObject), audioObject);
    }

    public EngineError createBus(SWIGTYPE_p_p_void bus) {
        return EngineError.swigToEnum(Audio360JNI.AudioEngine_createBus(this.swigCPtr, this, SWIGTYPE_p_p_void.getCPtr(bus)));
    }

    public EngineError destroyBus(SWIGTYPE_p_p_void busToDestroy) {
        return EngineError.swigToEnum(Audio360JNI.AudioEngine_destroyBus(this.swigCPtr, this, SWIGTYPE_p_p_void.getCPtr(busToDestroy)));
    }

    public EngineError connectToMasterBus(SWIGTYPE_p_void srcBus) {
        return EngineError.swigToEnum(Audio360JNI.AudioEngine_connectToMasterBus__SWIG_0(this.swigCPtr, this, SWIGTYPE_p_void.getCPtr(srcBus)));
    }

    public EngineError connectToMasterBus(AudioObject audioObject) {
        return EngineError.swigToEnum(Audio360JNI.AudioEngine_connectToMasterBus__SWIG_1(this.swigCPtr, this, AudioObject.getCPtr(audioObject), audioObject));
    }

    public EngineError connect(SWIGTYPE_p_void srcBus, SWIGTYPE_p_void destBus) {
        return EngineError.swigToEnum(Audio360JNI.AudioEngine_connect__SWIG_0(this.swigCPtr, this, SWIGTYPE_p_void.getCPtr(srcBus), SWIGTYPE_p_void.getCPtr(destBus)));
    }

    public EngineError connect(AudioObject audioObject, SWIGTYPE_p_void destBus) {
        return EngineError.swigToEnum(Audio360JNI.AudioEngine_connect__SWIG_1(this.swigCPtr, this, AudioObject.getCPtr(audioObject), audioObject, SWIGTYPE_p_void.getCPtr(destBus)));
    }

    public EngineError disconnectOutput(SWIGTYPE_p_void bus) {
        return EngineError.swigToEnum(Audio360JNI.AudioEngine_disconnectOutput__SWIG_0(this.swigCPtr, this, SWIGTYPE_p_void.getCPtr(bus)));
    }

    public EngineError disconnectOutput(AudioObject audioObject) {
        return EngineError.swigToEnum(Audio360JNI.AudioEngine_disconnectOutput__SWIG_1(this.swigCPtr, this, AudioObject.getCPtr(audioObject), audioObject));
    }

    public EngineError setGain(SWIGTYPE_p_void bus, float gain, float rampTimeMs) {
        return EngineError.swigToEnum(Audio360JNI.AudioEngine_setGain(this.swigCPtr, this, SWIGTYPE_p_void.getCPtr(bus), gain, rampTimeMs));
    }

    public EngineError getGain(SWIGTYPE_p_void bus, float[] gain) {
        return EngineError.swigToEnum(Audio360JNI.AudioEngine_getGain(this.swigCPtr, this, SWIGTYPE_p_void.getCPtr(bus), gain));
    }

    public EngineError setName(SWIGTYPE_p_void bus, String name) {
        return EngineError.swigToEnum(Audio360JNI.AudioEngine_setName(this.swigCPtr, this, SWIGTYPE_p_void.getCPtr(bus), name));
    }

    public void enableTestTone(boolean enable, float frequency, float gain) {
        Audio360JNI.AudioEngine_enableTestTone__SWIG_0(this.swigCPtr, this, enable, frequency, gain);
    }

    public void enableTestTone(boolean enable, float frequency) {
        Audio360JNI.AudioEngine_enableTestTone__SWIG_1(this.swigCPtr, this, enable, frequency);
    }

    public void enableTestTone(boolean enable) {
        Audio360JNI.AudioEngine_enableTestTone__SWIG_2(this.swigCPtr, this, enable);
    }

    public int getVersionMajor() {
        return Audio360JNI.AudioEngine_getVersionMajor(this.swigCPtr, this);
    }

    public int getVersionMinor() {
        return Audio360JNI.AudioEngine_getVersionMinor(this.swigCPtr, this);
    }

    public int getVersionPatch() {
        return Audio360JNI.AudioEngine_getVersionPatch(this.swigCPtr, this);
    }

    public String getVersionHash() {
        return Audio360JNI.AudioEngine_getVersionHash(this.swigCPtr, this);
    }

    public LoudnessStatistics getRenderedLoudness() {
        return new LoudnessStatistics(Audio360JNI.AudioEngine_getRenderedLoudness(this.swigCPtr, this), true);
    }

    public void resetLoudness() {
        Audio360JNI.AudioEngine_resetLoudness(this.swigCPtr, this);
    }

    public void enableLoudness(boolean enabled) {
        Audio360JNI.AudioEngine_enableLoudness__SWIG_0(this.swigCPtr, this, enabled);
    }

    public void enableLoudness() {
        Audio360JNI.AudioEngine_enableLoudness__SWIG_1(this.swigCPtr, this);
    }

    public long getDSPTime() {
        return Audio360JNI.AudioEngine_getDSPTime(this.swigCPtr, this);
    }

    public EngineError setNumOutputBuffers(long numOfBuffers) {
        return EngineError.swigToEnum(Audio360JNI.AudioEngine_setNumOutputBuffers(this.swigCPtr, this, numOfBuffers));
    }

    public long getNumOutputBuffers() {
        return Audio360JNI.AudioEngine_getNumOutputBuffers(this.swigCPtr, this);
    }

    public int getOutputLatencySamples() {
        return Audio360JNI.AudioEngine_getOutputLatencySamples(this.swigCPtr, this);
    }

    public double getOutputLatencyMs() {
        return Audio360JNI.AudioEngine_getOutputLatencyMs(this.swigCPtr, this);
    }

    public String getOutputAudioDeviceName() {
        return Audio360JNI.AudioEngine_getOutputAudioDeviceName(this.swigCPtr, this);
    }

    public EngineError openAudioInput(String name) {
        return EngineError.swigToEnum(Audio360JNI.AudioEngine_openAudioInput(this.swigCPtr, this, name));
    }

    public EngineError mixAudioInput(boolean shouldMix) {
        return EngineError.swigToEnum(Audio360JNI.AudioEngine_mixAudioInput(this.swigCPtr, this, shouldMix));
    }

    public EngineError setInputMixGain(float gain) {
        return EngineError.swigToEnum(Audio360JNI.AudioEngine_setInputMixGain(this.swigCPtr, this, gain));
    }

    public EngineError closeAudioInput() {
        return EngineError.swigToEnum(Audio360JNI.AudioEngine_closeAudioInput(this.swigCPtr, this));
    }

    public AudioAssetManager getAudioAssetManager() {
        long cPtr = Audio360JNI.AudioEngine_getAudioAssetManager(this.swigCPtr, this);
        return cPtr == 0L ? null : new AudioAssetManager(cPtr, false);
    }

    public void setMasterVolume(float linearVolume, float rampTimeMs) {
        Audio360JNI.AudioEngine_setMasterVolume(this.swigCPtr, this, linearVolume, rampTimeMs);
    }

    public float getMasterVolume() {
        return Audio360JNI.AudioEngine_getMasterVolume(this.swigCPtr, this);
    }

    public void enableMasterMute(boolean shouldMute) {
        Audio360JNI.AudioEngine_enableMasterMute(this.swigCPtr, this, shouldMute);
    }

    public boolean isMasterMuteEnabled() {
        return Audio360JNI.AudioEngine_isMasterMuteEnabled(this.swigCPtr, this);
    }

    public EngineStatistics getStats() {
        return new EngineStatistics(Audio360JNI.AudioEngine_getStats(this.swigCPtr, this), true);
    }

    public static int getNumAudioDevices() {
        return Audio360JNI.AudioEngine_getNumAudioDevices();
    }

    public static String getAudioDeviceName(int index) {
        return Audio360JNI.AudioEngine_getAudioDeviceName(index);
    }

    public EngineError setMasterReverbBypass(boolean bypass) {
        return EngineError.swigToEnum(Audio360JNI.AudioEngine_setMasterReverbBypass(this.swigCPtr, this, bypass));
    }

    public boolean getMasterReverbBypass() {
        return Audio360JNI.AudioEngine_getMasterReverbBypass(this.swigCPtr, this);
    }

    public EngineError setMasterReverbWetLevel(float wetLevel) {
        return EngineError.swigToEnum(Audio360JNI.AudioEngine_setMasterReverbWetLevel(this.swigCPtr, this, wetLevel));
    }

    public float getMasterReverbWetLevel() {
        return Audio360JNI.AudioEngine_getMasterReverbWetLevel(this.swigCPtr, this);
    }

    public EngineError setMasterReverbRoomSize(float roomSize) {
        return EngineError.swigToEnum(Audio360JNI.AudioEngine_setMasterReverbRoomSize(this.swigCPtr, this, roomSize));
    }

    public float getMasterReverbRoomSize() {
        return Audio360JNI.AudioEngine_getMasterReverbRoomSize(this.swigCPtr, this);
    }

    public EngineError setMasterReverbDampening(float dampening) {
        return EngineError.swigToEnum(Audio360JNI.AudioEngine_setMasterReverbDampening(this.swigCPtr, this, dampening));
    }

    public float getMasterReverbDampening() {
        return Audio360JNI.AudioEngine_getMasterReverbDampening(this.swigCPtr, this);
    }

    public EngineError setMasterReverbWidth(float width) {
        return EngineError.swigToEnum(Audio360JNI.AudioEngine_setMasterReverbWidth(this.swigCPtr, this, width));
    }

    public float getMasterReverbWidth() {
        return Audio360JNI.AudioEngine_getMasterReverbWidth(this.swigCPtr, this);
    }

    public boolean saveGraph(String path) {
        return Audio360JNI.AudioEngine_saveGraph(this.swigCPtr, this, path);
    }

    public static AudioEngine create(EngineInitSettings initSettings, Context context) {
        long cPtr = Audio360JNI.AudioEngine_create__SWIG_0(EngineInitSettings.getCPtr(initSettings), initSettings, context != null ? context.getAssets() : null);
        return cPtr == 0L ? null : new AudioEngine(cPtr, true);
    }

    public static AudioEngine create(float sampleRate, Context context) {
        long cPtr = Audio360JNI.AudioEngine_create__SWIG_1(sampleRate, context != null ? context.getAssets() : null);
        return cPtr == 0L ? null : new AudioEngine(cPtr, true);
    }

    public static AudioEngine create(float sampleRate, int bufferSize, Context context) {
        long cPtr = Audio360JNI.AudioEngine_create__SWIG_2(sampleRate, bufferSize, context != null ? context.getAssets() : null);
        return cPtr == 0L ? null : new AudioEngine(cPtr, false);
    }

    public static AudioEngine create(float sampleRate, int bufferSize, int queueSizeInSamples, Context context) {
        long cPtr = Audio360JNI.AudioEngine_create__SWIG_3(sampleRate, bufferSize, queueSizeInSamples, context != null ? context.getAssets() : null);
        return cPtr == 0L ? null : new AudioEngine(cPtr, false);
    }

    public SpatDecoderQueue createSpatDecoderQueue() {
        long cPtr = Audio360JNI.AudioEngine_createSpatDecoderQueue__SWIG_0(this.swigCPtr, this);
        return cPtr == 0L ? null : new SpatDecoderQueue(cPtr, false);
    }

    public SpatDecoderQueue createSpatDecoderQueue(ChannelMap map, PCMType type) {
        long cPtr = Audio360JNI.AudioEngine_createSpatDecoderQueue__SWIG_1(this.swigCPtr, this, map.swigValue(), type.swigValue());
        return cPtr == 0L ? null : new SpatDecoderQueue(cPtr, false);
    }

    public SpatDecoderFile createSpatDecoderFile() {
        long cPtr = Audio360JNI.AudioEngine_createSpatDecoderFile__SWIG_1(this.swigCPtr, this);
        return cPtr == 0L ? null : new SpatDecoderFile(cPtr, false);
    }

    public AudioObject createAudioObject() {
        long cPtr = Audio360JNI.AudioEngine_createAudioObject__SWIG_1(this.swigCPtr, this);
        return cPtr == 0L ? null : new AudioObject(cPtr, false);
    }

    public String getName(SWIGTYPE_p_void bus) {
        return Audio360JNI.AudioEngine_getName(this.swigCPtr, this, SWIGTYPE_p_void.getCPtr(bus));
    }

    public String getMasterBusName() {
        return Audio360JNI.AudioEngine_getMasterBusName(this.swigCPtr, this);
    }

    private void setEventListenerInternal(EventListener listener) {
        Audio360JNI.AudioEngine_setEventListenerInternal(this.swigCPtr, this, EventListener.getCPtr(listener), listener);
    }
}

