/*
 * Decompiled with CFR 0.152.
 */
package com.twobigears.audio360;

import com.twobigears.audio360.Audio360JNI;
import com.twobigears.audio360.ChannelMap;
import com.twobigears.audio360.EngineError;
import com.twobigears.audio360.IOStream;
import java.nio.ByteBuffer;

public class AudioFormatDecoder {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected AudioFormatDecoder(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(AudioFormatDecoder obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                Audio360JNI.delete_AudioFormatDecoder(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public int getNumOfChannels() {
        return Audio360JNI.AudioFormatDecoder_getNumOfChannels(this.swigCPtr, this);
    }

    public long getNumTotalSamples() {
        return Audio360JNI.AudioFormatDecoder_getNumTotalSamples(this.swigCPtr, this);
    }

    public long getNumSamplesPerChannel() {
        return Audio360JNI.AudioFormatDecoder_getNumSamplesPerChannel(this.swigCPtr, this);
    }

    public double getMsPerChannel() {
        return Audio360JNI.AudioFormatDecoder_getMsPerChannel(this.swigCPtr, this);
    }

    public long getSamplePosition() {
        return Audio360JNI.AudioFormatDecoder_getSamplePosition(this.swigCPtr, this);
    }

    public EngineError seekToSample(long samplePosition) {
        return EngineError.swigToEnum(Audio360JNI.AudioFormatDecoder_seekToSample(this.swigCPtr, this, samplePosition));
    }

    public long decode(ByteBuffer bufferOut, int numOfSamplesInBuffer) {
        return Audio360JNI.AudioFormatDecoder_decode(this.swigCPtr, this, bufferOut, numOfSamplesInBuffer);
    }

    public float getSampleRate() {
        return Audio360JNI.AudioFormatDecoder_getSampleRate(this.swigCPtr, this);
    }

    public float getOutputSampleRate() {
        return Audio360JNI.AudioFormatDecoder_getOutputSampleRate(this.swigCPtr, this);
    }

    public int getNumBits() {
        return Audio360JNI.AudioFormatDecoder_getNumBits(this.swigCPtr, this);
    }

    public boolean endOfStream() {
        return Audio360JNI.AudioFormatDecoder_endOfStream(this.swigCPtr, this);
    }

    public boolean decoderError() {
        return Audio360JNI.AudioFormatDecoder_decoderError(this.swigCPtr, this);
    }

    public int getMaxBufferSizePerChannel() {
        return Audio360JNI.AudioFormatDecoder_getMaxBufferSizePerChannel(this.swigCPtr, this);
    }

    public String getName() {
        return Audio360JNI.AudioFormatDecoder_getName(this.swigCPtr, this);
    }

    public void flush(boolean resetToZero) {
        Audio360JNI.AudioFormatDecoder_flush__SWIG_0(this.swigCPtr, this, resetToZero);
    }

    public void flush() {
        Audio360JNI.AudioFormatDecoder_flush__SWIG_1(this.swigCPtr, this);
    }

    public int getInfo(Info info) {
        return Audio360JNI.AudioFormatDecoder_getInfo(this.swigCPtr, this, info.swigValue());
    }

    public ChannelMap getChannelMap() {
        return ChannelMap.swigToEnum(Audio360JNI.AudioFormatDecoder_getChannelMap(this.swigCPtr, this));
    }

    public static AudioFormatDecoder create(String file, int maxBufferSizePerChannel, float outputSampleRate) {
        long cPtr = Audio360JNI.AudioFormatDecoder_create__SWIG_0(file, maxBufferSizePerChannel, outputSampleRate);
        return cPtr == 0L ? null : new AudioFormatDecoder(cPtr, true);
    }

    public static AudioFormatDecoder create(String file, int maxBufferSizePerChannel) {
        long cPtr = Audio360JNI.AudioFormatDecoder_create__SWIG_1(file, maxBufferSizePerChannel);
        return cPtr == 0L ? null : new AudioFormatDecoder(cPtr, true);
    }

    public static AudioFormatDecoder create(IOStream stream, boolean decoderOwnsStream, int maxBufferSizePerChannel, float outputSampleRate) {
        long cPtr = Audio360JNI.AudioFormatDecoder_create__SWIG_2(IOStream.getCPtr(stream), stream, decoderOwnsStream, maxBufferSizePerChannel, outputSampleRate);
        return cPtr == 0L ? null : new AudioFormatDecoder(cPtr, false);
    }

    public static AudioFormatDecoder create(IOStream stream, boolean decoderOwnsStream, int maxBufferSizePerChannel) {
        long cPtr = Audio360JNI.AudioFormatDecoder_create__SWIG_3(IOStream.getCPtr(stream), stream, decoderOwnsStream, maxBufferSizePerChannel);
        return cPtr == 0L ? null : new AudioFormatDecoder(cPtr, false);
    }

    public static enum Info {
        PRE_SKIP;

        private final int swigValue;

        public final int swigValue() {
            return this.swigValue;
        }

        public static Info swigToEnum(int swigValue) {
            Info[] swigValues = (Info[])Info.class.getEnumConstants();
            if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue) {
                return swigValues[swigValue];
            }
            for (Info swigEnum : swigValues) {
                if (swigEnum.swigValue != swigValue) continue;
                return swigEnum;
            }
            throw new IllegalArgumentException("No enum " + Info.class + " with value " + swigValue);
        }

        private Info() {
            this.swigValue = SwigNext.next++;
        }

        private Info(int swigValue) {
            this.swigValue = swigValue;
            SwigNext.next = swigValue + 1;
        }

        private Info(Info swigEnum) {
            this.swigValue = swigEnum.swigValue;
            SwigNext.next = this.swigValue + 1;
        }

        private static class SwigNext {
            private static int next = 0;

            private SwigNext() {
            }
        }
    }
}

