/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer.source;

import android.os.Handler;
import android.os.Looper;
import androidx.annotation.Nullable;
import androidx.media3.common.Timeline;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.datasource.TransferListener;
import androidx.media3.exoplayer.analytics.PlayerId;
import androidx.media3.exoplayer.drm.DrmSessionEventListener;
import androidx.media3.exoplayer.source.MediaSource;
import androidx.media3.exoplayer.source.MediaSourceEventListener;
import java.util.ArrayList;
import java.util.HashSet;

@UnstableApi
public abstract class BaseMediaSource
implements MediaSource {
    private final ArrayList<MediaSource.MediaSourceCaller> mediaSourceCallers = new ArrayList(1);
    private final HashSet<MediaSource.MediaSourceCaller> enabledMediaSourceCallers = new HashSet(1);
    private final MediaSourceEventListener.EventDispatcher eventDispatcher = new MediaSourceEventListener.EventDispatcher();
    private final DrmSessionEventListener.EventDispatcher drmEventDispatcher = new DrmSessionEventListener.EventDispatcher();
    @Nullable
    private Looper looper;
    @Nullable
    private Timeline timeline;
    @Nullable
    private PlayerId playerId;

    protected abstract void prepareSourceInternal(@Nullable TransferListener var1);

    protected void enableInternal() {
    }

    protected void disableInternal() {
    }

    protected abstract void releaseSourceInternal();

    protected final void refreshSourceInfo(Timeline timeline) {
        this.timeline = timeline;
        for (MediaSource.MediaSourceCaller caller : this.mediaSourceCallers) {
            caller.onSourceInfoRefreshed(this, timeline);
        }
    }

    protected final MediaSourceEventListener.EventDispatcher createEventDispatcher(@Nullable MediaSource.MediaPeriodId mediaPeriodId) {
        return this.eventDispatcher.withParameters(0, mediaPeriodId);
    }

    protected final MediaSourceEventListener.EventDispatcher createEventDispatcher(int windowIndex, @Nullable MediaSource.MediaPeriodId mediaPeriodId) {
        return this.eventDispatcher.withParameters(windowIndex, mediaPeriodId);
    }

    @Deprecated
    protected final MediaSourceEventListener.EventDispatcher createEventDispatcher(MediaSource.MediaPeriodId mediaPeriodId, long mediaTimeOffsetMs) {
        Assertions.checkNotNull((Object)((Object)mediaPeriodId));
        return this.eventDispatcher.withParameters(0, mediaPeriodId);
    }

    @Deprecated
    protected final MediaSourceEventListener.EventDispatcher createEventDispatcher(int windowIndex, @Nullable MediaSource.MediaPeriodId mediaPeriodId, long mediaTimeOffsetMs) {
        return this.eventDispatcher.withParameters(windowIndex, mediaPeriodId);
    }

    protected final DrmSessionEventListener.EventDispatcher createDrmEventDispatcher(@Nullable MediaSource.MediaPeriodId mediaPeriodId) {
        return this.drmEventDispatcher.withParameters(0, mediaPeriodId);
    }

    protected final DrmSessionEventListener.EventDispatcher createDrmEventDispatcher(int windowIndex, @Nullable MediaSource.MediaPeriodId mediaPeriodId) {
        return this.drmEventDispatcher.withParameters(windowIndex, mediaPeriodId);
    }

    protected final boolean isEnabled() {
        return !this.enabledMediaSourceCallers.isEmpty();
    }

    protected final PlayerId getPlayerId() {
        return (PlayerId)Assertions.checkStateNotNull((Object)this.playerId);
    }

    @Override
    public final void addEventListener(Handler handler, MediaSourceEventListener eventListener) {
        Assertions.checkNotNull((Object)handler);
        Assertions.checkNotNull((Object)eventListener);
        this.eventDispatcher.addEventListener(handler, eventListener);
    }

    @Override
    public final void removeEventListener(MediaSourceEventListener eventListener) {
        this.eventDispatcher.removeEventListener(eventListener);
    }

    @Override
    public final void addDrmEventListener(Handler handler, DrmSessionEventListener eventListener) {
        Assertions.checkNotNull((Object)handler);
        Assertions.checkNotNull((Object)eventListener);
        this.drmEventDispatcher.addEventListener(handler, eventListener);
    }

    @Override
    public final void removeDrmEventListener(DrmSessionEventListener eventListener) {
        this.drmEventDispatcher.removeEventListener(eventListener);
    }

    @Override
    public final void prepareSource(MediaSource.MediaSourceCaller caller, @Nullable TransferListener mediaTransferListener) {
        this.prepareSource(caller, mediaTransferListener, PlayerId.UNSET);
    }

    @Override
    public final void prepareSource(MediaSource.MediaSourceCaller caller, @Nullable TransferListener mediaTransferListener, PlayerId playerId) {
        Looper looper = Looper.myLooper();
        Assertions.checkArgument((this.looper == null || this.looper == looper ? 1 : 0) != 0);
        this.playerId = playerId;
        Timeline timeline = this.timeline;
        this.mediaSourceCallers.add(caller);
        if (this.looper == null) {
            this.looper = looper;
            this.enabledMediaSourceCallers.add(caller);
            this.prepareSourceInternal(mediaTransferListener);
        } else if (timeline != null) {
            this.enable(caller);
            caller.onSourceInfoRefreshed(this, timeline);
        }
    }

    @Override
    public final void enable(MediaSource.MediaSourceCaller caller) {
        Assertions.checkNotNull((Object)this.looper);
        boolean wasDisabled = this.enabledMediaSourceCallers.isEmpty();
        this.enabledMediaSourceCallers.add(caller);
        if (wasDisabled) {
            this.enableInternal();
        }
    }

    @Override
    public final void disable(MediaSource.MediaSourceCaller caller) {
        boolean wasEnabled = !this.enabledMediaSourceCallers.isEmpty();
        this.enabledMediaSourceCallers.remove(caller);
        if (wasEnabled && this.enabledMediaSourceCallers.isEmpty()) {
            this.disableInternal();
        }
    }

    @Override
    public final void releaseSource(MediaSource.MediaSourceCaller caller) {
        this.mediaSourceCallers.remove(caller);
        if (this.mediaSourceCallers.isEmpty()) {
            this.looper = null;
            this.timeline = null;
            this.playerId = null;
            this.enabledMediaSourceCallers.clear();
            this.releaseSourceInternal();
        } else {
            this.disable(caller);
        }
    }
}

