/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.extractor.flv;

import androidx.annotation.Nullable;
import androidx.media3.common.util.ParsableByteArray;
import androidx.media3.extractor.DummyTrackOutput;
import androidx.media3.extractor.flv.TagPayloadReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class ScriptTagPayloadReader
extends TagPayloadReader {
    private static final String NAME_METADATA = "onMetaData";
    private static final String KEY_DURATION = "duration";
    private static final String KEY_KEY_FRAMES = "keyframes";
    private static final String KEY_FILE_POSITIONS = "filepositions";
    private static final String KEY_TIMES = "times";
    private static final int AMF_TYPE_NUMBER = 0;
    private static final int AMF_TYPE_BOOLEAN = 1;
    private static final int AMF_TYPE_STRING = 2;
    private static final int AMF_TYPE_OBJECT = 3;
    private static final int AMF_TYPE_ECMA_ARRAY = 8;
    private static final int AMF_TYPE_END_MARKER = 9;
    private static final int AMF_TYPE_STRICT_ARRAY = 10;
    private static final int AMF_TYPE_DATE = 11;
    private long durationUs = -9223372036854775807L;
    private long[] keyFrameTimesUs = new long[0];
    private long[] keyFrameTagPositions = new long[0];

    public ScriptTagPayloadReader() {
        super(new DummyTrackOutput());
    }

    public long getDurationUs() {
        return this.durationUs;
    }

    public long[] getKeyFrameTimesUs() {
        return this.keyFrameTimesUs;
    }

    public long[] getKeyFrameTagPositions() {
        return this.keyFrameTagPositions;
    }

    @Override
    public void seek() {
    }

    @Override
    protected boolean parseHeader(ParsableByteArray data) {
        return true;
    }

    @Override
    protected boolean parsePayload(ParsableByteArray data, long timeUs) {
        Object keyFramesObj;
        double durationSeconds;
        int nameType = ScriptTagPayloadReader.readAmfType(data);
        if (nameType != 2) {
            return false;
        }
        String name = ScriptTagPayloadReader.readAmfString(data);
        if (!NAME_METADATA.equals(name)) {
            return false;
        }
        if (data.bytesLeft() == 0) {
            return false;
        }
        int type = ScriptTagPayloadReader.readAmfType(data);
        if (type != 8) {
            return false;
        }
        HashMap<String, Object> metadata = ScriptTagPayloadReader.readAmfEcmaArray(data);
        Object durationSecondsObj = metadata.get(KEY_DURATION);
        if (durationSecondsObj instanceof Double && (durationSeconds = ((Double)durationSecondsObj).doubleValue()) > 0.0) {
            this.durationUs = (long)(durationSeconds * 1000000.0);
        }
        if ((keyFramesObj = metadata.get(KEY_KEY_FRAMES)) instanceof Map) {
            Map keyFrames = (Map)keyFramesObj;
            Object positionsObj = keyFrames.get(KEY_FILE_POSITIONS);
            Object timesSecondsObj = keyFrames.get(KEY_TIMES);
            if (positionsObj instanceof List && timesSecondsObj instanceof List) {
                List positions = (List)positionsObj;
                List timesSeconds = (List)timesSecondsObj;
                int keyFrameCount = timesSeconds.size();
                this.keyFrameTimesUs = new long[keyFrameCount];
                this.keyFrameTagPositions = new long[keyFrameCount];
                for (int i = 0; i < keyFrameCount; ++i) {
                    Object positionObj = positions.get(i);
                    Object timeSecondsObj = timesSeconds.get(i);
                    if (!(timeSecondsObj instanceof Double) || !(positionObj instanceof Double)) {
                        this.keyFrameTimesUs = new long[0];
                        this.keyFrameTagPositions = new long[0];
                        break;
                    }
                    this.keyFrameTimesUs[i] = (long)((Double)timeSecondsObj * 1000000.0);
                    this.keyFrameTagPositions[i] = ((Double)positionObj).longValue();
                }
            }
        }
        return false;
    }

    private static int readAmfType(ParsableByteArray data) {
        return data.readUnsignedByte();
    }

    private static Boolean readAmfBoolean(ParsableByteArray data) {
        return data.readUnsignedByte() == 1;
    }

    private static Double readAmfDouble(ParsableByteArray data) {
        return Double.longBitsToDouble(data.readLong());
    }

    private static String readAmfString(ParsableByteArray data) {
        int size = data.readUnsignedShort();
        int position = data.getPosition();
        data.skipBytes(size);
        return new String(data.getData(), position, size);
    }

    private static ArrayList<Object> readAmfStrictArray(ParsableByteArray data) {
        int count = data.readUnsignedIntToInt();
        ArrayList<Object> list = new ArrayList<Object>(count);
        for (int i = 0; i < count; ++i) {
            int type = ScriptTagPayloadReader.readAmfType(data);
            Object value = ScriptTagPayloadReader.readAmfData(data, type);
            if (value == null) continue;
            list.add(value);
        }
        return list;
    }

    private static HashMap<String, Object> readAmfObject(ParsableByteArray data) {
        HashMap<String, Object> array = new HashMap<String, Object>();
        while (true) {
            String key = ScriptTagPayloadReader.readAmfString(data);
            int type = ScriptTagPayloadReader.readAmfType(data);
            if (type == 9) break;
            Object value = ScriptTagPayloadReader.readAmfData(data, type);
            if (value == null) continue;
            array.put(key, value);
        }
        return array;
    }

    private static HashMap<String, Object> readAmfEcmaArray(ParsableByteArray data) {
        int count = data.readUnsignedIntToInt();
        HashMap<String, Object> array = new HashMap<String, Object>(count);
        for (int i = 0; i < count; ++i) {
            String key = ScriptTagPayloadReader.readAmfString(data);
            int type = ScriptTagPayloadReader.readAmfType(data);
            Object value = ScriptTagPayloadReader.readAmfData(data, type);
            if (value == null) continue;
            array.put(key, value);
        }
        return array;
    }

    private static Date readAmfDate(ParsableByteArray data) {
        Date date = new Date((long)ScriptTagPayloadReader.readAmfDouble(data).doubleValue());
        data.skipBytes(2);
        return date;
    }

    @Nullable
    private static Object readAmfData(ParsableByteArray data, int type) {
        switch (type) {
            case 0: {
                return ScriptTagPayloadReader.readAmfDouble(data);
            }
            case 1: {
                return ScriptTagPayloadReader.readAmfBoolean(data);
            }
            case 2: {
                return ScriptTagPayloadReader.readAmfString(data);
            }
            case 3: {
                return ScriptTagPayloadReader.readAmfObject(data);
            }
            case 8: {
                return ScriptTagPayloadReader.readAmfEcmaArray(data);
            }
            case 10: {
                return ScriptTagPayloadReader.readAmfStrictArray(data);
            }
            case 11: {
                return ScriptTagPayloadReader.readAmfDate(data);
            }
        }
        return null;
    }
}

