/*
 * Decompiled with CFR 0.152.
 */
package com.twobigears.audio360exo2;

import android.util.Log;
import androidx.annotation.Nullable;
import androidx.media3.common.Format;
import androidx.media3.common.PlaybackParameters;
import androidx.media3.decoder.CryptoConfig;
import androidx.media3.exoplayer.ExoPlaybackException;
import androidx.media3.exoplayer.audio.AudioSink;
import androidx.media3.exoplayer.audio.DecoderAudioRenderer;
import com.twobigears.audio360exo2.OpusDecoder;
import com.twobigears.audio360exo2.OpusDecoderException;
import com.twobigears.audio360exo2.OpusJNI;

public final class OpusRenderer
extends DecoderAudioRenderer<OpusDecoder> {
    private static final String TAG = "OpusRenderer";
    private static final int NUM_BUFFERS = 16;
    private static final int INITIAL_INPUT_BUFFER_SIZE = 5760;
    private int channelCount = 0;
    private int sampleRate = 0;

    public OpusRenderer(AudioSink sink) {
        super(null, null, sink);
        Log.e((String)"STEEEEE", (String)"OpusRenderer::OpusRenderer CALLED");
    }

    public String getName() {
        return TAG;
    }

    public void setPlaybackSpeed(float currentPlaybackSpeed, float targetPlaybackSpeed) throws ExoPlaybackException {
    }

    protected int supportsFormatInternal(Format format) {
        boolean libAvailable = OpusJNI.IS_AVAILABLE;
        boolean mimeOk = "audio/opus".equalsIgnoreCase(format.sampleMimeType);
        if (libAvailable && mimeOk) {
            return 4;
        }
        if (format.drmInitData != null) {
            return 2;
        }
        return 0;
    }

    protected OpusDecoder createDecoder(Format format, @Nullable CryptoConfig cryptoConfig) throws OpusDecoderException {
        Log.e((String)"STEEEEE", (String)"OpusRenderer::createDecoder CALLED");
        OpusDecoder decoder = new OpusDecoder(16, 16, 5760, format.initializationData);
        this.channelCount = decoder.getChannelCount();
        this.sampleRate = decoder.getSampleRate();
        return decoder;
    }

    protected Format getOutputFormat(OpusDecoder decoder) {
        return new Format.Builder().setSampleMimeType("audio/raw").setChannelCount(this.channelCount).setSampleRate(this.sampleRate).setPcmEncoding(2).build();
    }

    public void setPlaybackParameters(PlaybackParameters playbackParameters) {
    }

    public PlaybackParameters getPlaybackParameters() {
        return PlaybackParameters.DEFAULT;
    }
}

