/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.extractor.text;

import androidx.annotation.Nullable;
import androidx.media3.common.text.Cue;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.decoder.DecoderOutputBuffer;
import androidx.media3.extractor.text.Subtitle;
import java.util.List;

@UnstableApi
public abstract class SubtitleOutputBuffer
extends DecoderOutputBuffer
implements Subtitle {
    @Nullable
    private Subtitle subtitle;
    private long subsampleOffsetUs;

    public void setContent(long timeUs, Subtitle subtitle, long subsampleOffsetUs) {
        this.timeUs = timeUs;
        this.subtitle = subtitle;
        this.subsampleOffsetUs = subsampleOffsetUs == Long.MAX_VALUE ? this.timeUs : subsampleOffsetUs;
    }

    @Override
    public int getEventTimeCount() {
        return ((Subtitle)Assertions.checkNotNull((Object)this.subtitle)).getEventTimeCount();
    }

    @Override
    public long getEventTime(int index) {
        return ((Subtitle)Assertions.checkNotNull((Object)this.subtitle)).getEventTime(index) + this.subsampleOffsetUs;
    }

    @Override
    public int getNextEventTimeIndex(long timeUs) {
        return ((Subtitle)Assertions.checkNotNull((Object)this.subtitle)).getNextEventTimeIndex(timeUs - this.subsampleOffsetUs);
    }

    @Override
    public List<Cue> getCues(long timeUs) {
        return ((Subtitle)Assertions.checkNotNull((Object)this.subtitle)).getCues(timeUs - this.subsampleOffsetUs);
    }

    public void clear() {
        super.clear();
        this.subtitle = null;
    }
}

