/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.common.util;

import android.text.TextUtils;
import androidx.annotation.GuardedBy;
import androidx.annotation.Nullable;
import androidx.annotation.Size;
import androidx.media3.common.util.UnstableApi;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.net.UnknownHostException;
import org.checkerframework.dataflow.qual.Pure;

@UnstableApi
public final class Log {
    public static final int LOG_LEVEL_ALL = 0;
    public static final int LOG_LEVEL_INFO = 1;
    public static final int LOG_LEVEL_WARNING = 2;
    public static final int LOG_LEVEL_ERROR = 3;
    public static final int LOG_LEVEL_OFF = Integer.MAX_VALUE;
    private static final Object lock = new Object();
    @GuardedBy(value="lock")
    private static int logLevel = 0;
    @GuardedBy(value="lock")
    private static boolean logStackTraces = true;
    @GuardedBy(value="lock")
    private static Logger logger = Logger.DEFAULT;

    private Log() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Pure
    public static int getLogLevel() {
        Object object = lock;
        synchronized (object) {
            return logLevel;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setLogLevel(int logLevel) {
        Object object = lock;
        synchronized (object) {
            Log.logLevel = logLevel;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setLogStackTraces(boolean logStackTraces) {
        Object object = lock;
        synchronized (object) {
            Log.logStackTraces = logStackTraces;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setLogger(Logger logger) {
        Object object = lock;
        synchronized (object) {
            Log.logger = logger;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Pure
    public static void d(@Size(max=23L) String tag, String message) {
        Object object = lock;
        synchronized (object) {
            if (logLevel == 0) {
                logger.d(tag, message);
            }
        }
    }

    @Pure
    public static void d(@Size(max=23L) String tag, String message, @Nullable Throwable throwable) {
        Log.d(tag, Log.appendThrowableString(message, throwable));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Pure
    public static void i(@Size(max=23L) String tag, String message) {
        Object object = lock;
        synchronized (object) {
            if (logLevel <= 1) {
                logger.i(tag, message);
            }
        }
    }

    @Pure
    public static void i(@Size(max=23L) String tag, String message, @Nullable Throwable throwable) {
        Log.i(tag, Log.appendThrowableString(message, throwable));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Pure
    public static void w(@Size(max=23L) String tag, String message) {
        Object object = lock;
        synchronized (object) {
            if (logLevel <= 2) {
                logger.w(tag, message);
            }
        }
    }

    @Pure
    public static void w(@Size(max=23L) String tag, String message, @Nullable Throwable throwable) {
        Log.w(tag, Log.appendThrowableString(message, throwable));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Pure
    public static void e(@Size(max=23L) String tag, String message) {
        Object object = lock;
        synchronized (object) {
            if (logLevel <= 3) {
                logger.e(tag, message);
            }
        }
    }

    @Pure
    public static void e(@Size(max=23L) String tag, String message, @Nullable Throwable throwable) {
        Log.e(tag, Log.appendThrowableString(message, throwable));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Pure
    @Nullable
    public static String getThrowableString(@Nullable Throwable throwable) {
        Object object = lock;
        synchronized (object) {
            if (throwable == null) {
                return null;
            }
            if (Log.isCausedByUnknownHostException(throwable)) {
                return "UnknownHostException (no network)";
            }
            if (!logStackTraces) {
                return throwable.getMessage();
            }
            return android.util.Log.getStackTraceString((Throwable)throwable).trim().replace("\t", "    ");
        }
    }

    @Pure
    private static String appendThrowableString(String message, @Nullable Throwable throwable) {
        String throwableString = Log.getThrowableString(throwable);
        if (!TextUtils.isEmpty((CharSequence)throwableString)) {
            message = message + "\n  " + throwableString.replace("\n", "\n  ") + '\n';
        }
        return message;
    }

    @Pure
    private static boolean isCausedByUnknownHostException(@Nullable Throwable throwable) {
        while (throwable != null) {
            if (throwable instanceof UnknownHostException) {
                return true;
            }
            throwable = throwable.getCause();
        }
        return false;
    }

    public static interface Logger {
        public static final Logger DEFAULT = new Logger(){

            @Override
            public void d(String tag, String message) {
                android.util.Log.d((String)tag, (String)message);
            }

            @Override
            public void i(String tag, String message) {
                android.util.Log.i((String)tag, (String)message);
            }

            @Override
            public void w(String tag, String message) {
                android.util.Log.w((String)tag, (String)message);
            }

            @Override
            public void e(String tag, String message) {
                android.util.Log.e((String)tag, (String)message);
            }
        };

        public void d(String var1, String var2);

        public void i(String var1, String var2);

        public void w(String var1, String var2);

        public void e(String var1, String var2);
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.TYPE_USE})
    public static @interface LogLevel {
    }
}

