/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer.upstream.experimental;

import android.os.Handler;
import androidx.annotation.VisibleForTesting;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.Clock;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.datasource.DataSource;
import androidx.media3.exoplayer.upstream.BandwidthMeter;
import androidx.media3.exoplayer.upstream.experimental.BandwidthEstimator;
import androidx.media3.exoplayer.upstream.experimental.BandwidthStatistic;
import androidx.media3.exoplayer.upstream.experimental.SlidingWeightedAverageBandwidthStatistic;
import com.google.errorprone.annotations.CanIgnoreReturnValue;

@UnstableApi
public class SplitParallelSampleBandwidthEstimator
implements BandwidthEstimator {
    private final BandwidthStatistic bandwidthStatistic;
    private final int minSamples;
    private final long minBytesTransferred;
    private final Clock clock;
    private final BandwidthMeter.EventListener.EventDispatcher eventDispatcher;
    private int streamCount;
    private long sampleStartTimeMs;
    private long sampleBytesTransferred;
    private long bandwidthEstimate;
    private long lastReportedBandwidthEstimate;
    private int totalSamplesAdded;
    private long totalBytesTransferred;

    private SplitParallelSampleBandwidthEstimator(Builder builder) {
        this.bandwidthStatistic = builder.bandwidthStatistic;
        this.minSamples = builder.minSamples;
        this.minBytesTransferred = builder.minBytesTransferred;
        this.clock = builder.clock;
        this.eventDispatcher = new BandwidthMeter.EventListener.EventDispatcher();
        this.bandwidthEstimate = Long.MIN_VALUE;
        this.lastReportedBandwidthEstimate = Long.MIN_VALUE;
    }

    @Override
    public void addEventListener(Handler eventHandler, BandwidthMeter.EventListener eventListener) {
        this.eventDispatcher.addListener(eventHandler, eventListener);
    }

    @Override
    public void removeEventListener(BandwidthMeter.EventListener eventListener) {
        this.eventDispatcher.removeListener(eventListener);
    }

    @Override
    public void onTransferInitializing(DataSource source) {
    }

    @Override
    public void onTransferStart(DataSource source) {
        if (this.streamCount == 0) {
            this.sampleStartTimeMs = this.clock.elapsedRealtime();
        }
        ++this.streamCount;
    }

    @Override
    public void onBytesTransferred(DataSource source, int bytesTransferred) {
        this.sampleBytesTransferred += (long)bytesTransferred;
        this.totalBytesTransferred += (long)bytesTransferred;
    }

    @Override
    public void onTransferEnd(DataSource source) {
        Assertions.checkState((this.streamCount > 0 ? 1 : 0) != 0);
        long nowMs = this.clock.elapsedRealtime();
        long sampleElapsedTimeMs = (int)(nowMs - this.sampleStartTimeMs);
        if (sampleElapsedTimeMs > 0L) {
            this.bandwidthStatistic.addSample(this.sampleBytesTransferred, sampleElapsedTimeMs * 1000L);
            ++this.totalSamplesAdded;
            if (this.totalSamplesAdded > this.minSamples && this.totalBytesTransferred > this.minBytesTransferred) {
                this.bandwidthEstimate = this.bandwidthStatistic.getBandwidthEstimate();
            }
            this.maybeNotifyBandwidthSample((int)sampleElapsedTimeMs, this.sampleBytesTransferred, this.bandwidthEstimate);
            this.sampleStartTimeMs = nowMs;
            this.sampleBytesTransferred = 0L;
        }
        --this.streamCount;
    }

    @Override
    public long getBandwidthEstimate() {
        return this.bandwidthEstimate;
    }

    @Override
    public void onNetworkTypeChange(long newBandwidthEstimate) {
        long nowMs = this.clock.elapsedRealtime();
        int sampleElapsedTimeMs = this.streamCount > 0 ? (int)(nowMs - this.sampleStartTimeMs) : 0;
        this.maybeNotifyBandwidthSample(sampleElapsedTimeMs, this.sampleBytesTransferred, newBandwidthEstimate);
        this.bandwidthStatistic.reset();
        this.bandwidthEstimate = Long.MIN_VALUE;
        this.sampleStartTimeMs = nowMs;
        this.sampleBytesTransferred = 0L;
        this.totalSamplesAdded = 0;
        this.totalBytesTransferred = 0L;
    }

    private void maybeNotifyBandwidthSample(int elapsedMs, long bytesTransferred, long bandwidthEstimate) {
        if (bandwidthEstimate == Long.MIN_VALUE || elapsedMs == 0 && bytesTransferred == 0L && bandwidthEstimate == this.lastReportedBandwidthEstimate) {
            return;
        }
        this.lastReportedBandwidthEstimate = bandwidthEstimate;
        this.eventDispatcher.bandwidthSample(elapsedMs, bytesTransferred, bandwidthEstimate);
    }

    public static class Builder {
        private BandwidthStatistic bandwidthStatistic = new SlidingWeightedAverageBandwidthStatistic();
        private int minSamples;
        private long minBytesTransferred;
        private Clock clock = Clock.DEFAULT;

        @CanIgnoreReturnValue
        public Builder setBandwidthStatistic(BandwidthStatistic bandwidthStatistic) {
            Assertions.checkNotNull((Object)bandwidthStatistic);
            this.bandwidthStatistic = bandwidthStatistic;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setMinSamples(int minSamples) {
            Assertions.checkArgument((minSamples >= 0 ? 1 : 0) != 0);
            this.minSamples = minSamples;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setMinBytesTransferred(long minBytesTransferred) {
            Assertions.checkArgument((minBytesTransferred >= 0L ? 1 : 0) != 0);
            this.minBytesTransferred = minBytesTransferred;
            return this;
        }

        @CanIgnoreReturnValue
        @VisibleForTesting
        Builder setClock(Clock clock) {
            this.clock = clock;
            return this;
        }

        public SplitParallelSampleBandwidthEstimator build() {
            return new SplitParallelSampleBandwidthEstimator(this);
        }
    }
}

