/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer.drm;

import android.os.Looper;
import androidx.annotation.Nullable;
import androidx.media3.common.Format;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.exoplayer.analytics.PlayerId;
import androidx.media3.exoplayer.drm.DrmSession;
import androidx.media3.exoplayer.drm.DrmSessionEventListener;
import androidx.media3.exoplayer.drm.ErrorStateDrmSession;
import androidx.media3.exoplayer.drm.UnsupportedDrmException;

@UnstableApi
public interface DrmSessionManager {
    public static final DrmSessionManager DRM_UNSUPPORTED;
    @Deprecated
    public static final DrmSessionManager DUMMY;

    @Deprecated
    public static DrmSessionManager getDummyDrmSessionManager() {
        return DRM_UNSUPPORTED;
    }

    default public void prepare() {
    }

    default public void release() {
    }

    public void setPlayer(Looper var1, PlayerId var2);

    default public DrmSessionReference preacquireSession(@Nullable DrmSessionEventListener.EventDispatcher eventDispatcher, Format format) {
        return DrmSessionReference.EMPTY;
    }

    @Nullable
    public DrmSession acquireSession(@Nullable DrmSessionEventListener.EventDispatcher var1, Format var2);

    public int getCryptoType(Format var1);

    static {
        DUMMY = DRM_UNSUPPORTED = new DrmSessionManager(){

            @Override
            public void setPlayer(Looper playbackLooper, PlayerId playerId) {
            }

            @Override
            @Nullable
            public DrmSession acquireSession(@Nullable DrmSessionEventListener.EventDispatcher eventDispatcher, Format format) {
                if (format.drmInitData == null) {
                    return null;
                }
                return new ErrorStateDrmSession(new DrmSession.DrmSessionException(new UnsupportedDrmException(1), 6001));
            }

            @Override
            public int getCryptoType(Format format) {
                return format.drmInitData != null ? 1 : 0;
            }
        };
    }

    public static interface DrmSessionReference {
        public static final DrmSessionReference EMPTY = () -> {};

        public void release();
    }
}

