/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer.drm;

import android.net.Uri;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import androidx.media3.common.C;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import androidx.media3.datasource.DataSource;
import androidx.media3.datasource.DataSourceInputStream;
import androidx.media3.datasource.DataSpec;
import androidx.media3.datasource.HttpDataSource;
import androidx.media3.datasource.StatsDataSource;
import androidx.media3.exoplayer.drm.ExoMediaDrm;
import androidx.media3.exoplayer.drm.MediaDrmCallback;
import androidx.media3.exoplayer.drm.MediaDrmCallbackException;
import com.google.common.collect.ImmutableMap;
import java.io.Closeable;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

@UnstableApi
public final class HttpMediaDrmCallback
implements MediaDrmCallback {
    private static final int MAX_MANUAL_REDIRECTS = 5;
    private final DataSource.Factory dataSourceFactory;
    @Nullable
    private final String defaultLicenseUrl;
    private final boolean forceDefaultLicenseUrl;
    private final Map<String, String> keyRequestProperties;

    public HttpMediaDrmCallback(@Nullable String defaultLicenseUrl, DataSource.Factory dataSourceFactory) {
        this(defaultLicenseUrl, false, dataSourceFactory);
    }

    public HttpMediaDrmCallback(@Nullable String defaultLicenseUrl, boolean forceDefaultLicenseUrl, DataSource.Factory dataSourceFactory) {
        Assertions.checkArgument((!forceDefaultLicenseUrl || !TextUtils.isEmpty((CharSequence)defaultLicenseUrl) ? 1 : 0) != 0);
        this.dataSourceFactory = dataSourceFactory;
        this.defaultLicenseUrl = defaultLicenseUrl;
        this.forceDefaultLicenseUrl = forceDefaultLicenseUrl;
        this.keyRequestProperties = new HashMap<String, String>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setKeyRequestProperty(String name, String value) {
        Assertions.checkNotNull((Object)name);
        Assertions.checkNotNull((Object)value);
        Map<String, String> map = this.keyRequestProperties;
        synchronized (map) {
            this.keyRequestProperties.put(name, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearKeyRequestProperty(String name) {
        Assertions.checkNotNull((Object)name);
        Map<String, String> map = this.keyRequestProperties;
        synchronized (map) {
            this.keyRequestProperties.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAllKeyRequestProperties() {
        Map<String, String> map = this.keyRequestProperties;
        synchronized (map) {
            this.keyRequestProperties.clear();
        }
    }

    @Override
    public byte[] executeProvisionRequest(UUID uuid, ExoMediaDrm.ProvisionRequest request) throws MediaDrmCallbackException {
        String url = request.getDefaultUrl() + "&signedRequest=" + Util.fromUtf8Bytes((byte[])request.getData());
        return HttpMediaDrmCallback.executePost(this.dataSourceFactory, url, null, Collections.emptyMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] executeKeyRequest(UUID uuid, ExoMediaDrm.KeyRequest request) throws MediaDrmCallbackException {
        String url = request.getLicenseServerUrl();
        if (this.forceDefaultLicenseUrl || TextUtils.isEmpty((CharSequence)url)) {
            url = this.defaultLicenseUrl;
        }
        if (TextUtils.isEmpty((CharSequence)url)) {
            throw new MediaDrmCallbackException(new DataSpec.Builder().setUri(Uri.EMPTY).build(), Uri.EMPTY, (Map<String, List<String>>)ImmutableMap.of(), 0L, new IllegalStateException("No license URL"));
        }
        HashMap<String, String> requestProperties = new HashMap<String, String>();
        String contentType = C.PLAYREADY_UUID.equals(uuid) ? "text/xml" : (C.CLEARKEY_UUID.equals(uuid) ? "application/json" : "application/octet-stream");
        requestProperties.put("Content-Type", contentType);
        if (C.PLAYREADY_UUID.equals(uuid)) {
            requestProperties.put("SOAPAction", "http://schemas.microsoft.com/DRM/2007/03/protocols/AcquireLicense");
        }
        Map<String, String> map = this.keyRequestProperties;
        synchronized (map) {
            requestProperties.putAll(this.keyRequestProperties);
        }
        return HttpMediaDrmCallback.executePost(this.dataSourceFactory, url, request.getData(), requestProperties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static byte[] executePost(DataSource.Factory dataSourceFactory, String url, @Nullable byte[] httpBody, Map<String, String> requestProperties) throws MediaDrmCallbackException {
        dataSource = new StatsDataSource(dataSourceFactory.createDataSource());
        manualRedirectCount = 0;
        originalDataSpec = dataSpec = new DataSpec.Builder().setUri(url).setHttpRequestHeaders(requestProperties).setHttpMethod(2).setHttpBody(httpBody).setFlags(1).build();
        try {
            while (true) lbl-1000:
            // 3 sources

            {
                inputStream = new DataSourceInputStream((DataSource)dataSource, dataSpec);
                try {
                    var9_11 = Util.toByteArray((InputStream)inputStream);
                    return var9_11;
                }
                catch (HttpDataSource.InvalidResponseCodeException e) {
                    redirectUrl = HttpMediaDrmCallback.getRedirectUrl(e, manualRedirectCount);
                    if (redirectUrl == null) {
                        throw e;
                    }
                    ++manualRedirectCount;
                    dataSpec = dataSpec.buildUpon().setUri(redirectUrl).build();
                }
                finally {
                    Util.closeQuietly((Closeable)inputStream);
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            throw new MediaDrmCallbackException(originalDataSpec, (Uri)Assertions.checkNotNull((Object)dataSource.getLastOpenedUri()), dataSource.getResponseHeaders(), dataSource.getBytesRead(), e);
        }
        ** GOTO lbl-1000
    }

    @Nullable
    private static String getRedirectUrl(HttpDataSource.InvalidResponseCodeException exception, int manualRedirectCount) {
        List locationHeaders;
        boolean manuallyRedirect;
        boolean bl = manuallyRedirect = (exception.responseCode == 307 || exception.responseCode == 308) && manualRedirectCount < 5;
        if (!manuallyRedirect) {
            return null;
        }
        Map headerFields = exception.headerFields;
        if (headerFields != null && (locationHeaders = (List)headerFields.get("Location")) != null && !locationHeaders.isEmpty()) {
            return (String)locationHeaders.get(0);
        }
        return null;
    }
}

