/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer.metadata;

import androidx.media3.common.Format;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.extractor.metadata.MetadataDecoder;
import androidx.media3.extractor.metadata.dvbsi.AppInfoTableDecoder;
import androidx.media3.extractor.metadata.emsg.EventMessageDecoder;
import androidx.media3.extractor.metadata.icy.IcyDecoder;
import androidx.media3.extractor.metadata.id3.Id3Decoder;
import androidx.media3.extractor.metadata.scte35.SpliceInfoDecoder;

@UnstableApi
public interface MetadataDecoderFactory {
    public static final MetadataDecoderFactory DEFAULT = new MetadataDecoderFactory(){

        @Override
        public boolean supportsFormat(Format format) {
            String mimeType = format.sampleMimeType;
            return "application/id3".equals(mimeType) || "application/x-emsg".equals(mimeType) || "application/x-scte35".equals(mimeType) || "application/x-icy".equals(mimeType) || "application/vnd.dvb.ait".equals(mimeType);
        }

        @Override
        public MetadataDecoder createDecoder(Format format) {
            String mimeType = format.sampleMimeType;
            if (mimeType != null) {
                switch (mimeType) {
                    case "application/id3": {
                        return new Id3Decoder();
                    }
                    case "application/x-emsg": {
                        return new EventMessageDecoder();
                    }
                    case "application/x-scte35": {
                        return new SpliceInfoDecoder();
                    }
                    case "application/x-icy": {
                        return new IcyDecoder();
                    }
                    case "application/vnd.dvb.ait": {
                        return new AppInfoTableDecoder();
                    }
                }
            }
            throw new IllegalArgumentException("Attempted to create decoder for unsupported MIME type: " + mimeType);
        }
    };

    public boolean supportsFormat(Format var1);

    public MetadataDecoder createDecoder(Format var1);
}

