/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer.offline;

import android.annotation.SuppressLint;
import android.app.Notification;
import android.app.PendingIntent;
import android.content.Context;
import androidx.annotation.DoNotInline;
import androidx.annotation.DrawableRes;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.StringRes;
import androidx.core.app.NotificationCompat;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import androidx.media3.exoplayer.R;
import androidx.media3.exoplayer.offline.Download;
import java.util.List;

@UnstableApi
public final class DownloadNotificationHelper {
    @StringRes
    private static final int NULL_STRING_ID = 0;
    private final NotificationCompat.Builder notificationBuilder;

    public DownloadNotificationHelper(Context context, String channelId) {
        this.notificationBuilder = new NotificationCompat.Builder(context.getApplicationContext(), channelId);
    }

    @Deprecated
    public Notification buildProgressNotification(Context context, @DrawableRes int smallIcon, @Nullable PendingIntent contentIntent, @Nullable String message, List<Download> downloads) {
        return this.buildProgressNotification(context, smallIcon, contentIntent, message, downloads, 0);
    }

    public Notification buildProgressNotification(Context context, @DrawableRes int smallIcon, @Nullable PendingIntent contentIntent, @Nullable String message, List<Download> downloads, int notMetRequirements) {
        int titleStringId;
        float totalPercentage = 0.0f;
        int downloadTaskCount = 0;
        boolean allDownloadPercentagesUnknown = true;
        boolean haveDownloadedBytes = false;
        boolean haveDownloadingTasks = false;
        boolean haveQueuedTasks = false;
        boolean haveRemovingTasks = false;
        block5: for (int i = 0; i < downloads.size(); ++i) {
            Download download = downloads.get(i);
            switch (download.state) {
                case 5: {
                    haveRemovingTasks = true;
                    continue block5;
                }
                case 0: {
                    haveQueuedTasks = true;
                    continue block5;
                }
                case 2: 
                case 7: {
                    haveDownloadingTasks = true;
                    float downloadPercentage = download.getPercentDownloaded();
                    if (downloadPercentage != -1.0f) {
                        allDownloadPercentagesUnknown = false;
                        totalPercentage += downloadPercentage;
                    }
                    haveDownloadedBytes |= download.getBytesDownloaded() > 0L;
                    ++downloadTaskCount;
                    continue block5;
                }
            }
        }
        boolean showProgress = true;
        if (haveDownloadingTasks) {
            titleStringId = R.string.exo_download_downloading;
        } else if (haveQueuedTasks && notMetRequirements != 0) {
            showProgress = false;
            titleStringId = (notMetRequirements & 2) != 0 ? R.string.exo_download_paused_for_wifi : ((notMetRequirements & 1) != 0 ? R.string.exo_download_paused_for_network : R.string.exo_download_paused);
        } else {
            titleStringId = haveRemovingTasks ? R.string.exo_download_removing : 0;
        }
        int maxProgress = 0;
        int currentProgress = 0;
        boolean indeterminateProgress = false;
        if (showProgress) {
            maxProgress = 100;
            if (haveDownloadingTasks) {
                currentProgress = (int)(totalPercentage / (float)downloadTaskCount);
                indeterminateProgress = allDownloadPercentagesUnknown && haveDownloadedBytes;
            } else {
                indeterminateProgress = true;
            }
        }
        return this.buildNotification(context, smallIcon, contentIntent, message, titleStringId, maxProgress, currentProgress, indeterminateProgress, true, false);
    }

    public Notification buildDownloadCompletedNotification(Context context, @DrawableRes int smallIcon, @Nullable PendingIntent contentIntent, @Nullable String message) {
        int titleStringId = R.string.exo_download_completed;
        return this.buildEndStateNotification(context, smallIcon, contentIntent, message, titleStringId);
    }

    public Notification buildDownloadFailedNotification(Context context, @DrawableRes int smallIcon, @Nullable PendingIntent contentIntent, @Nullable String message) {
        int titleStringId = R.string.exo_download_failed;
        return this.buildEndStateNotification(context, smallIcon, contentIntent, message, titleStringId);
    }

    private Notification buildEndStateNotification(Context context, @DrawableRes int smallIcon, @Nullable PendingIntent contentIntent, @Nullable String message, @StringRes int titleStringId) {
        return this.buildNotification(context, smallIcon, contentIntent, message, titleStringId, 0, 0, false, false, true);
    }

    private Notification buildNotification(Context context, @DrawableRes int smallIcon, @Nullable PendingIntent contentIntent, @Nullable String message, @StringRes int titleStringId, int maxProgress, int currentProgress, boolean indeterminateProgress, boolean ongoing, boolean showWhen) {
        this.notificationBuilder.setSmallIcon(smallIcon);
        this.notificationBuilder.setContentTitle(titleStringId == 0 ? null : context.getResources().getString(titleStringId));
        this.notificationBuilder.setContentIntent(contentIntent);
        this.notificationBuilder.setStyle(message == null ? null : new NotificationCompat.BigTextStyle().bigText((CharSequence)message));
        this.notificationBuilder.setProgress(maxProgress, currentProgress, indeterminateProgress);
        this.notificationBuilder.setOngoing(ongoing);
        this.notificationBuilder.setShowWhen(showWhen);
        if (Util.SDK_INT >= 31) {
            Api31.setForegroundServiceBehavior(this.notificationBuilder);
        }
        return this.notificationBuilder.build();
    }

    @RequiresApi(value=31)
    private static final class Api31 {
        private Api31() {
        }

        @SuppressLint(value={"WrongConstant"})
        @DoNotInline
        public static void setForegroundServiceBehavior(NotificationCompat.Builder notificationBuilder) {
            notificationBuilder.setForegroundServiceBehavior(1);
        }
    }
}

