/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer.upstream;

import android.net.Uri;
import androidx.annotation.Nullable;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import androidx.media3.datasource.DataSource;
import androidx.media3.datasource.DataSourceInputStream;
import androidx.media3.datasource.DataSpec;
import androidx.media3.datasource.StatsDataSource;
import androidx.media3.exoplayer.source.LoadEventInfo;
import androidx.media3.exoplayer.upstream.Loader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;

@UnstableApi
public final class ParsingLoadable<T>
implements Loader.Loadable {
    public final long loadTaskId;
    public final DataSpec dataSpec;
    public final int type;
    private final StatsDataSource dataSource;
    private final Parser<? extends T> parser;
    @Nullable
    private volatile T result;

    public static <T> T load(DataSource dataSource, Parser<? extends T> parser, Uri uri, int type) throws IOException {
        ParsingLoadable<T> loadable = new ParsingLoadable<T>(dataSource, uri, type, parser);
        loadable.load();
        return (T)Assertions.checkNotNull(loadable.getResult());
    }

    public static <T> T load(DataSource dataSource, Parser<? extends T> parser, DataSpec dataSpec, int type) throws IOException {
        ParsingLoadable<T> loadable = new ParsingLoadable<T>(dataSource, dataSpec, type, parser);
        loadable.load();
        return (T)Assertions.checkNotNull(loadable.getResult());
    }

    public ParsingLoadable(DataSource dataSource, Uri uri, int type, Parser<? extends T> parser) {
        this(dataSource, new DataSpec.Builder().setUri(uri).setFlags(1).build(), type, parser);
    }

    public ParsingLoadable(DataSource dataSource, DataSpec dataSpec, int type, Parser<? extends T> parser) {
        this.dataSource = new StatsDataSource(dataSource);
        this.dataSpec = dataSpec;
        this.type = type;
        this.parser = parser;
        this.loadTaskId = LoadEventInfo.getNewId();
    }

    @Nullable
    public final T getResult() {
        return this.result;
    }

    public long bytesLoaded() {
        return this.dataSource.getBytesRead();
    }

    public Uri getUri() {
        return this.dataSource.getLastOpenedUri();
    }

    public Map<String, List<String>> getResponseHeaders() {
        return this.dataSource.getLastResponseHeaders();
    }

    @Override
    public final void cancelLoad() {
    }

    @Override
    public final void load() throws IOException {
        this.dataSource.resetBytesRead();
        DataSourceInputStream inputStream = new DataSourceInputStream((DataSource)this.dataSource, this.dataSpec);
        try {
            inputStream.open();
            Uri dataSourceUri = (Uri)Assertions.checkNotNull((Object)this.dataSource.getUri());
            this.result = this.parser.parse(dataSourceUri, (InputStream)inputStream);
        }
        finally {
            Util.closeQuietly((Closeable)inputStream);
        }
    }

    public static interface Parser<T> {
        public T parse(Uri var1, InputStream var2) throws IOException;
    }
}

