/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.decoder;

import androidx.annotation.CallSuper;
import androidx.annotation.Nullable;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.decoder.Buffer;
import androidx.media3.decoder.Decoder;
import androidx.media3.decoder.DecoderException;
import androidx.media3.decoder.DecoderInputBuffer;
import androidx.media3.decoder.DecoderOutputBuffer;
import java.util.ArrayDeque;

@UnstableApi
public abstract class SimpleDecoder<I extends DecoderInputBuffer, O extends DecoderOutputBuffer, E extends DecoderException>
implements Decoder<I, O, E> {
    private final Thread decodeThread;
    private final Object lock = new Object();
    private final ArrayDeque<I> queuedInputBuffers = new ArrayDeque();
    private final ArrayDeque<O> queuedOutputBuffers = new ArrayDeque();
    private final I[] availableInputBuffers;
    private final O[] availableOutputBuffers;
    private int availableInputBufferCount;
    private int availableOutputBufferCount;
    @Nullable
    private I dequeuedInputBuffer;
    @Nullable
    private E exception;
    private boolean flushed;
    private boolean released;
    private int skippedOutputBufferCount;

    protected SimpleDecoder(I[] inputBuffers, O[] outputBuffers) {
        int i;
        this.availableInputBuffers = inputBuffers;
        this.availableInputBufferCount = inputBuffers.length;
        for (i = 0; i < this.availableInputBufferCount; ++i) {
            this.availableInputBuffers[i] = this.createInputBuffer();
        }
        this.availableOutputBuffers = outputBuffers;
        this.availableOutputBufferCount = outputBuffers.length;
        for (i = 0; i < this.availableOutputBufferCount; ++i) {
            this.availableOutputBuffers[i] = this.createOutputBuffer();
        }
        this.decodeThread = new Thread("ExoPlayer:SimpleDecoder"){

            @Override
            public void run() {
                SimpleDecoder.this.run();
            }
        };
        this.decodeThread.start();
    }

    protected final void setInitialInputBufferSize(int size) {
        Assertions.checkState((this.availableInputBufferCount == this.availableInputBuffers.length ? 1 : 0) != 0);
        for (I inputBuffer : this.availableInputBuffers) {
            ((DecoderInputBuffer)inputBuffer).ensureSpaceForWrite(size);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public final I dequeueInputBuffer() throws E {
        Object object = this.lock;
        synchronized (object) {
            this.maybeThrowException();
            Assertions.checkState((this.dequeuedInputBuffer == null ? 1 : 0) != 0);
            this.dequeuedInputBuffer = this.availableInputBufferCount == 0 ? null : this.availableInputBuffers[--this.availableInputBufferCount];
            return this.dequeuedInputBuffer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void queueInputBuffer(I inputBuffer) throws E {
        Object object = this.lock;
        synchronized (object) {
            this.maybeThrowException();
            Assertions.checkArgument((inputBuffer == this.dequeuedInputBuffer ? 1 : 0) != 0);
            this.queuedInputBuffers.addLast(inputBuffer);
            this.maybeNotifyDecodeLoop();
            this.dequeuedInputBuffer = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public final O dequeueOutputBuffer() throws E {
        Object object = this.lock;
        synchronized (object) {
            this.maybeThrowException();
            if (this.queuedOutputBuffers.isEmpty()) {
                return null;
            }
            return (O)((DecoderOutputBuffer)this.queuedOutputBuffers.removeFirst());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CallSuper
    protected void releaseOutputBuffer(O outputBuffer) {
        Object object = this.lock;
        synchronized (object) {
            this.releaseOutputBufferInternal(outputBuffer);
            this.maybeNotifyDecodeLoop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void flush() {
        Object object = this.lock;
        synchronized (object) {
            this.flushed = true;
            this.skippedOutputBufferCount = 0;
            if (this.dequeuedInputBuffer != null) {
                this.releaseInputBufferInternal(this.dequeuedInputBuffer);
                this.dequeuedInputBuffer = null;
            }
            while (!this.queuedInputBuffers.isEmpty()) {
                this.releaseInputBufferInternal((DecoderInputBuffer)this.queuedInputBuffers.removeFirst());
            }
            while (!this.queuedOutputBuffers.isEmpty()) {
                ((DecoderOutputBuffer)this.queuedOutputBuffers.removeFirst()).release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @CallSuper
    public void release() {
        Object object = this.lock;
        synchronized (object) {
            this.released = true;
            this.lock.notify();
        }
        try {
            this.decodeThread.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private void maybeThrowException() throws E {
        E exception = this.exception;
        if (exception != null) {
            throw exception;
        }
    }

    private void maybeNotifyDecodeLoop() {
        if (this.canDecodeBuffer()) {
            this.lock.notify();
        }
    }

    private void run() {
        try {
            while (this.decode()) {
            }
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean decode() throws InterruptedException {
        boolean resetDecoder;
        O outputBuffer;
        DecoderInputBuffer inputBuffer;
        Object object = this.lock;
        synchronized (object) {
            while (!this.released && !this.canDecodeBuffer()) {
                this.lock.wait();
            }
            if (this.released) {
                return false;
            }
            inputBuffer = (DecoderInputBuffer)this.queuedInputBuffers.removeFirst();
            outputBuffer = this.availableOutputBuffers[--this.availableOutputBufferCount];
            resetDecoder = this.flushed;
            this.flushed = false;
        }
        if (inputBuffer.isEndOfStream()) {
            ((Buffer)outputBuffer).addFlag(4);
        } else {
            E exception;
            if (inputBuffer.isDecodeOnly()) {
                ((Buffer)outputBuffer).addFlag(Integer.MIN_VALUE);
            }
            if (inputBuffer.isFirstSample()) {
                ((Buffer)outputBuffer).addFlag(0x8000000);
            }
            try {
                exception = this.decode(inputBuffer, outputBuffer, resetDecoder);
            }
            catch (RuntimeException e) {
                exception = this.createUnexpectedDecodeException(e);
            }
            catch (OutOfMemoryError e) {
                exception = this.createUnexpectedDecodeException(e);
            }
            if (exception != null) {
                Object object2 = this.lock;
                synchronized (object2) {
                    this.exception = exception;
                }
                return false;
            }
        }
        object = this.lock;
        synchronized (object) {
            if (this.flushed) {
                ((DecoderOutputBuffer)outputBuffer).release();
            } else if (((Buffer)outputBuffer).isDecodeOnly()) {
                ++this.skippedOutputBufferCount;
                ((DecoderOutputBuffer)outputBuffer).release();
            } else {
                ((DecoderOutputBuffer)outputBuffer).skippedOutputBufferCount = this.skippedOutputBufferCount;
                this.skippedOutputBufferCount = 0;
                this.queuedOutputBuffers.addLast(outputBuffer);
            }
            this.releaseInputBufferInternal(inputBuffer);
        }
        return true;
    }

    private boolean canDecodeBuffer() {
        return !this.queuedInputBuffers.isEmpty() && this.availableOutputBufferCount > 0;
    }

    private void releaseInputBufferInternal(I inputBuffer) {
        ((DecoderInputBuffer)inputBuffer).clear();
        this.availableInputBuffers[this.availableInputBufferCount++] = inputBuffer;
    }

    private void releaseOutputBufferInternal(O outputBuffer) {
        ((Buffer)outputBuffer).clear();
        this.availableOutputBuffers[this.availableOutputBufferCount++] = outputBuffer;
    }

    protected abstract I createInputBuffer();

    protected abstract O createOutputBuffer();

    protected abstract E createUnexpectedDecodeException(Throwable var1);

    @Nullable
    protected abstract E decode(I var1, O var2, boolean var3);
}

