/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer.audio;

import android.os.Handler;
import androidx.annotation.Nullable;
import androidx.media3.common.Format;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import androidx.media3.exoplayer.DecoderCounters;
import androidx.media3.exoplayer.DecoderReuseEvaluation;

@UnstableApi
public interface AudioRendererEventListener {
    default public void onAudioEnabled(DecoderCounters counters) {
    }

    default public void onAudioDecoderInitialized(String decoderName, long initializedTimestampMs, long initializationDurationMs) {
    }

    @Deprecated
    default public void onAudioInputFormatChanged(Format format) {
    }

    default public void onAudioInputFormatChanged(Format format, @Nullable DecoderReuseEvaluation decoderReuseEvaluation) {
    }

    default public void onAudioPositionAdvancing(long playoutStartSystemTimeMs) {
    }

    default public void onAudioUnderrun(int bufferSize, long bufferSizeMs, long elapsedSinceLastFeedMs) {
    }

    default public void onAudioDecoderReleased(String decoderName) {
    }

    default public void onAudioDisabled(DecoderCounters counters) {
    }

    default public void onSkipSilenceEnabledChanged(boolean skipSilenceEnabled) {
    }

    default public void onAudioCodecError(Exception audioCodecError) {
    }

    default public void onAudioSinkError(Exception audioSinkError) {
    }

    public static final class EventDispatcher {
        @Nullable
        private final Handler handler;
        @Nullable
        private final AudioRendererEventListener listener;

        public EventDispatcher(@Nullable Handler handler, @Nullable AudioRendererEventListener listener) {
            this.handler = listener != null ? (Handler)Assertions.checkNotNull((Object)handler) : null;
            this.listener = listener;
        }

        public void enabled(DecoderCounters decoderCounters) {
            if (this.handler != null) {
                this.handler.post(() -> ((AudioRendererEventListener)Util.castNonNull((Object)this.listener)).onAudioEnabled(decoderCounters));
            }
        }

        public void decoderInitialized(String decoderName, long initializedTimestampMs, long initializationDurationMs) {
            if (this.handler != null) {
                this.handler.post(() -> ((AudioRendererEventListener)Util.castNonNull((Object)this.listener)).onAudioDecoderInitialized(decoderName, initializedTimestampMs, initializationDurationMs));
            }
        }

        public void inputFormatChanged(Format format, @Nullable DecoderReuseEvaluation decoderReuseEvaluation) {
            if (this.handler != null) {
                this.handler.post(() -> {
                    ((AudioRendererEventListener)Util.castNonNull((Object)this.listener)).onAudioInputFormatChanged(format);
                    ((AudioRendererEventListener)Util.castNonNull((Object)this.listener)).onAudioInputFormatChanged(format, decoderReuseEvaluation);
                });
            }
        }

        public void positionAdvancing(long playoutStartSystemTimeMs) {
            if (this.handler != null) {
                this.handler.post(() -> ((AudioRendererEventListener)Util.castNonNull((Object)this.listener)).onAudioPositionAdvancing(playoutStartSystemTimeMs));
            }
        }

        public void underrun(int bufferSize, long bufferSizeMs, long elapsedSinceLastFeedMs) {
            if (this.handler != null) {
                this.handler.post(() -> ((AudioRendererEventListener)Util.castNonNull((Object)this.listener)).onAudioUnderrun(bufferSize, bufferSizeMs, elapsedSinceLastFeedMs));
            }
        }

        public void decoderReleased(String decoderName) {
            if (this.handler != null) {
                this.handler.post(() -> ((AudioRendererEventListener)Util.castNonNull((Object)this.listener)).onAudioDecoderReleased(decoderName));
            }
        }

        public void disabled(DecoderCounters counters) {
            counters.ensureUpdated();
            if (this.handler != null) {
                this.handler.post(() -> {
                    counters.ensureUpdated();
                    ((AudioRendererEventListener)Util.castNonNull((Object)this.listener)).onAudioDisabled(counters);
                });
            }
        }

        public void skipSilenceEnabledChanged(boolean skipSilenceEnabled) {
            if (this.handler != null) {
                this.handler.post(() -> ((AudioRendererEventListener)Util.castNonNull((Object)this.listener)).onSkipSilenceEnabledChanged(skipSilenceEnabled));
            }
        }

        public void audioSinkError(Exception audioSinkError) {
            if (this.handler != null) {
                this.handler.post(() -> ((AudioRendererEventListener)Util.castNonNull((Object)this.listener)).onAudioSinkError(audioSinkError));
            }
        }

        public void audioCodecError(Exception audioCodecError) {
            if (this.handler != null) {
                this.handler.post(() -> ((AudioRendererEventListener)Util.castNonNull((Object)this.listener)).onAudioCodecError(audioCodecError));
            }
        }
    }
}

