/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer.offline;

import androidx.media3.common.util.UnstableApi;
import androidx.media3.exoplayer.offline.Download;
import java.io.Closeable;

@UnstableApi
public interface DownloadCursor
extends Closeable {
    public Download getDownload();

    public int getCount();

    public int getPosition();

    public boolean moveToPosition(int var1);

    default public boolean moveToFirst() {
        return this.moveToPosition(0);
    }

    default public boolean moveToLast() {
        return this.moveToPosition(this.getCount() - 1);
    }

    default public boolean moveToNext() {
        return this.moveToPosition(this.getPosition() + 1);
    }

    default public boolean moveToPrevious() {
        return this.moveToPosition(this.getPosition() - 1);
    }

    default public boolean isFirst() {
        return this.getPosition() == 0 && this.getCount() != 0;
    }

    default public boolean isLast() {
        int count = this.getCount();
        return this.getPosition() == count - 1 && count != 0;
    }

    default public boolean isBeforeFirst() {
        if (this.getCount() == 0) {
            return true;
        }
        return this.getPosition() == -1;
    }

    default public boolean isAfterLast() {
        if (this.getCount() == 0) {
            return true;
        }
        return this.getPosition() == this.getCount();
    }

    public boolean isClosed();

    @Override
    public void close();
}

