/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer.rtsp;

import android.net.Uri;
import androidx.annotation.Nullable;
import androidx.media3.common.ParserException;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import androidx.media3.exoplayer.rtsp.RtspAuthenticationInfo;
import androidx.media3.exoplayer.rtsp.RtspHeaders;
import androidx.media3.exoplayer.rtsp.RtspMessageChannel;
import androidx.media3.exoplayer.rtsp.RtspRequest;
import androidx.media3.exoplayer.rtsp.RtspResponse;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@UnstableApi
final class RtspMessageUtil {
    public static final long DEFAULT_RTSP_TIMEOUT_MS = 60000L;
    private static final Pattern REQUEST_LINE_PATTERN = Pattern.compile("([A-Z_]+) (.*) RTSP/1\\.0");
    private static final Pattern STATUS_LINE_PATTERN = Pattern.compile("RTSP/1\\.0 (\\d+) (.+)");
    private static final Pattern CONTENT_LENGTH_HEADER_PATTERN = Pattern.compile("Content-Length:\\s?(\\d+)", 2);
    private static final Pattern SESSION_HEADER_PATTERN = Pattern.compile("([\\w$\\-_.+]+)(?:;\\s?timeout=(\\d+))?");
    private static final Pattern WWW_AUTHENTICATION_HEADER_DIGEST_PATTERN = Pattern.compile("Digest realm=\"([^\"\\x00-\\x08\\x0A-\\x1f\\x7f]+)\",\\s?(?:domain=\"(.+)\",\\s?)?nonce=\"([^\"\\x00-\\x08\\x0A-\\x1f\\x7f]+)\"(?:,\\s?opaque=\"([^\"\\x00-\\x08\\x0A-\\x1f\\x7f]+)\")?");
    private static final Pattern WWW_AUTHENTICATION_HEADER_BASIC_PATTERN = Pattern.compile("Basic realm=\"([^\"\\x00-\\x08\\x0A-\\x1f\\x7f]+)\"");
    private static final String RTSP_VERSION = "RTSP/1.0";
    private static final String LF = new String(new byte[]{10});
    private static final String CRLF = new String(new byte[]{13, 10});

    public static ImmutableList<String> serializeRequest(RtspRequest request) {
        Assertions.checkArgument((request.headers.get("CSeq") != null ? 1 : 0) != 0);
        ImmutableList.Builder builder = new ImmutableList.Builder();
        builder.add((Object)Util.formatInvariant((String)"%s %s %s", (Object[])new Object[]{RtspMessageUtil.toMethodString(request.method), request.uri, RTSP_VERSION}));
        ImmutableListMultimap<String, String> headers = request.headers.asMultiMap();
        for (String headerName : headers.keySet()) {
            ImmutableList headerValuesForName = headers.get((Object)headerName);
            for (int i = 0; i < headerValuesForName.size(); ++i) {
                builder.add((Object)Util.formatInvariant((String)"%s: %s", (Object[])new Object[]{headerName, headerValuesForName.get(i)}));
            }
        }
        builder.add((Object)"");
        builder.add((Object)request.messageBody);
        return builder.build();
    }

    public static ImmutableList<String> serializeResponse(RtspResponse response) {
        Assertions.checkArgument((response.headers.get("CSeq") != null ? 1 : 0) != 0);
        ImmutableList.Builder builder = new ImmutableList.Builder();
        builder.add((Object)Util.formatInvariant((String)"%s %s %s", (Object[])new Object[]{RTSP_VERSION, response.status, RtspMessageUtil.getRtspStatusReasonPhrase(response.status)}));
        ImmutableListMultimap<String, String> headers = response.headers.asMultiMap();
        for (String headerName : headers.keySet()) {
            ImmutableList headerValuesForName = headers.get((Object)headerName);
            for (int i = 0; i < headerValuesForName.size(); ++i) {
                builder.add((Object)Util.formatInvariant((String)"%s: %s", (Object[])new Object[]{headerName, headerValuesForName.get(i)}));
            }
        }
        builder.add((Object)"");
        builder.add((Object)response.messageBody);
        return builder.build();
    }

    public static byte[] convertMessageToByteArray(List<String> message) {
        return Joiner.on((String)CRLF).join(message).getBytes(RtspMessageChannel.CHARSET);
    }

    public static Uri removeUserInfo(Uri uri) {
        if (uri.getUserInfo() == null) {
            return uri;
        }
        String authorityWithUserInfo = (String)Assertions.checkNotNull((Object)uri.getAuthority());
        Assertions.checkArgument((boolean)authorityWithUserInfo.contains("@"));
        String authority = Util.split((String)authorityWithUserInfo, (String)"@")[1];
        return uri.buildUpon().encodedAuthority(authority).build();
    }

    @Nullable
    public static RtspAuthUserInfo parseUserInfo(Uri uri) {
        String userInfo = uri.getUserInfo();
        if (userInfo == null) {
            return null;
        }
        if (userInfo.contains(":")) {
            String[] userInfoStrings = Util.splitAtFirst((String)userInfo, (String)":");
            return new RtspAuthUserInfo(userInfoStrings[0], userInfoStrings[1]);
        }
        return null;
    }

    public static byte[] getStringBytes(String s) {
        return s.getBytes(RtspMessageChannel.CHARSET);
    }

    public static String toMethodString(int method) {
        switch (method) {
            case 1: {
                return "ANNOUNCE";
            }
            case 2: {
                return "DESCRIBE";
            }
            case 3: {
                return "GET_PARAMETER";
            }
            case 4: {
                return "OPTIONS";
            }
            case 5: {
                return "PAUSE";
            }
            case 6: {
                return "PLAY";
            }
            case 7: {
                return "PLAY_NOTIFY";
            }
            case 8: {
                return "RECORD";
            }
            case 9: {
                return "REDIRECT";
            }
            case 10: {
                return "SETUP";
            }
            case 11: {
                return "SET_PARAMETER";
            }
            case 12: {
                return "TEARDOWN";
            }
        }
        throw new IllegalStateException();
    }

    private static int parseMethodString(String method) {
        switch (method) {
            case "ANNOUNCE": {
                return 1;
            }
            case "DESCRIBE": {
                return 2;
            }
            case "GET_PARAMETER": {
                return 3;
            }
            case "OPTIONS": {
                return 4;
            }
            case "PAUSE": {
                return 5;
            }
            case "PLAY": {
                return 6;
            }
            case "PLAY_NOTIFY": {
                return 7;
            }
            case "RECORD": {
                return 8;
            }
            case "REDIRECT": {
                return 9;
            }
            case "SETUP": {
                return 10;
            }
            case "SET_PARAMETER": {
                return 11;
            }
            case "TEARDOWN": {
                return 12;
            }
        }
        throw new IllegalArgumentException();
    }

    public static RtspResponse parseResponse(List<String> lines) {
        Matcher statusLineMatcher = STATUS_LINE_PATTERN.matcher(lines.get(0));
        Assertions.checkArgument((boolean)statusLineMatcher.matches());
        int statusCode = Integer.parseInt((String)Assertions.checkNotNull((Object)statusLineMatcher.group(1)));
        int messageBodyOffset = lines.indexOf("");
        Assertions.checkArgument((messageBodyOffset > 0 ? 1 : 0) != 0);
        List<String> headerLines = lines.subList(1, messageBodyOffset);
        RtspHeaders headers = new RtspHeaders.Builder().addAll(headerLines).build();
        String messageBody = Joiner.on((String)CRLF).join(lines.subList(messageBodyOffset + 1, lines.size()));
        return new RtspResponse(statusCode, headers, messageBody);
    }

    public static RtspRequest parseRequest(List<String> lines) {
        Matcher requestMatcher = REQUEST_LINE_PATTERN.matcher(lines.get(0));
        Assertions.checkArgument((boolean)requestMatcher.matches());
        int method = RtspMessageUtil.parseMethodString((String)Assertions.checkNotNull((Object)requestMatcher.group(1)));
        Uri requestUri = Uri.parse((String)((String)Assertions.checkNotNull((Object)requestMatcher.group(2))));
        int messageBodyOffset = lines.indexOf("");
        Assertions.checkArgument((messageBodyOffset > 0 ? 1 : 0) != 0);
        List<String> headerLines = lines.subList(1, messageBodyOffset);
        RtspHeaders headers = new RtspHeaders.Builder().addAll(headerLines).build();
        String messageBody = Joiner.on((String)CRLF).join(lines.subList(messageBodyOffset + 1, lines.size()));
        return new RtspRequest(requestUri, method, headers, messageBody);
    }

    public static boolean isRtspStartLine(String line) {
        return REQUEST_LINE_PATTERN.matcher(line).matches() || STATUS_LINE_PATTERN.matcher(line).matches();
    }

    public static boolean isRtspResponse(List<String> lines) {
        return STATUS_LINE_PATTERN.matcher(lines.get(0)).matches();
    }

    public static String[] splitRtspMessageBody(String body) {
        return Util.split((String)body, (String)(body.contains(CRLF) ? CRLF : LF));
    }

    public static long parseContentLengthHeader(String line) throws ParserException {
        try {
            Matcher matcher = CONTENT_LENGTH_HEADER_PATTERN.matcher(line);
            if (matcher.find()) {
                return Long.parseLong((String)Assertions.checkNotNull((Object)matcher.group(1)));
            }
            return -1L;
        }
        catch (NumberFormatException e) {
            throw ParserException.createForMalformedManifest((String)line, (Throwable)e);
        }
    }

    public static ImmutableList<Integer> parsePublicHeader(@Nullable String publicHeader) {
        if (publicHeader == null) {
            return ImmutableList.of();
        }
        ImmutableList.Builder methodListBuilder = new ImmutableList.Builder();
        for (String method : Util.split((String)publicHeader, (String)",\\s?")) {
            methodListBuilder.add((Object)RtspMessageUtil.parseMethodString(method));
        }
        return methodListBuilder.build();
    }

    public static RtspSessionHeader parseSessionHeader(String headerValue) throws ParserException {
        Matcher matcher = SESSION_HEADER_PATTERN.matcher(headerValue);
        if (!matcher.matches()) {
            throw ParserException.createForMalformedManifest((String)headerValue, null);
        }
        String sessionId = (String)Assertions.checkNotNull((Object)matcher.group(1));
        long timeoutMs = 60000L;
        String timeoutString = matcher.group(2);
        if (timeoutString != null) {
            try {
                timeoutMs = (long)Integer.parseInt(timeoutString) * 1000L;
            }
            catch (NumberFormatException e) {
                throw ParserException.createForMalformedManifest((String)headerValue, (Throwable)e);
            }
        }
        return new RtspSessionHeader(sessionId, timeoutMs);
    }

    public static RtspAuthenticationInfo parseWwwAuthenticateHeader(String headerValue) throws ParserException {
        Matcher matcher = WWW_AUTHENTICATION_HEADER_DIGEST_PATTERN.matcher(headerValue);
        if (matcher.find()) {
            return new RtspAuthenticationInfo(2, (String)Assertions.checkNotNull((Object)matcher.group(1)), (String)Assertions.checkNotNull((Object)matcher.group(3)), Strings.nullToEmpty((String)matcher.group(4)));
        }
        matcher = WWW_AUTHENTICATION_HEADER_BASIC_PATTERN.matcher(headerValue);
        if (matcher.matches()) {
            return new RtspAuthenticationInfo(1, (String)Assertions.checkNotNull((Object)matcher.group(1)), "", "");
        }
        throw ParserException.createForMalformedManifest((String)("Invalid WWW-Authenticate header " + headerValue), null);
    }

    public static void checkManifestExpression(boolean expression, @Nullable String message) throws ParserException {
        if (!expression) {
            throw ParserException.createForMalformedManifest((String)message, null);
        }
    }

    private static String getRtspStatusReasonPhrase(int statusCode) {
        switch (statusCode) {
            case 200: {
                return "OK";
            }
            case 301: {
                return "Move Permanently";
            }
            case 302: {
                return "Move Temporarily";
            }
            case 400: {
                return "Bad Request";
            }
            case 401: {
                return "Unauthorized";
            }
            case 404: {
                return "Not Found";
            }
            case 405: {
                return "Method Not Allowed";
            }
            case 454: {
                return "Session Not Found";
            }
            case 455: {
                return "Method Not Valid In This State";
            }
            case 456: {
                return "Header Field Not Valid";
            }
            case 457: {
                return "Invalid Range";
            }
            case 461: {
                return "Unsupported Transport";
            }
            case 500: {
                return "Internal Server Error";
            }
            case 505: {
                return "RTSP Version Not Supported";
            }
        }
        throw new IllegalArgumentException();
    }

    public static int parseInt(String intString) throws ParserException {
        try {
            return Integer.parseInt(intString);
        }
        catch (NumberFormatException e) {
            throw ParserException.createForMalformedManifest((String)intString, (Throwable)e);
        }
    }

    private RtspMessageUtil() {
    }

    public static final class RtspAuthUserInfo {
        public final String username;
        public final String password;

        public RtspAuthUserInfo(String username, String password) {
            this.username = username;
            this.password = password;
        }
    }

    public static final class RtspSessionHeader {
        public final String sessionId;
        public final long timeoutMs;

        public RtspSessionHeader(String sessionId, long timeoutMs) {
            this.sessionId = sessionId;
            this.timeoutMs = timeoutMs;
        }
    }
}

