/*
 * Decompiled with CFR 0.152.
 */
package com.renderheads.AVPro.Video;

import android.util.Log;
import java.util.concurrent.atomic.AtomicInteger;

public class AudioCaptureBuffer<T> {
    private float[] _data;
    private int _capacity;
    private AtomicInteger _read;
    private AtomicInteger _write;
    private AtomicInteger _watermark;
    private boolean m_bDebug;

    public AudioCaptureBuffer(int n) {
        AudioCaptureBuffer audioCaptureBuffer = this;
        audioCaptureBuffer._read = new AtomicInteger();
        audioCaptureBuffer._write = new AtomicInteger();
        audioCaptureBuffer._watermark = new AtomicInteger();
        audioCaptureBuffer.m_bDebug = false;
        audioCaptureBuffer.reset();
        this._data = new float[n];
        this._capacity = n;
    }

    private int getBytes(float[] fArray, int n) {
        if (this.m_bDebug) {
            Log.i((String)"AVProVideo", (String)("_read = " + this._read + " | _write = " + this._write + " | _watermark = " + this._watermark));
        }
        AudioCaptureBuffer audioCaptureBuffer = this;
        int n2 = audioCaptureBuffer._read.get();
        int n3 = audioCaptureBuffer._write.get();
        if (n3 >= n2) {
            if ((n3 -= n2) == 0) {
                return 0;
            }
            if (n > n3) {
                n = n3;
            }
            AudioCaptureBuffer audioCaptureBuffer2 = this;
            System.arraycopy(audioCaptureBuffer2._data, n2, fArray, 0, n);
            audioCaptureBuffer2._read.set(n2 + n);
            return n;
        }
        int n4 = this._watermark.get() - n2;
        if (n <= n4) {
            AudioCaptureBuffer audioCaptureBuffer3 = this;
            System.arraycopy(audioCaptureBuffer3._data, n2, fArray, 0, n);
            audioCaptureBuffer3._read.set(n2 + n);
            return n;
        }
        if (n <= n4 + n3) {
            n3 = 0;
            if (n4 > 0) {
                System.arraycopy(this._data, n2, fArray, 0, n4);
                n2 = n - n4;
            } else {
                n2 = n;
                n4 = n3;
            }
            AudioCaptureBuffer audioCaptureBuffer4 = this;
            System.arraycopy(audioCaptureBuffer4._data, 0, fArray, n4, n2);
            audioCaptureBuffer4._read.set(n2);
            return n;
        }
        return 0;
    }

    private int peekBytes(float[] fArray, int n) {
        AudioCaptureBuffer audioCaptureBuffer = this;
        int n2 = audioCaptureBuffer._read.get();
        int n3 = audioCaptureBuffer._write.get();
        if (n3 >= n2) {
            if ((n3 -= n2) == 0) {
                return 0;
            }
            if (n > n3) {
                n = n3;
            }
            System.arraycopy(this._data, n2, fArray, 0, n);
            return n;
        }
        int n4 = this._watermark.get() - n2;
        if (n <= n4) {
            System.arraycopy(this._data, n2, fArray, 0, n);
            return n;
        }
        if (n <= n4 + n3) {
            n3 = 0;
            if (n4 > 0) {
                System.arraycopy(this._data, n2, fArray, 0, n4);
                n2 = n - n4;
            } else {
                n2 = n;
                n4 = n3;
            }
            System.arraycopy(this._data, 0, fArray, n4, n2);
            return n;
        }
        return 0;
    }

    private int advanceBy(int n) {
        AudioCaptureBuffer audioCaptureBuffer = this;
        int n2 = audioCaptureBuffer._read.get();
        int n3 = audioCaptureBuffer._write.get();
        if (n3 >= n2) {
            if ((n3 -= n2) == 0) {
                return 0;
            }
            if (n > n3) {
                n = n3;
            }
            this._read.set(n2 + n);
            return n;
        }
        n3 = this._watermark.get() - n2;
        if (n >= n3) {
            this._read.set(0);
            return n3 + this.advanceBy(n - n3);
        }
        this._read.set(n2 + n);
        return n;
    }

    public void reset() {
        AudioCaptureBuffer audioCaptureBuffer = this;
        audioCaptureBuffer._watermark.set(0);
        audioCaptureBuffer._write.set(0);
        audioCaptureBuffer._read.set(0);
    }

    public int GetSize() {
        return this._capacity;
    }

    public boolean IsEmpty() {
        return this._capacity - this.GetSpaceUsed() == 0;
    }

    public int GetContSpaceUsed() {
        AudioCaptureBuffer audioCaptureBuffer = this;
        int n = audioCaptureBuffer._read.get();
        int n2 = audioCaptureBuffer._write.get();
        if (n2 >= n) {
            return n2 - n;
        }
        return this._watermark.get() - n;
    }

    public int GetUnusedSize() {
        AudioCaptureBuffer audioCaptureBuffer = this;
        int n = audioCaptureBuffer._read.get();
        int n2 = audioCaptureBuffer._write.get();
        if (n2 > n) {
            int n3 = this._capacity - n2;
            if (n3 > n) {
                n = n3;
            }
            return n;
        }
        return n2 - n;
    }

    public int GetSpaceUsed() {
        AudioCaptureBuffer audioCaptureBuffer = this;
        int n = audioCaptureBuffer._read.get();
        int n2 = audioCaptureBuffer._write.get();
        if (n2 >= n) {
            return n2 - n;
        }
        return this._watermark.get() - n + n2;
    }

    public int OfferBytes(float[] fArray, int n, int n2) {
        return this.writeBytes(fArray, n, n2);
    }

    public int Peek(float[] fArray, int n) {
        return this.peekBytes(fArray, n);
    }

    public int Poll(float[] fArray, int n) {
        return this.getBytes(fArray, n);
    }

    public int writeBytes(float[] fArray, int n, int n2) {
        if (this.m_bDebug) {
            Log.i((String)"AVProVideo", (String)("_read = " + this._read + " | _write = " + this._write + " | _watermark = " + this._watermark + " | offset = " + n + " | length = " + n2));
            Log.i((String)"AVProVideo", (String)("_data.length = " + this._data.length));
        }
        AudioCaptureBuffer audioCaptureBuffer = this;
        int n3 = audioCaptureBuffer._read.get();
        int n4 = audioCaptureBuffer._write.get();
        if (n4 >= n3) {
            if (this._capacity - n4 >= n2) {
                System.arraycopy(fArray, n, this._data, n4, n2);
                this._write.addAndGet(n2);
                return n2;
            }
            if (n3 >= n2) {
                AudioCaptureBuffer audioCaptureBuffer2 = this;
                System.arraycopy(fArray, n, this._data, 0, n2);
                audioCaptureBuffer2._watermark.set(n4);
                audioCaptureBuffer2._write.set(n2);
                return n2;
            }
        } else if (n3 - n4 >= n2) {
            System.arraycopy(fArray, n, this._data, n4, n2);
            this._write.addAndGet(n2);
            return n2;
        }
        return 0;
    }
}

