/*
 * Decompiled with CFR 0.152.
 */
package com.twobigears.audio360;

import com.twobigears.audio360.Audio360JNI;
import java.nio.ByteBuffer;

public class AudioResampler {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected AudioResampler(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(AudioResampler obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                Audio360JNI.delete_AudioResampler(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public long process(ByteBuffer input, long totalInputSamples, ByteBuffer output, long totalOutputSamples, boolean endOfStream) {
        return Audio360JNI.AudioResampler_process(this.swigCPtr, this, input, totalInputSamples, output, totalOutputSamples, endOfStream);
    }

    public int getNumChannels() {
        return Audio360JNI.AudioResampler_getNumChannels(this.swigCPtr, this);
    }

    public float getInputSampleRate() {
        return Audio360JNI.AudioResampler_getInputSampleRate(this.swigCPtr, this);
    }

    public float getOutputSampleRate() {
        return Audio360JNI.AudioResampler_getOutputSampleRate(this.swigCPtr, this);
    }

    public Quality getQuality() {
        return Quality.swigToEnum(Audio360JNI.AudioResampler_getQuality(this.swigCPtr, this));
    }

    public void setRatio(double resamplingRatio) {
        Audio360JNI.AudioResampler_setRatio(this.swigCPtr, this, resamplingRatio);
    }

    public double getRatio() {
        return Audio360JNI.AudioResampler_getRatio(this.swigCPtr, this);
    }

    public void reset() {
        Audio360JNI.AudioResampler_reset(this.swigCPtr, this);
    }

    public static AudioResampler create(long numChannels, float inputSampleRate, float outputSampleRate, long maxBufferSize, Quality quality) {
        long cPtr = Audio360JNI.AudioResampler_create(numChannels, inputSampleRate, outputSampleRate, maxBufferSize, quality.swigValue());
        return cPtr == 0L ? null : new AudioResampler(cPtr, true);
    }

    public static enum Quality {
        OPTIMAL,
        FAST;

        private final int swigValue;

        public final int swigValue() {
            return this.swigValue;
        }

        public static Quality swigToEnum(int swigValue) {
            Quality[] swigValues = (Quality[])Quality.class.getEnumConstants();
            if (swigValue < swigValues.length && swigValue >= 0 && swigValues[swigValue].swigValue == swigValue) {
                return swigValues[swigValue];
            }
            for (Quality swigEnum : swigValues) {
                if (swigEnum.swigValue != swigValue) continue;
                return swigEnum;
            }
            throw new IllegalArgumentException("No enum " + Quality.class + " with value " + swigValue);
        }

        private Quality() {
            this.swigValue = SwigNext.next++;
        }

        private Quality(int swigValue) {
            this.swigValue = swigValue;
            SwigNext.next = swigValue + 1;
        }

        private Quality(Quality swigEnum) {
            this.swigValue = swigEnum.swigValue;
            SwigNext.next = this.swigValue + 1;
        }

        private static class SwigNext {
            private static int next = 0;

            private SwigNext() {
            }
        }
    }
}

