/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer.dash;

import android.util.Pair;
import android.util.SparseArray;
import android.util.SparseIntArray;
import androidx.annotation.Nullable;
import androidx.media3.common.Format;
import androidx.media3.common.StreamKey;
import androidx.media3.common.TrackGroup;
import androidx.media3.common.util.Util;
import androidx.media3.datasource.TransferListener;
import androidx.media3.exoplayer.SeekParameters;
import androidx.media3.exoplayer.analytics.PlayerId;
import androidx.media3.exoplayer.dash.BaseUrlExclusionList;
import androidx.media3.exoplayer.dash.DashChunkSource;
import androidx.media3.exoplayer.dash.EventSampleStream;
import androidx.media3.exoplayer.dash.PlayerEmsgHandler;
import androidx.media3.exoplayer.dash.manifest.AdaptationSet;
import androidx.media3.exoplayer.dash.manifest.DashManifest;
import androidx.media3.exoplayer.dash.manifest.Descriptor;
import androidx.media3.exoplayer.dash.manifest.EventStream;
import androidx.media3.exoplayer.dash.manifest.Period;
import androidx.media3.exoplayer.dash.manifest.Representation;
import androidx.media3.exoplayer.drm.DrmSessionEventListener;
import androidx.media3.exoplayer.drm.DrmSessionManager;
import androidx.media3.exoplayer.source.CompositeSequenceableLoaderFactory;
import androidx.media3.exoplayer.source.EmptySampleStream;
import androidx.media3.exoplayer.source.MediaPeriod;
import androidx.media3.exoplayer.source.MediaSourceEventListener;
import androidx.media3.exoplayer.source.SampleStream;
import androidx.media3.exoplayer.source.SequenceableLoader;
import androidx.media3.exoplayer.source.TrackGroupArray;
import androidx.media3.exoplayer.source.chunk.ChunkSampleStream;
import androidx.media3.exoplayer.source.chunk.ChunkSource;
import androidx.media3.exoplayer.trackselection.ExoTrackSelection;
import androidx.media3.exoplayer.upstream.Allocator;
import androidx.media3.exoplayer.upstream.CmcdConfiguration;
import androidx.media3.exoplayer.upstream.LoadErrorHandlingPolicy;
import androidx.media3.exoplayer.upstream.LoaderErrorThrower;
import com.google.common.primitives.Ints;
import java.io.IOException;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.compatqual.NullableType;

final class DashMediaPeriod
implements MediaPeriod,
SequenceableLoader.Callback<ChunkSampleStream<DashChunkSource>>,
ChunkSampleStream.ReleaseCallback<DashChunkSource> {
    private static final Pattern CEA608_SERVICE_DESCRIPTOR_REGEX = Pattern.compile("CC([1-4])=(.+)");
    private static final Pattern CEA708_SERVICE_DESCRIPTOR_REGEX = Pattern.compile("([1-4])=lang:(\\w+)(,.+)?");
    final int id;
    private final DashChunkSource.Factory chunkSourceFactory;
    @Nullable
    private final TransferListener transferListener;
    @Nullable
    private final CmcdConfiguration cmcdConfiguration;
    private final DrmSessionManager drmSessionManager;
    private final LoadErrorHandlingPolicy loadErrorHandlingPolicy;
    private final BaseUrlExclusionList baseUrlExclusionList;
    private final long elapsedRealtimeOffsetMs;
    private final LoaderErrorThrower manifestLoaderErrorThrower;
    private final Allocator allocator;
    private final TrackGroupArray trackGroups;
    private final TrackGroupInfo[] trackGroupInfos;
    private final CompositeSequenceableLoaderFactory compositeSequenceableLoaderFactory;
    private final PlayerEmsgHandler playerEmsgHandler;
    private final IdentityHashMap<ChunkSampleStream<DashChunkSource>, PlayerEmsgHandler.PlayerTrackEmsgHandler> trackEmsgHandlerBySampleStream;
    private final MediaSourceEventListener.EventDispatcher mediaSourceEventDispatcher;
    private final DrmSessionEventListener.EventDispatcher drmEventDispatcher;
    private final PlayerId playerId;
    @Nullable
    private MediaPeriod.Callback callback;
    private ChunkSampleStream<DashChunkSource>[] sampleStreams;
    private EventSampleStream[] eventSampleStreams;
    private SequenceableLoader compositeSequenceableLoader;
    private DashManifest manifest;
    private int periodIndex;
    private List<EventStream> eventStreams;

    public DashMediaPeriod(int id, DashManifest manifest, BaseUrlExclusionList baseUrlExclusionList, int periodIndex, DashChunkSource.Factory chunkSourceFactory, @Nullable TransferListener transferListener, @Nullable CmcdConfiguration cmcdConfiguration, DrmSessionManager drmSessionManager, DrmSessionEventListener.EventDispatcher drmEventDispatcher, LoadErrorHandlingPolicy loadErrorHandlingPolicy, MediaSourceEventListener.EventDispatcher mediaSourceEventDispatcher, long elapsedRealtimeOffsetMs, LoaderErrorThrower manifestLoaderErrorThrower, Allocator allocator, CompositeSequenceableLoaderFactory compositeSequenceableLoaderFactory, PlayerEmsgHandler.PlayerEmsgCallback playerEmsgCallback, PlayerId playerId) {
        this.id = id;
        this.manifest = manifest;
        this.baseUrlExclusionList = baseUrlExclusionList;
        this.periodIndex = periodIndex;
        this.chunkSourceFactory = chunkSourceFactory;
        this.transferListener = transferListener;
        this.cmcdConfiguration = cmcdConfiguration;
        this.drmSessionManager = drmSessionManager;
        this.drmEventDispatcher = drmEventDispatcher;
        this.loadErrorHandlingPolicy = loadErrorHandlingPolicy;
        this.mediaSourceEventDispatcher = mediaSourceEventDispatcher;
        this.elapsedRealtimeOffsetMs = elapsedRealtimeOffsetMs;
        this.manifestLoaderErrorThrower = manifestLoaderErrorThrower;
        this.allocator = allocator;
        this.compositeSequenceableLoaderFactory = compositeSequenceableLoaderFactory;
        this.playerId = playerId;
        this.playerEmsgHandler = new PlayerEmsgHandler(manifest, playerEmsgCallback, allocator);
        this.sampleStreams = DashMediaPeriod.newSampleStreamArray(0);
        this.eventSampleStreams = new EventSampleStream[0];
        this.trackEmsgHandlerBySampleStream = new IdentityHashMap();
        this.compositeSequenceableLoader = compositeSequenceableLoaderFactory.createCompositeSequenceableLoader(this.sampleStreams);
        Period period = manifest.getPeriod(periodIndex);
        this.eventStreams = period.eventStreams;
        Pair<TrackGroupArray, TrackGroupInfo[]> result = DashMediaPeriod.buildTrackGroups(drmSessionManager, period.adaptationSets, this.eventStreams);
        this.trackGroups = (TrackGroupArray)result.first;
        this.trackGroupInfos = (TrackGroupInfo[])result.second;
    }

    public void updateManifest(DashManifest manifest, int periodIndex) {
        this.manifest = manifest;
        this.periodIndex = periodIndex;
        this.playerEmsgHandler.updateManifest(manifest);
        if (this.sampleStreams != null) {
            for (ChunkSampleStream<DashChunkSource> chunkSampleStream : this.sampleStreams) {
                ((DashChunkSource)chunkSampleStream.getChunkSource()).updateManifest(manifest, periodIndex);
            }
            this.callback.onContinueLoadingRequested((SequenceableLoader)this);
        }
        this.eventStreams = manifest.getPeriod((int)periodIndex).eventStreams;
        block1: for (EventSampleStream eventSampleStream : this.eventSampleStreams) {
            for (EventStream eventStream : this.eventStreams) {
                if (!eventStream.id().equals(eventSampleStream.eventStreamId())) continue;
                int lastPeriodIndex = manifest.getPeriodCount() - 1;
                eventSampleStream.updateEventStream(eventStream, manifest.dynamic && periodIndex == lastPeriodIndex);
                continue block1;
            }
        }
    }

    public void release() {
        this.playerEmsgHandler.release();
        for (ChunkSampleStream<DashChunkSource> sampleStream : this.sampleStreams) {
            sampleStream.release((ChunkSampleStream.ReleaseCallback)this);
        }
        this.callback = null;
    }

    public synchronized void onSampleStreamReleased(ChunkSampleStream<DashChunkSource> stream) {
        PlayerEmsgHandler.PlayerTrackEmsgHandler trackEmsgHandler = this.trackEmsgHandlerBySampleStream.remove(stream);
        if (trackEmsgHandler != null) {
            trackEmsgHandler.release();
        }
    }

    public void prepare(MediaPeriod.Callback callback, long positionUs) {
        this.callback = callback;
        callback.onPrepared((MediaPeriod)this);
    }

    public void maybeThrowPrepareError() throws IOException {
        this.manifestLoaderErrorThrower.maybeThrowError();
    }

    public TrackGroupArray getTrackGroups() {
        return this.trackGroups;
    }

    public List<StreamKey> getStreamKeys(List<ExoTrackSelection> trackSelections) {
        List<AdaptationSet> manifestAdaptationSets = this.manifest.getPeriod((int)this.periodIndex).adaptationSets;
        ArrayList<StreamKey> streamKeys = new ArrayList<StreamKey>();
        for (ExoTrackSelection trackSelection : trackSelections) {
            int trackGroupIndex = this.trackGroups.indexOf(trackSelection.getTrackGroup());
            TrackGroupInfo trackGroupInfo = this.trackGroupInfos[trackGroupIndex];
            if (trackGroupInfo.trackGroupCategory != 0) continue;
            int[] adaptationSetIndices = trackGroupInfo.adaptationSetIndices;
            int[] trackIndices = new int[trackSelection.length()];
            for (int i = 0; i < trackSelection.length(); ++i) {
                trackIndices[i] = trackSelection.getIndexInTrackGroup(i);
            }
            Arrays.sort(trackIndices);
            int currentAdaptationSetIndex = 0;
            int totalTracksInPreviousAdaptationSets = 0;
            int tracksInCurrentAdaptationSet = manifestAdaptationSets.get((int)adaptationSetIndices[0]).representations.size();
            for (int trackIndex : trackIndices) {
                while (trackIndex >= totalTracksInPreviousAdaptationSets + tracksInCurrentAdaptationSet) {
                    totalTracksInPreviousAdaptationSets += tracksInCurrentAdaptationSet;
                    tracksInCurrentAdaptationSet = manifestAdaptationSets.get((int)adaptationSetIndices[++currentAdaptationSetIndex]).representations.size();
                }
                streamKeys.add(new StreamKey(this.periodIndex, adaptationSetIndices[currentAdaptationSetIndex], trackIndex - totalTracksInPreviousAdaptationSets));
            }
        }
        return streamKeys;
    }

    public long selectTracks(@NullableType ExoTrackSelection[] selections, boolean[] mayRetainStreamFlags, @NullableType SampleStream[] streams, boolean[] streamResetFlags, long positionUs) {
        int[] streamIndexToTrackGroupIndex = this.getStreamIndexToTrackGroupIndex(selections);
        this.releaseDisabledStreams(selections, mayRetainStreamFlags, streams);
        this.releaseOrphanEmbeddedStreams(selections, streams, streamIndexToTrackGroupIndex);
        this.selectNewStreams(selections, streams, streamResetFlags, positionUs, streamIndexToTrackGroupIndex);
        ArrayList<ChunkSampleStream> sampleStreamList = new ArrayList<ChunkSampleStream>();
        ArrayList<EventSampleStream> eventSampleStreamList = new ArrayList<EventSampleStream>();
        for (SampleStream sampleStream : streams) {
            if (sampleStream instanceof ChunkSampleStream) {
                ChunkSampleStream stream = (ChunkSampleStream)sampleStream;
                sampleStreamList.add(stream);
                continue;
            }
            if (!(sampleStream instanceof EventSampleStream)) continue;
            eventSampleStreamList.add((EventSampleStream)sampleStream);
        }
        this.sampleStreams = DashMediaPeriod.newSampleStreamArray(sampleStreamList.size());
        sampleStreamList.toArray(this.sampleStreams);
        this.eventSampleStreams = new EventSampleStream[eventSampleStreamList.size()];
        eventSampleStreamList.toArray(this.eventSampleStreams);
        this.compositeSequenceableLoader = this.compositeSequenceableLoaderFactory.createCompositeSequenceableLoader(this.sampleStreams);
        return positionUs;
    }

    public void discardBuffer(long positionUs, boolean toKeyframe) {
        for (ChunkSampleStream<DashChunkSource> sampleStream : this.sampleStreams) {
            sampleStream.discardBuffer(positionUs, toKeyframe);
        }
    }

    public void reevaluateBuffer(long positionUs) {
        this.compositeSequenceableLoader.reevaluateBuffer(positionUs);
    }

    public boolean continueLoading(long positionUs) {
        return this.compositeSequenceableLoader.continueLoading(positionUs);
    }

    public boolean isLoading() {
        return this.compositeSequenceableLoader.isLoading();
    }

    public long getNextLoadPositionUs() {
        return this.compositeSequenceableLoader.getNextLoadPositionUs();
    }

    public long readDiscontinuity() {
        return -9223372036854775807L;
    }

    public long getBufferedPositionUs() {
        return this.compositeSequenceableLoader.getBufferedPositionUs();
    }

    public long seekToUs(long positionUs) {
        for (ChunkSampleStream<DashChunkSource> chunkSampleStream : this.sampleStreams) {
            chunkSampleStream.seekToUs(positionUs);
        }
        for (EventSampleStream eventSampleStream : this.eventSampleStreams) {
            eventSampleStream.seekToUs(positionUs);
        }
        return positionUs;
    }

    public long getAdjustedSeekPositionUs(long positionUs, SeekParameters seekParameters) {
        for (ChunkSampleStream<DashChunkSource> sampleStream : this.sampleStreams) {
            if (sampleStream.primaryTrackType != 2) continue;
            return sampleStream.getAdjustedSeekPositionUs(positionUs, seekParameters);
        }
        return positionUs;
    }

    public void onContinueLoadingRequested(ChunkSampleStream<DashChunkSource> sampleStream) {
        this.callback.onContinueLoadingRequested((SequenceableLoader)this);
    }

    private int[] getStreamIndexToTrackGroupIndex(ExoTrackSelection[] selections) {
        int[] streamIndexToTrackGroupIndex = new int[selections.length];
        for (int i = 0; i < selections.length; ++i) {
            streamIndexToTrackGroupIndex[i] = selections[i] != null ? this.trackGroups.indexOf(selections[i].getTrackGroup()) : -1;
        }
        return streamIndexToTrackGroupIndex;
    }

    private void releaseDisabledStreams(ExoTrackSelection[] selections, boolean[] mayRetainStreamFlags, SampleStream[] streams) {
        for (int i = 0; i < selections.length; ++i) {
            if (selections[i] != null && mayRetainStreamFlags[i]) continue;
            if (streams[i] instanceof ChunkSampleStream) {
                ChunkSampleStream stream = (ChunkSampleStream)streams[i];
                stream.release((ChunkSampleStream.ReleaseCallback)this);
            } else if (streams[i] instanceof ChunkSampleStream.EmbeddedSampleStream) {
                ((ChunkSampleStream.EmbeddedSampleStream)streams[i]).release();
            }
            streams[i] = null;
        }
    }

    private void releaseOrphanEmbeddedStreams(ExoTrackSelection[] selections, SampleStream[] streams, int[] streamIndexToTrackGroupIndex) {
        for (int i = 0; i < selections.length; ++i) {
            boolean mayRetainStream;
            if (!(streams[i] instanceof EmptySampleStream) && !(streams[i] instanceof ChunkSampleStream.EmbeddedSampleStream)) continue;
            int primaryStreamIndex = this.getPrimaryStreamIndex(i, streamIndexToTrackGroupIndex);
            if (primaryStreamIndex == -1) {
                mayRetainStream = streams[i] instanceof EmptySampleStream;
            } else {
                boolean bl = mayRetainStream = streams[i] instanceof ChunkSampleStream.EmbeddedSampleStream && ((ChunkSampleStream.EmbeddedSampleStream)streams[i]).parent == streams[primaryStreamIndex];
            }
            if (mayRetainStream) continue;
            if (streams[i] instanceof ChunkSampleStream.EmbeddedSampleStream) {
                ((ChunkSampleStream.EmbeddedSampleStream)streams[i]).release();
            }
            streams[i] = null;
        }
    }

    private void selectNewStreams(ExoTrackSelection[] selections, SampleStream[] streams, boolean[] streamResetFlags, long positionUs, int[] streamIndexToTrackGroupIndex) {
        int i;
        for (i = 0; i < selections.length; ++i) {
            ExoTrackSelection selection = selections[i];
            if (selection == null) continue;
            if (streams[i] == null) {
                streamResetFlags[i] = true;
                int trackGroupIndex = streamIndexToTrackGroupIndex[i];
                TrackGroupInfo trackGroupInfo = this.trackGroupInfos[trackGroupIndex];
                if (trackGroupInfo.trackGroupCategory == 0) {
                    streams[i] = this.buildSampleStream(trackGroupInfo, selection, positionUs);
                    continue;
                }
                if (trackGroupInfo.trackGroupCategory != 2) continue;
                EventStream eventStream = this.eventStreams.get(trackGroupInfo.eventStreamGroupIndex);
                Format format = selection.getTrackGroup().getFormat(0);
                streams[i] = new EventSampleStream(eventStream, format, this.manifest.dynamic);
                continue;
            }
            if (!(streams[i] instanceof ChunkSampleStream)) continue;
            ChunkSampleStream stream = (ChunkSampleStream)streams[i];
            ((DashChunkSource)stream.getChunkSource()).updateTrackSelection(selection);
        }
        for (i = 0; i < selections.length; ++i) {
            if (streams[i] != null || selections[i] == null) continue;
            int trackGroupIndex = streamIndexToTrackGroupIndex[i];
            TrackGroupInfo trackGroupInfo = this.trackGroupInfos[trackGroupIndex];
            if (trackGroupInfo.trackGroupCategory != 1) continue;
            int primaryStreamIndex = this.getPrimaryStreamIndex(i, streamIndexToTrackGroupIndex);
            streams[i] = primaryStreamIndex == -1 ? new EmptySampleStream() : ((ChunkSampleStream)streams[primaryStreamIndex]).selectEmbeddedTrack(positionUs, trackGroupInfo.trackType);
        }
    }

    private int getPrimaryStreamIndex(int embeddedStreamIndex, int[] streamIndexToTrackGroupIndex) {
        int embeddedTrackGroupIndex = streamIndexToTrackGroupIndex[embeddedStreamIndex];
        if (embeddedTrackGroupIndex == -1) {
            return -1;
        }
        int primaryTrackGroupIndex = this.trackGroupInfos[embeddedTrackGroupIndex].primaryTrackGroupIndex;
        for (int i = 0; i < streamIndexToTrackGroupIndex.length; ++i) {
            int trackGroupIndex = streamIndexToTrackGroupIndex[i];
            if (trackGroupIndex != primaryTrackGroupIndex || this.trackGroupInfos[trackGroupIndex].trackGroupCategory != 0) continue;
            return i;
        }
        return -1;
    }

    private static Pair<TrackGroupArray, TrackGroupInfo[]> buildTrackGroups(DrmSessionManager drmSessionManager, List<AdaptationSet> adaptationSets, List<EventStream> eventStreams) {
        int[][] groupedAdaptationSetIndices = DashMediaPeriod.getGroupedAdaptationSetIndices(adaptationSets);
        int primaryGroupCount = groupedAdaptationSetIndices.length;
        boolean[] primaryGroupHasEventMessageTrackFlags = new boolean[primaryGroupCount];
        Format[][] primaryGroupClosedCaptionTrackFormats = new Format[primaryGroupCount][];
        int totalEmbeddedTrackGroupCount = DashMediaPeriod.identifyEmbeddedTracks(primaryGroupCount, adaptationSets, groupedAdaptationSetIndices, primaryGroupHasEventMessageTrackFlags, primaryGroupClosedCaptionTrackFormats);
        int totalGroupCount = primaryGroupCount + totalEmbeddedTrackGroupCount + eventStreams.size();
        TrackGroup[] trackGroups = new TrackGroup[totalGroupCount];
        TrackGroupInfo[] trackGroupInfos = new TrackGroupInfo[totalGroupCount];
        int trackGroupCount = DashMediaPeriod.buildPrimaryAndEmbeddedTrackGroupInfos(drmSessionManager, adaptationSets, groupedAdaptationSetIndices, primaryGroupCount, primaryGroupHasEventMessageTrackFlags, primaryGroupClosedCaptionTrackFormats, trackGroups, trackGroupInfos);
        DashMediaPeriod.buildManifestEventTrackGroupInfos(eventStreams, trackGroups, trackGroupInfos, trackGroupCount);
        return Pair.create((Object)new TrackGroupArray(trackGroups), (Object)trackGroupInfos);
    }

    private static int[][] getGroupedAdaptationSetIndices(List<AdaptationSet> adaptationSets) {
        int i;
        int adaptationSetCount = adaptationSets.size();
        SparseIntArray adaptationSetIdToIndex = new SparseIntArray(adaptationSetCount);
        ArrayList adaptationSetGroupedIndices = new ArrayList(adaptationSetCount);
        SparseArray adaptationSetIndexToGroupedIndices = new SparseArray(adaptationSetCount);
        for (i = 0; i < adaptationSetCount; ++i) {
            adaptationSetIdToIndex.put(adaptationSets.get((int)i).id, i);
            ArrayList<Integer> initialGroup = new ArrayList<Integer>();
            initialGroup.add(i);
            adaptationSetGroupedIndices.add(initialGroup);
            adaptationSetIndexToGroupedIndices.put(i, initialGroup);
        }
        for (i = 0; i < adaptationSetCount; ++i) {
            Descriptor adaptationSetSwitchingProperty;
            int mainAdaptationSetId;
            int mainAdaptationSetIndex;
            int mergedGroupIndex = i;
            AdaptationSet adaptationSet = adaptationSets.get(i);
            Descriptor trickPlayProperty = DashMediaPeriod.findTrickPlayProperty(adaptationSet.essentialProperties);
            if (trickPlayProperty == null) {
                trickPlayProperty = DashMediaPeriod.findTrickPlayProperty(adaptationSet.supplementalProperties);
            }
            if (trickPlayProperty != null && (mainAdaptationSetIndex = adaptationSetIdToIndex.get(mainAdaptationSetId = Integer.parseInt(trickPlayProperty.value), -1)) != -1) {
                mergedGroupIndex = mainAdaptationSetIndex;
            }
            if (mergedGroupIndex == i && (adaptationSetSwitchingProperty = DashMediaPeriod.findAdaptationSetSwitchingProperty(adaptationSet.supplementalProperties)) != null) {
                String[] otherAdaptationSetIds;
                for (String adaptationSetId : otherAdaptationSetIds = Util.split((String)adaptationSetSwitchingProperty.value, (String)",")) {
                    int otherAdaptationSetId = adaptationSetIdToIndex.get(Integer.parseInt(adaptationSetId), -1);
                    if (otherAdaptationSetId == -1) continue;
                    mergedGroupIndex = Math.min(mergedGroupIndex, otherAdaptationSetId);
                }
            }
            if (mergedGroupIndex == i) continue;
            List thisGroup = (List)adaptationSetIndexToGroupedIndices.get(i);
            List mergedGroup = (List)adaptationSetIndexToGroupedIndices.get(mergedGroupIndex);
            mergedGroup.addAll(thisGroup);
            adaptationSetIndexToGroupedIndices.put(i, (Object)mergedGroup);
            adaptationSetGroupedIndices.remove(thisGroup);
        }
        int[][] groupedAdaptationSetIndices = new int[adaptationSetGroupedIndices.size()][];
        for (int i2 = 0; i2 < groupedAdaptationSetIndices.length; ++i2) {
            groupedAdaptationSetIndices[i2] = Ints.toArray((Collection)((Collection)adaptationSetGroupedIndices.get(i2)));
            Arrays.sort(groupedAdaptationSetIndices[i2]);
        }
        return groupedAdaptationSetIndices;
    }

    private static int identifyEmbeddedTracks(int primaryGroupCount, List<AdaptationSet> adaptationSets, int[][] groupedAdaptationSetIndices, boolean[] primaryGroupHasEventMessageTrackFlags, Format[][] primaryGroupClosedCaptionTrackFormats) {
        int numEmbeddedTrackGroups = 0;
        for (int i = 0; i < primaryGroupCount; ++i) {
            if (DashMediaPeriod.hasEventMessageTrack(adaptationSets, groupedAdaptationSetIndices[i])) {
                primaryGroupHasEventMessageTrackFlags[i] = true;
                ++numEmbeddedTrackGroups;
            }
            primaryGroupClosedCaptionTrackFormats[i] = DashMediaPeriod.getClosedCaptionTrackFormats(adaptationSets, groupedAdaptationSetIndices[i]);
            if (primaryGroupClosedCaptionTrackFormats[i].length == 0) continue;
            ++numEmbeddedTrackGroups;
        }
        return numEmbeddedTrackGroups;
    }

    private static int buildPrimaryAndEmbeddedTrackGroupInfos(DrmSessionManager drmSessionManager, List<AdaptationSet> adaptationSets, int[][] groupedAdaptationSetIndices, int primaryGroupCount, boolean[] primaryGroupHasEventMessageTrackFlags, Format[][] primaryGroupClosedCaptionTrackFormats, TrackGroup[] trackGroups, TrackGroupInfo[] trackGroupInfos) {
        int trackGroupCount = 0;
        for (int i = 0; i < primaryGroupCount; ++i) {
            int[] adaptationSetIndices = groupedAdaptationSetIndices[i];
            ArrayList<Representation> representations = new ArrayList<Representation>();
            for (int adaptationSetIndex : adaptationSetIndices) {
                representations.addAll(adaptationSets.get((int)adaptationSetIndex).representations);
            }
            Format[] formats = new Format[representations.size()];
            for (int j = 0; j < formats.length; ++j) {
                Format format = ((Representation)representations.get((int)j)).format;
                formats[j] = format.copyWithCryptoType(drmSessionManager.getCryptoType(format));
            }
            AdaptationSet firstAdaptationSet = adaptationSets.get(adaptationSetIndices[0]);
            String trackGroupId = firstAdaptationSet.id != -1 ? Integer.toString(firstAdaptationSet.id) : "unset:" + i;
            int primaryTrackGroupIndex = trackGroupCount++;
            int eventMessageTrackGroupIndex = primaryGroupHasEventMessageTrackFlags[i] ? trackGroupCount++ : -1;
            int closedCaptionTrackGroupIndex = primaryGroupClosedCaptionTrackFormats[i].length != 0 ? trackGroupCount++ : -1;
            trackGroups[primaryTrackGroupIndex] = new TrackGroup(trackGroupId, formats);
            trackGroupInfos[primaryTrackGroupIndex] = TrackGroupInfo.primaryTrack(firstAdaptationSet.type, adaptationSetIndices, primaryTrackGroupIndex, eventMessageTrackGroupIndex, closedCaptionTrackGroupIndex);
            if (eventMessageTrackGroupIndex != -1) {
                String eventMessageTrackGroupId = trackGroupId + ":emsg";
                Format format = new Format.Builder().setId(eventMessageTrackGroupId).setSampleMimeType("application/x-emsg").build();
                trackGroups[eventMessageTrackGroupIndex] = new TrackGroup(eventMessageTrackGroupId, new Format[]{format});
                trackGroupInfos[eventMessageTrackGroupIndex] = TrackGroupInfo.embeddedEmsgTrack(adaptationSetIndices, primaryTrackGroupIndex);
            }
            if (closedCaptionTrackGroupIndex == -1) continue;
            String closedCaptionTrackGroupId = trackGroupId + ":cc";
            trackGroups[closedCaptionTrackGroupIndex] = new TrackGroup(closedCaptionTrackGroupId, primaryGroupClosedCaptionTrackFormats[i]);
            trackGroupInfos[closedCaptionTrackGroupIndex] = TrackGroupInfo.embeddedClosedCaptionTrack(adaptationSetIndices, primaryTrackGroupIndex);
        }
        return trackGroupCount;
    }

    private static void buildManifestEventTrackGroupInfos(List<EventStream> eventStreams, TrackGroup[] trackGroups, TrackGroupInfo[] trackGroupInfos, int existingTrackGroupCount) {
        for (int i = 0; i < eventStreams.size(); ++i) {
            EventStream eventStream = eventStreams.get(i);
            Format format = new Format.Builder().setId(eventStream.id()).setSampleMimeType("application/x-emsg").build();
            String uniqueTrackGroupId = eventStream.id() + ":" + i;
            trackGroups[existingTrackGroupCount] = new TrackGroup(uniqueTrackGroupId, new Format[]{format});
            trackGroupInfos[existingTrackGroupCount++] = TrackGroupInfo.mpdEventTrack(i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChunkSampleStream<DashChunkSource> buildSampleStream(TrackGroupInfo trackGroupInfo, ExoTrackSelection selection, long positionUs) {
        int embeddedTrackCount = 0;
        boolean enableEventMessageTrack = trackGroupInfo.embeddedEventMessageTrackGroupIndex != -1;
        TrackGroup embeddedEventMessageTrackGroup = null;
        if (enableEventMessageTrack) {
            embeddedEventMessageTrackGroup = this.trackGroups.get(trackGroupInfo.embeddedEventMessageTrackGroupIndex);
            ++embeddedTrackCount;
        }
        boolean enableClosedCaptionTrack = trackGroupInfo.embeddedClosedCaptionTrackGroupIndex != -1;
        TrackGroup embeddedClosedCaptionTrackGroup = null;
        if (enableClosedCaptionTrack) {
            embeddedClosedCaptionTrackGroup = this.trackGroups.get(trackGroupInfo.embeddedClosedCaptionTrackGroupIndex);
            embeddedTrackCount += embeddedClosedCaptionTrackGroup.length;
        }
        Format[] embeddedTrackFormats = new Format[embeddedTrackCount];
        int[] embeddedTrackTypes = new int[embeddedTrackCount];
        embeddedTrackCount = 0;
        if (enableEventMessageTrack) {
            embeddedTrackFormats[embeddedTrackCount] = embeddedEventMessageTrackGroup.getFormat(0);
            embeddedTrackTypes[embeddedTrackCount] = 5;
            ++embeddedTrackCount;
        }
        ArrayList<Format> embeddedClosedCaptionTrackFormats = new ArrayList<Format>();
        if (enableClosedCaptionTrack) {
            for (int i = 0; i < embeddedClosedCaptionTrackGroup.length; ++i) {
                embeddedTrackFormats[embeddedTrackCount] = embeddedClosedCaptionTrackGroup.getFormat(i);
                embeddedTrackTypes[embeddedTrackCount] = 3;
                embeddedClosedCaptionTrackFormats.add(embeddedTrackFormats[embeddedTrackCount]);
                ++embeddedTrackCount;
            }
        }
        PlayerEmsgHandler.PlayerTrackEmsgHandler trackPlayerEmsgHandler = this.manifest.dynamic && enableEventMessageTrack ? this.playerEmsgHandler.newPlayerTrackEmsgHandler() : null;
        DashChunkSource chunkSource = this.chunkSourceFactory.createDashChunkSource(this.manifestLoaderErrorThrower, this.manifest, this.baseUrlExclusionList, this.periodIndex, trackGroupInfo.adaptationSetIndices, selection, trackGroupInfo.trackType, this.elapsedRealtimeOffsetMs, enableEventMessageTrack, embeddedClosedCaptionTrackFormats, trackPlayerEmsgHandler, this.transferListener, this.playerId, this.cmcdConfiguration);
        ChunkSampleStream stream = new ChunkSampleStream(trackGroupInfo.trackType, embeddedTrackTypes, embeddedTrackFormats, (ChunkSource)chunkSource, (SequenceableLoader.Callback)this, this.allocator, positionUs, this.drmSessionManager, this.drmEventDispatcher, this.loadErrorHandlingPolicy, this.mediaSourceEventDispatcher);
        DashMediaPeriod dashMediaPeriod = this;
        synchronized (dashMediaPeriod) {
            this.trackEmsgHandlerBySampleStream.put((ChunkSampleStream<DashChunkSource>)stream, trackPlayerEmsgHandler);
        }
        return stream;
    }

    @Nullable
    private static Descriptor findAdaptationSetSwitchingProperty(List<Descriptor> descriptors) {
        return DashMediaPeriod.findDescriptor(descriptors, "urn:mpeg:dash:adaptation-set-switching:2016");
    }

    @Nullable
    private static Descriptor findTrickPlayProperty(List<Descriptor> descriptors) {
        return DashMediaPeriod.findDescriptor(descriptors, "http://dashif.org/guidelines/trickmode");
    }

    @Nullable
    private static Descriptor findDescriptor(List<Descriptor> descriptors, String schemeIdUri) {
        for (int i = 0; i < descriptors.size(); ++i) {
            Descriptor descriptor = descriptors.get(i);
            if (!schemeIdUri.equals(descriptor.schemeIdUri)) continue;
            return descriptor;
        }
        return null;
    }

    private static boolean hasEventMessageTrack(List<AdaptationSet> adaptationSets, int[] adaptationSetIndices) {
        for (int i : adaptationSetIndices) {
            List<Representation> representations = adaptationSets.get((int)i).representations;
            for (int j = 0; j < representations.size(); ++j) {
                Representation representation = representations.get(j);
                if (representation.inbandEventStreams.isEmpty()) continue;
                return true;
            }
        }
        return false;
    }

    private static Format[] getClosedCaptionTrackFormats(List<AdaptationSet> adaptationSets, int[] adaptationSetIndices) {
        for (int i : adaptationSetIndices) {
            AdaptationSet adaptationSet = adaptationSets.get(i);
            List<Descriptor> descriptors = adaptationSets.get((int)i).accessibilityDescriptors;
            for (int j = 0; j < descriptors.size(); ++j) {
                Descriptor descriptor = descriptors.get(j);
                if ("urn:scte:dash:cc:cea-608:2015".equals(descriptor.schemeIdUri)) {
                    Format cea608Format = new Format.Builder().setSampleMimeType("application/cea-608").setId(adaptationSet.id + ":cea608").build();
                    return DashMediaPeriod.parseClosedCaptionDescriptor(descriptor, CEA608_SERVICE_DESCRIPTOR_REGEX, cea608Format);
                }
                if (!"urn:scte:dash:cc:cea-708:2015".equals(descriptor.schemeIdUri)) continue;
                Format cea708Format = new Format.Builder().setSampleMimeType("application/cea-708").setId(adaptationSet.id + ":cea708").build();
                return DashMediaPeriod.parseClosedCaptionDescriptor(descriptor, CEA708_SERVICE_DESCRIPTOR_REGEX, cea708Format);
            }
        }
        return new Format[0];
    }

    private static Format[] parseClosedCaptionDescriptor(Descriptor descriptor, Pattern serviceDescriptorRegex, Format baseFormat) {
        String value = descriptor.value;
        if (value == null) {
            return new Format[]{baseFormat};
        }
        String[] services = Util.split((String)value, (String)";");
        Format[] formats = new Format[services.length];
        for (int i = 0; i < services.length; ++i) {
            Matcher matcher = serviceDescriptorRegex.matcher(services[i]);
            if (!matcher.matches()) {
                return new Format[]{baseFormat};
            }
            int accessibilityChannel = Integer.parseInt(matcher.group(1));
            formats[i] = baseFormat.buildUpon().setId(baseFormat.id + ":" + accessibilityChannel).setAccessibilityChannel(accessibilityChannel).setLanguage(matcher.group(2)).build();
        }
        return formats;
    }

    private static ChunkSampleStream<DashChunkSource>[] newSampleStreamArray(int length) {
        return new ChunkSampleStream[length];
    }

    private static final class TrackGroupInfo {
        private static final int CATEGORY_PRIMARY = 0;
        private static final int CATEGORY_EMBEDDED = 1;
        private static final int CATEGORY_MANIFEST_EVENTS = 2;
        public final int[] adaptationSetIndices;
        public final int trackType;
        public final int trackGroupCategory;
        public final int eventStreamGroupIndex;
        public final int primaryTrackGroupIndex;
        public final int embeddedEventMessageTrackGroupIndex;
        public final int embeddedClosedCaptionTrackGroupIndex;

        public static TrackGroupInfo primaryTrack(int trackType, int[] adaptationSetIndices, int primaryTrackGroupIndex, int embeddedEventMessageTrackGroupIndex, int embeddedClosedCaptionTrackGroupIndex) {
            return new TrackGroupInfo(trackType, 0, adaptationSetIndices, primaryTrackGroupIndex, embeddedEventMessageTrackGroupIndex, embeddedClosedCaptionTrackGroupIndex, -1);
        }

        public static TrackGroupInfo embeddedEmsgTrack(int[] adaptationSetIndices, int primaryTrackGroupIndex) {
            return new TrackGroupInfo(5, 1, adaptationSetIndices, primaryTrackGroupIndex, -1, -1, -1);
        }

        public static TrackGroupInfo embeddedClosedCaptionTrack(int[] adaptationSetIndices, int primaryTrackGroupIndex) {
            return new TrackGroupInfo(3, 1, adaptationSetIndices, primaryTrackGroupIndex, -1, -1, -1);
        }

        public static TrackGroupInfo mpdEventTrack(int eventStreamIndex) {
            return new TrackGroupInfo(5, 2, new int[0], -1, -1, -1, eventStreamIndex);
        }

        private TrackGroupInfo(int trackType, int trackGroupCategory, int[] adaptationSetIndices, int primaryTrackGroupIndex, int embeddedEventMessageTrackGroupIndex, int embeddedClosedCaptionTrackGroupIndex, int eventStreamGroupIndex) {
            this.trackType = trackType;
            this.adaptationSetIndices = adaptationSetIndices;
            this.trackGroupCategory = trackGroupCategory;
            this.primaryTrackGroupIndex = primaryTrackGroupIndex;
            this.embeddedEventMessageTrackGroupIndex = embeddedEventMessageTrackGroupIndex;
            this.embeddedClosedCaptionTrackGroupIndex = embeddedClosedCaptionTrackGroupIndex;
            this.eventStreamGroupIndex = eventStreamGroupIndex;
        }

        @Documented
        @Retention(value=RetentionPolicy.SOURCE)
        @Target(value={ElementType.TYPE_USE})
        public static @interface TrackGroupCategory {
        }
    }
}

