/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer.rtsp.reader;

import androidx.media3.common.Format;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.Log;
import androidx.media3.common.util.ParsableByteArray;
import androidx.media3.common.util.Util;
import androidx.media3.exoplayer.rtsp.RtpPacket;
import androidx.media3.exoplayer.rtsp.RtpPayloadFormat;
import androidx.media3.exoplayer.rtsp.reader.RtpPayloadReader;
import androidx.media3.exoplayer.rtsp.reader.RtpReaderUtils;
import androidx.media3.extractor.ExtractorOutput;
import androidx.media3.extractor.OpusUtil;
import androidx.media3.extractor.TrackOutput;
import java.util.List;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

final class RtpOpusReader
implements RtpPayloadReader {
    private static final String TAG = "RtpOpusReader";
    private static final int MEDIA_CLOCK_FREQUENCY = 48000;
    private final RtpPayloadFormat payloadFormat;
    private @MonotonicNonNull TrackOutput trackOutput;
    private long firstReceivedTimestamp;
    private long startTimeOffsetUs;
    private int previousSequenceNumber;
    private boolean foundOpusIDHeader;
    private boolean foundOpusCommentHeader;

    public RtpOpusReader(RtpPayloadFormat payloadFormat) {
        this.payloadFormat = payloadFormat;
        this.firstReceivedTimestamp = -1L;
        this.previousSequenceNumber = -1;
    }

    @Override
    public void createTracks(ExtractorOutput extractorOutput, int trackId) {
        this.trackOutput = extractorOutput.track(trackId, 1);
        this.trackOutput.format(this.payloadFormat.format);
    }

    @Override
    public void onReceivingFirstPacket(long timestamp, int sequenceNumber) {
        this.firstReceivedTimestamp = timestamp;
    }

    @Override
    public void consume(ParsableByteArray data, long timestamp, int sequenceNumber, boolean rtpMarker) {
        Assertions.checkStateNotNull((Object)this.trackOutput);
        if (!this.foundOpusIDHeader) {
            RtpOpusReader.validateOpusIdHeader(data);
            List initializationData = OpusUtil.buildInitializationData((byte[])data.getData());
            Format.Builder formatBuilder = this.payloadFormat.format.buildUpon();
            formatBuilder.setInitializationData(initializationData);
            this.trackOutput.format(formatBuilder.build());
            this.foundOpusIDHeader = true;
        } else if (!this.foundOpusCommentHeader) {
            int sampleSize = data.limit();
            Assertions.checkArgument((sampleSize >= 8 ? 1 : 0) != 0, (Object)"Comment Header has insufficient data");
            String header = data.readString(8);
            Assertions.checkArgument((boolean)header.equals("OpusTags"), (Object)"Comment Header should follow ID Header");
            this.foundOpusCommentHeader = true;
        } else {
            int expectedSequenceNumber = RtpPacket.getNextSequenceNumber(this.previousSequenceNumber);
            if (sequenceNumber != expectedSequenceNumber) {
                Log.w((String)TAG, (String)Util.formatInvariant((String)"Received RTP packet with unexpected sequence number. Expected: %d; received: %d.", (Object[])new Object[]{expectedSequenceNumber, sequenceNumber}));
            }
            int size = data.bytesLeft();
            this.trackOutput.sampleData(data, size);
            long timeUs = RtpReaderUtils.toSampleTimeUs(this.startTimeOffsetUs, timestamp, this.firstReceivedTimestamp, 48000);
            this.trackOutput.sampleMetadata(timeUs, 1, size, 0, null);
        }
        this.previousSequenceNumber = sequenceNumber;
    }

    @Override
    public void seek(long nextRtpTimestamp, long timeUs) {
        this.firstReceivedTimestamp = nextRtpTimestamp;
        this.startTimeOffsetUs = timeUs;
    }

    private static void validateOpusIdHeader(ParsableByteArray data) {
        int currPosition = data.getPosition();
        int sampleSize = data.limit();
        Assertions.checkArgument((sampleSize > 18 ? 1 : 0) != 0, (Object)"ID Header has insufficient data");
        String header = data.readString(8);
        Assertions.checkArgument((boolean)header.equals("OpusHead"), (Object)"ID Header missing");
        Assertions.checkArgument((data.readUnsignedByte() == 1 ? 1 : 0) != 0, (Object)"version number must always be 1");
        data.setPosition(currPosition);
    }
}

