/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer;

import androidx.media3.common.PlaybackParameters;
import androidx.media3.common.util.Clock;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import androidx.media3.exoplayer.MediaClock;

@UnstableApi
public final class StandaloneMediaClock
implements MediaClock {
    private final Clock clock;
    private boolean started;
    private long baseUs;
    private long baseElapsedMs;
    private PlaybackParameters playbackParameters;

    public StandaloneMediaClock(Clock clock) {
        this.clock = clock;
        this.playbackParameters = PlaybackParameters.DEFAULT;
    }

    public void start() {
        if (!this.started) {
            this.baseElapsedMs = this.clock.elapsedRealtime();
            this.started = true;
        }
    }

    public void stop() {
        if (this.started) {
            this.resetPosition(this.getPositionUs());
            this.started = false;
        }
    }

    public void resetPosition(long positionUs) {
        this.baseUs = positionUs;
        if (this.started) {
            this.baseElapsedMs = this.clock.elapsedRealtime();
        }
    }

    @Override
    public long getPositionUs() {
        long positionUs = this.baseUs;
        if (this.started) {
            long elapsedSinceBaseMs = this.clock.elapsedRealtime() - this.baseElapsedMs;
            positionUs = this.playbackParameters.speed == 1.0f ? (positionUs += Util.msToUs((long)elapsedSinceBaseMs)) : (positionUs += this.playbackParameters.getMediaTimeUsForPlayoutTimeMs(elapsedSinceBaseMs));
        }
        return positionUs;
    }

    @Override
    public void setPlaybackParameters(PlaybackParameters playbackParameters) {
        if (this.started) {
            this.resetPosition(this.getPositionUs());
        }
        this.playbackParameters = playbackParameters;
    }

    @Override
    public PlaybackParameters getPlaybackParameters() {
        return this.playbackParameters;
    }
}

