/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer.mediacodec;

import androidx.media3.common.MimeTypes;
import androidx.media3.common.util.Log;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import androidx.media3.exoplayer.mediacodec.AsynchronousMediaCodecAdapter;
import androidx.media3.exoplayer.mediacodec.MediaCodecAdapter;
import androidx.media3.exoplayer.mediacodec.SynchronousMediaCodecAdapter;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.IOException;

@UnstableApi
public final class DefaultMediaCodecAdapterFactory
implements MediaCodecAdapter.Factory {
    private static final int MODE_DEFAULT = 0;
    private static final int MODE_ENABLED = 1;
    private static final int MODE_DISABLED = 2;
    private static final String TAG = "DMCodecAdapterFactory";
    private int asynchronousMode = 0;
    private boolean enableSynchronizeCodecInteractionsWithQueueing;

    @CanIgnoreReturnValue
    public DefaultMediaCodecAdapterFactory forceEnableAsynchronous() {
        this.asynchronousMode = 1;
        return this;
    }

    @CanIgnoreReturnValue
    public DefaultMediaCodecAdapterFactory forceDisableAsynchronous() {
        this.asynchronousMode = 2;
        return this;
    }

    public void experimentalSetSynchronizeCodecInteractionsWithQueueingEnabled(boolean enabled) {
        this.enableSynchronizeCodecInteractionsWithQueueing = enabled;
    }

    @Override
    public MediaCodecAdapter createAdapter(MediaCodecAdapter.Configuration configuration) throws IOException {
        if (Util.SDK_INT >= 23 && (this.asynchronousMode == 1 || this.asynchronousMode == 0 && Util.SDK_INT >= 31)) {
            int trackType = MimeTypes.getTrackType((String)configuration.format.sampleMimeType);
            Log.i((String)TAG, (String)("Creating an asynchronous MediaCodec adapter for track type " + Util.getTrackTypeString((int)trackType)));
            AsynchronousMediaCodecAdapter.Factory factory = new AsynchronousMediaCodecAdapter.Factory(trackType, this.enableSynchronizeCodecInteractionsWithQueueing);
            return factory.createAdapter(configuration);
        }
        return new SynchronousMediaCodecAdapter.Factory().createAdapter(configuration);
    }
}

