/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer.source.ads;

import androidx.annotation.VisibleForTesting;
import androidx.media3.common.AdPlaybackState;
import androidx.media3.common.Timeline;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.exoplayer.source.ForwardingTimeline;

@VisibleForTesting(otherwise=3)
@UnstableApi
public final class SinglePeriodAdTimeline
extends ForwardingTimeline {
    private final AdPlaybackState adPlaybackState;

    public SinglePeriodAdTimeline(Timeline contentTimeline, AdPlaybackState adPlaybackState) {
        super(contentTimeline);
        Assertions.checkState((contentTimeline.getPeriodCount() == 1 ? 1 : 0) != 0);
        Assertions.checkState((contentTimeline.getWindowCount() == 1 ? 1 : 0) != 0);
        this.adPlaybackState = adPlaybackState;
    }

    @Override
    public Timeline.Period getPeriod(int periodIndex, Timeline.Period period, boolean setIds) {
        this.timeline.getPeriod(periodIndex, period, setIds);
        long durationUs = period.durationUs == -9223372036854775807L ? this.adPlaybackState.contentDurationUs : period.durationUs;
        period.set(period.id, period.uid, period.windowIndex, durationUs, period.getPositionInWindowUs(), this.adPlaybackState, period.isPlaceholder);
        return period;
    }
}

