/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer.source.mediaparser;

import android.annotation.SuppressLint;
import android.media.MediaParser;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.media3.common.DataReader;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import java.io.IOException;

@RequiresApi(value=30)
@SuppressLint(value={"Override"})
@UnstableApi
public final class InputReaderAdapterV30
implements MediaParser.SeekableInputReader {
    @Nullable
    private DataReader dataReader;
    private long resourceLength;
    private long currentPosition;
    private long lastSeekPosition;

    public void setDataReader(DataReader dataReader, long length) {
        this.dataReader = dataReader;
        this.resourceLength = length;
        this.lastSeekPosition = -1L;
    }

    public void setCurrentPosition(long position) {
        this.currentPosition = position;
    }

    public long getAndResetSeekPosition() {
        long lastSeekPosition = this.lastSeekPosition;
        this.lastSeekPosition = -1L;
        return lastSeekPosition;
    }

    public void seekToPosition(long position) {
        this.lastSeekPosition = position;
    }

    public int read(byte[] bytes, int offset, int readLength) throws IOException {
        int bytesRead = ((DataReader)Util.castNonNull((Object)this.dataReader)).read(bytes, offset, readLength);
        this.currentPosition += (long)bytesRead;
        return bytesRead;
    }

    public long getPosition() {
        return this.currentPosition;
    }

    public long getLength() {
        return this.resourceLength;
    }
}

