/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.extractor.ogg;

import androidx.media3.common.Format;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.ParsableByteArray;
import androidx.media3.common.util.Util;
import androidx.media3.extractor.ExtractorInput;
import androidx.media3.extractor.ExtractorOutput;
import androidx.media3.extractor.PositionHolder;
import androidx.media3.extractor.SeekMap;
import androidx.media3.extractor.TrackOutput;
import androidx.media3.extractor.ogg.DefaultOggSeeker;
import androidx.media3.extractor.ogg.OggPacket;
import androidx.media3.extractor.ogg.OggPageHeader;
import androidx.media3.extractor.ogg.OggSeeker;
import java.io.IOException;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;

abstract class StreamReader {
    private static final int STATE_READ_HEADERS = 0;
    private static final int STATE_SKIP_HEADERS = 1;
    private static final int STATE_READ_PAYLOAD = 2;
    private static final int STATE_END_OF_INPUT = 3;
    private final OggPacket oggPacket = new OggPacket();
    private @MonotonicNonNull TrackOutput trackOutput;
    private @MonotonicNonNull ExtractorOutput extractorOutput;
    private @MonotonicNonNull OggSeeker oggSeeker;
    private long targetGranule;
    private long payloadStartPosition;
    private long currentGranule;
    private int state;
    private int sampleRate;
    private SetupData setupData = new SetupData();
    private long lengthOfReadPacket;
    private boolean seekMapSet;
    private boolean formatSet;

    void init(ExtractorOutput output, TrackOutput trackOutput) {
        this.extractorOutput = output;
        this.trackOutput = trackOutput;
        this.reset(true);
    }

    protected void reset(boolean headerData) {
        if (headerData) {
            this.setupData = new SetupData();
            this.payloadStartPosition = 0L;
            this.state = 0;
        } else {
            this.state = 1;
        }
        this.targetGranule = -1L;
        this.currentGranule = 0L;
    }

    final void seek(long position, long timeUs) {
        this.oggPacket.reset();
        if (position == 0L) {
            this.reset(!this.seekMapSet);
        } else if (this.state != 0) {
            this.targetGranule = this.convertTimeToGranule(timeUs);
            ((OggSeeker)Util.castNonNull((Object)this.oggSeeker)).startSeek(this.targetGranule);
            this.state = 2;
        }
    }

    final int read(ExtractorInput input, PositionHolder seekPosition) throws IOException {
        this.assertInitialized();
        switch (this.state) {
            case 0: {
                return this.readHeadersAndUpdateState(input);
            }
            case 1: {
                input.skipFully((int)this.payloadStartPosition);
                this.state = 2;
                return 0;
            }
            case 2: {
                Util.castNonNull((Object)this.oggSeeker);
                return this.readPayload(input, seekPosition);
            }
            case 3: {
                return -1;
            }
        }
        throw new IllegalStateException();
    }

    @EnsuresNonNull(value={"trackOutput", "extractorOutput"})
    private void assertInitialized() {
        Assertions.checkStateNotNull((Object)this.trackOutput);
        Util.castNonNull((Object)this.extractorOutput);
    }

    @EnsuresNonNullIf(expression={"setupData.format"}, result=true)
    private boolean readHeaders(ExtractorInput input) throws IOException {
        while (true) {
            if (!this.oggPacket.populate(input)) {
                this.state = 3;
                return false;
            }
            this.lengthOfReadPacket = input.getPosition() - this.payloadStartPosition;
            if (!this.readHeaders(this.oggPacket.getPayload(), this.payloadStartPosition, this.setupData)) break;
            this.payloadStartPosition = input.getPosition();
        }
        return true;
    }

    @RequiresNonNull(value={"trackOutput"})
    private int readHeadersAndUpdateState(ExtractorInput input) throws IOException {
        if (!this.readHeaders(input)) {
            return -1;
        }
        this.sampleRate = this.setupData.format.sampleRate;
        if (!this.formatSet) {
            this.trackOutput.format(this.setupData.format);
            this.formatSet = true;
        }
        if (this.setupData.oggSeeker != null) {
            this.oggSeeker = this.setupData.oggSeeker;
        } else if (input.getLength() == -1L) {
            this.oggSeeker = new UnseekableOggSeeker();
        } else {
            OggPageHeader firstPayloadPageHeader = this.oggPacket.getPageHeader();
            boolean isLastPage = (firstPayloadPageHeader.type & 4) != 0;
            this.oggSeeker = new DefaultOggSeeker(this, this.payloadStartPosition, input.getLength(), firstPayloadPageHeader.headerSize + firstPayloadPageHeader.bodySize, firstPayloadPageHeader.granulePosition, isLastPage);
        }
        this.state = 2;
        this.oggPacket.trimPayload();
        return 0;
    }

    @RequiresNonNull(value={"trackOutput", "oggSeeker", "extractorOutput"})
    private int readPayload(ExtractorInput input, PositionHolder seekPosition) throws IOException {
        long position = this.oggSeeker.read(input);
        if (position >= 0L) {
            seekPosition.position = position;
            return 1;
        }
        if (position < -1L) {
            this.onSeekEnd(-(position + 2L));
        }
        if (!this.seekMapSet) {
            SeekMap seekMap = (SeekMap)Assertions.checkStateNotNull((Object)this.oggSeeker.createSeekMap());
            this.extractorOutput.seekMap(seekMap);
            this.seekMapSet = true;
        }
        if (this.lengthOfReadPacket > 0L || this.oggPacket.populate(input)) {
            this.lengthOfReadPacket = 0L;
            ParsableByteArray payload = this.oggPacket.getPayload();
            long granulesInPacket = this.preparePayload(payload);
            if (granulesInPacket >= 0L && this.currentGranule + granulesInPacket >= this.targetGranule) {
                long timeUs = this.convertGranuleToTime(this.currentGranule);
                this.trackOutput.sampleData(payload, payload.limit());
                this.trackOutput.sampleMetadata(timeUs, 1, payload.limit(), 0, null);
                this.targetGranule = -1L;
            }
            this.currentGranule += granulesInPacket;
        } else {
            this.state = 3;
            return -1;
        }
        return 0;
    }

    protected long convertGranuleToTime(long granule) {
        return granule * 1000000L / (long)this.sampleRate;
    }

    protected long convertTimeToGranule(long timeUs) {
        return (long)this.sampleRate * timeUs / 1000000L;
    }

    protected abstract long preparePayload(ParsableByteArray var1);

    @EnsuresNonNullIf(expression={"#3.format"}, result=false)
    protected abstract boolean readHeaders(ParsableByteArray var1, long var2, SetupData var4) throws IOException;

    protected void onSeekEnd(long currentGranule) {
        this.currentGranule = currentGranule;
    }

    private static final class UnseekableOggSeeker
    implements OggSeeker {
        private UnseekableOggSeeker() {
        }

        @Override
        public long read(ExtractorInput input) {
            return -1L;
        }

        @Override
        public void startSeek(long targetGranule) {
        }

        @Override
        public SeekMap createSeekMap() {
            return new SeekMap.Unseekable(-9223372036854775807L);
        }
    }

    static class SetupData {
        @MonotonicNonNull Format format;
        @MonotonicNonNull OggSeeker oggSeeker;

        SetupData() {
        }
    }
}

