/*
 * Decompiled with CFR 0.152.
 */
package io.antmedia.rtmp_client;

import java.io.IOException;

public class RtmpClient {
    public static final int RTMP_READ_DONE = -1;
    private static final int RTMP_SUCCESS = 0;
    private static final int TIMEOUT_IN_MS = 10000;
    private long rtmpPointer = 0L;
    private int sendTimeoutInMs = 10000;
    private int receiveTimeoutInMs = 10000;

    public void setSendTimeout(int sendTimeoutInMs) {
        this.sendTimeoutInMs = sendTimeoutInMs > 0 ? sendTimeoutInMs : 10000;
    }

    public void setReceiveTimeout(int receiveTimeoutInMs) {
        this.receiveTimeoutInMs = receiveTimeoutInMs > 0 ? receiveTimeoutInMs : 10000;
    }

    public void open(String url, boolean isPublishMode) throws RtmpIOException {
        this.rtmpPointer = this.nativeAlloc();
        if (this.rtmpPointer == 0L) {
            throw new RtmpIOException(-2);
        }
        int result = this.nativeOpen(url, isPublishMode, this.rtmpPointer, this.sendTimeoutInMs, this.receiveTimeoutInMs);
        if (result != 0) {
            this.rtmpPointer = 0L;
            throw new RtmpIOException(result);
        }
    }

    private native long nativeAlloc();

    private native int nativeOpen(String var1, boolean var2, long var3, int var5, int var6);

    public int read(byte[] data, int offset, int size) throws RtmpIOException, IllegalStateException {
        int ret = this.nativeRead(data, offset, size, this.rtmpPointer);
        if (ret < 0 && ret != -1) {
            throw new RtmpIOException(ret);
        }
        return ret;
    }

    private native int nativeRead(byte[] var1, int var2, int var3, long var4) throws IllegalStateException;

    public int write(byte[] data) throws RtmpIOException, IllegalStateException {
        return this.write(data, 0, data.length);
    }

    public int write(byte[] data, int offset, int size) throws RtmpIOException, IllegalStateException {
        int ret = this.nativeWrite(data, offset, size, this.rtmpPointer);
        if (ret < 0) {
            throw new RtmpIOException(ret);
        }
        return ret;
    }

    private native int nativeWrite(byte[] var1, int var2, int var3, long var4) throws IllegalStateException;

    public boolean pause(boolean pause) throws RtmpIOException, IllegalStateException {
        int ret = this.nativePause(pause, this.rtmpPointer);
        if (ret != 0) {
            throw new RtmpIOException(ret);
        }
        return true;
    }

    private native int nativePause(boolean var1, long var2) throws IllegalStateException;

    public boolean isConnected() {
        return this.nativeIsConnected(this.rtmpPointer);
    }

    private native boolean nativeIsConnected(long var1);

    public void close() {
        this.nativeClose(this.rtmpPointer);
        this.rtmpPointer = 0L;
    }

    private native void nativeClose(long var1);

    static {
        System.loadLibrary("rtmp-jni");
    }

    public static class RtmpIOException
    extends IOException {
        public static final int OPEN_ALLOC = -2;
        public static final int OPEN_CONNECT_STREAM = -3;
        public static final int UNKNOWN_RTMP_OPTION = -4;
        public static final int UNKNOWN_RTMP_AMF_TYPE = -5;
        public static final int DNS_NOT_REACHABLE = -6;
        public static final int SOCKET_CONNECT_FAIL = -7;
        public static final int SOCKS_NEGOTIATION_FAIL = -8;
        public static final int SOCKET_CREATE_FAIL = -9;
        public static final int NO_SSL_TLS_SUPP = -10;
        public static final int HANDSHAKE_CONNECT_FAIL = -11;
        public static final int HANDSHAKE_FAIL = -12;
        public static final int RTMP_CONNECT_FAIL = -13;
        public static final int CONNECTION_LOST = -14;
        public static final int RTMP_KEYFRAME_TS_MISMATCH = -15;
        public static final int RTMP_READ_CORRUPT_STREAM = -16;
        public static final int RTMP_MEM_ALLOC_FAIL = -17;
        public static final int RTMP_STREAM_BAD_DATASIZE = -18;
        public static final int RTMP_PACKET_TOO_SMALL = -19;
        public static final int RTMP_SEND_PACKET_FAIL = -20;
        public static final int RTMP_AMF_ENCODE_FAIL = -21;
        public static final int URL_MISSING_PROTOCOL = -22;
        public static final int URL_MISSING_HOSTNAME = -23;
        public static final int URL_INCORRECT_PORT = -24;
        public static final int RTMP_IGNORED = -25;
        public static final int RTMP_GENERIC_ERROR = -26;
        public static final int RTMP_SANITY_FAIL = -27;
        public final int errorCode;

        public RtmpIOException(int errorCode) {
            super("RTMP error: " + errorCode);
            this.errorCode = errorCode;
        }
    }
}

