/*
 * Decompiled with CFR 0.152.
 */
package com.twobigears.audio360;

import com.twobigears.audio360.Audio360JNI;
import com.twobigears.audio360.TBVector;

public class TBQuat {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected TBQuat(long cPtr, boolean cMemoryOwn) {
        this.swigCMemOwn = cMemoryOwn;
        this.swigCPtr = cPtr;
    }

    protected static long getCPtr(TBQuat obj) {
        return obj == null ? 0L : obj.swigCPtr;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                Audio360JNI.delete_TBQuat(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public void setX(float value) {
        Audio360JNI.TBQuat_x_set(this.swigCPtr, this, value);
    }

    public float getX() {
        return Audio360JNI.TBQuat_x_get(this.swigCPtr, this);
    }

    public void setY(float value) {
        Audio360JNI.TBQuat_y_set(this.swigCPtr, this, value);
    }

    public float getY() {
        return Audio360JNI.TBQuat_y_get(this.swigCPtr, this);
    }

    public void setZ(float value) {
        Audio360JNI.TBQuat_z_set(this.swigCPtr, this, value);
    }

    public float getZ() {
        return Audio360JNI.TBQuat_z_get(this.swigCPtr, this);
    }

    public void setW(float value) {
        Audio360JNI.TBQuat_w_set(this.swigCPtr, this, value);
    }

    public float getW() {
        return Audio360JNI.TBQuat_w_get(this.swigCPtr, this);
    }

    public TBQuat() {
        this(Audio360JNI.new_TBQuat__SWIG_0(), true);
    }

    public TBQuat(float xValue, float yValue, float zValue, float wValue) {
        this(Audio360JNI.new_TBQuat__SWIG_1(xValue, yValue, zValue, wValue), true);
    }

    public TBQuat(TBQuat quat) {
        this(Audio360JNI.new_TBQuat__SWIG_2(TBQuat.getCPtr(quat), quat), true);
    }

    public String toString(int precision) {
        return Audio360JNI.TBQuat_toString__SWIG_0(this.swigCPtr, this, precision);
    }

    public String toString() {
        return Audio360JNI.TBQuat_toString__SWIG_1(this.swigCPtr, this);
    }

    public TBQuat invert() {
        return new TBQuat(Audio360JNI.TBQuat_invert(this.swigCPtr, this), true);
    }

    public static TBQuat convertFromOpenGLQuaternion(float x, float y, float z, float w) {
        return new TBQuat(Audio360JNI.TBQuat_convertFromOpenGLQuaternion(x, y, z, w), true);
    }

    public static TBQuat getQuatFromEulerAngles(float x_radians, float y_radians, float z_radians) {
        return new TBQuat(Audio360JNI.TBQuat_getQuatFromEulerAngles(x_radians, y_radians, z_radians), true);
    }

    public static TBVector getEulerAnglesFromQuat(TBQuat q) {
        return new TBVector(Audio360JNI.TBQuat_getEulerAnglesFromQuat(TBQuat.getCPtr(q), q), true);
    }

    public static TBQuat quatProductUnNormalised(TBQuat a, TBQuat b) {
        return new TBQuat(Audio360JNI.TBQuat_quatProductUnNormalised(TBQuat.getCPtr(a), a, TBQuat.getCPtr(b), b), true);
    }

    public static TBVector rotateVectorByQuat(TBQuat quat, TBVector vector) {
        return new TBVector(Audio360JNI.TBQuat_rotateVectorByQuat(TBQuat.getCPtr(quat), quat, TBVector.getCPtr(vector), vector), true);
    }

    public static TBVector antiRotateVectorByQuat(TBQuat rotQuat, TBVector vector) {
        return new TBVector(Audio360JNI.TBQuat_antiRotateVectorByQuat(TBQuat.getCPtr(rotQuat), rotQuat, TBVector.getCPtr(vector), vector), true);
    }

    public static TBQuat getFromToQuatRotation(TBVector fromVec, TBVector toVec) {
        return new TBQuat(Audio360JNI.TBQuat_getFromToQuatRotation(TBVector.getCPtr(fromVec), fromVec, TBVector.getCPtr(toVec), toVec), true);
    }

    public static TBVector getForwardFromQuat(TBQuat quat) {
        return new TBVector(Audio360JNI.TBQuat_getForwardFromQuat(TBQuat.getCPtr(quat), quat), true);
    }

    public static TBVector getUpFromQuat(TBQuat quat) {
        return new TBVector(Audio360JNI.TBQuat_getUpFromQuat(TBQuat.getCPtr(quat), quat), true);
    }

    public static TBVector getRightFromQuat(TBQuat quat) {
        return new TBVector(Audio360JNI.TBQuat_getRightFromQuat(TBQuat.getCPtr(quat), quat), true);
    }

    public static TBQuat getQuatFromForwardAndUpVectors(TBVector forwardVector, TBVector upVector) {
        return new TBQuat(Audio360JNI.TBQuat_getQuatFromForwardAndUpVectors(TBVector.getCPtr(forwardVector), forwardVector, TBVector.getCPtr(upVector), upVector), true);
    }

    public static TBQuat getQuatFromMatrix(float m00, float m01, float m02, float m10, float m11, float m12, float m20, float m21, float m22) {
        return new TBQuat(Audio360JNI.TBQuat_getQuatFromMatrix(m00, m01, m02, m10, m11, m12, m20, m21, m22), true);
    }

    public static TBQuat identity() {
        return new TBQuat(Audio360JNI.TBQuat_identity(), true);
    }

    public void normalise() {
        Audio360JNI.TBQuat_normalise(this.swigCPtr, this);
    }

    public static TBQuat generateRandomQuat() {
        return new TBQuat(Audio360JNI.TBQuat_generateRandomQuat(), true);
    }
}

