/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.common;

import android.os.Bundle;
import androidx.media3.common.Bundleable;
import androidx.media3.common.HeartRating;
import androidx.media3.common.PercentageRating;
import androidx.media3.common.StarRating;
import androidx.media3.common.ThumbRating;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;

public abstract class Rating
implements Bundleable {
    static final float RATING_UNSET = -1.0f;
    static final int RATING_TYPE_UNSET = -1;
    static final int RATING_TYPE_HEART = 0;
    static final int RATING_TYPE_PERCENTAGE = 1;
    static final int RATING_TYPE_STAR = 2;
    static final int RATING_TYPE_THUMB = 3;
    static final String FIELD_RATING_TYPE = Util.intToStringMaxRadix(0);
    @UnstableApi
    public static final Bundleable.Creator<Rating> CREATOR = Rating::fromBundle;

    Rating() {
    }

    public abstract boolean isRated();

    private static Rating fromBundle(Bundle bundle) {
        int ratingType = bundle.getInt(FIELD_RATING_TYPE, -1);
        switch (ratingType) {
            case 0: {
                return HeartRating.CREATOR.fromBundle(bundle);
            }
            case 1: {
                return PercentageRating.CREATOR.fromBundle(bundle);
            }
            case 2: {
                return StarRating.CREATOR.fromBundle(bundle);
            }
            case 3: {
                return ThumbRating.CREATOR.fromBundle(bundle);
            }
        }
        throw new IllegalArgumentException("Unknown RatingType: " + ratingType);
    }
}

