/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.common.audio;

import android.util.SparseArray;
import androidx.media3.common.audio.AudioProcessor;
import androidx.media3.common.audio.BaseAudioProcessor;
import androidx.media3.common.audio.ChannelMixingMatrix;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import java.nio.ByteBuffer;

@UnstableApi
public final class ChannelMixingAudioProcessor
extends BaseAudioProcessor {
    private final SparseArray<ChannelMixingMatrix> matrixByInputChannelCount = new SparseArray();

    public void putChannelMixingMatrix(ChannelMixingMatrix matrix) {
        int inputChannelCount = matrix.getInputChannelCount();
        this.matrixByInputChannelCount.put(inputChannelCount, (Object)matrix);
    }

    @Override
    protected AudioProcessor.AudioFormat onConfigure(AudioProcessor.AudioFormat inputAudioFormat) throws AudioProcessor.UnhandledAudioFormatException {
        if (inputAudioFormat.encoding != 2) {
            throw new AudioProcessor.UnhandledAudioFormatException(inputAudioFormat);
        }
        ChannelMixingMatrix channelMixingMatrix = (ChannelMixingMatrix)this.matrixByInputChannelCount.get(inputAudioFormat.channelCount);
        if (channelMixingMatrix == null) {
            throw new AudioProcessor.UnhandledAudioFormatException("No mixing matrix for input channel count", inputAudioFormat);
        }
        if (channelMixingMatrix.isIdentity()) {
            return AudioProcessor.AudioFormat.NOT_SET;
        }
        return new AudioProcessor.AudioFormat(inputAudioFormat.sampleRate, channelMixingMatrix.getOutputChannelCount(), 2);
    }

    @Override
    public void queueInput(ByteBuffer inputBuffer) {
        ChannelMixingMatrix channelMixingMatrix = Assertions.checkStateNotNull((ChannelMixingMatrix)this.matrixByInputChannelCount.get(this.inputAudioFormat.channelCount));
        int inputFramesToMix = inputBuffer.remaining() / this.inputAudioFormat.bytesPerFrame;
        ByteBuffer outputBuffer = this.replaceOutputBuffer(inputFramesToMix * this.outputAudioFormat.bytesPerFrame);
        int inputChannelCount = channelMixingMatrix.getInputChannelCount();
        int outputChannelCount = channelMixingMatrix.getOutputChannelCount();
        float[] outputFrame = new float[outputChannelCount];
        while (inputBuffer.hasRemaining()) {
            for (int inputChannelIndex = 0; inputChannelIndex < inputChannelCount; ++inputChannelIndex) {
                short inputValue = inputBuffer.getShort();
                for (int outputChannelIndex = 0; outputChannelIndex < outputChannelCount; ++outputChannelIndex) {
                    int n = outputChannelIndex;
                    outputFrame[n] = outputFrame[n] + channelMixingMatrix.getMixingCoefficient(inputChannelIndex, outputChannelIndex) * (float)inputValue;
                }
            }
            for (int outputChannelIndex = 0; outputChannelIndex < outputChannelCount; ++outputChannelIndex) {
                short shortValue = (short)Util.constrainValue(outputFrame[outputChannelIndex], -32768.0f, 32767.0f);
                outputBuffer.put((byte)(shortValue & 0xFF));
                outputBuffer.put((byte)(shortValue >> 8 & 0xFF));
                outputFrame[outputChannelIndex] = 0.0f;
            }
        }
        outputBuffer.flip();
    }
}

