/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.common.util;

import androidx.media3.common.util.Clock;
import androidx.media3.common.util.UnstableApi;

@UnstableApi
public class ConditionVariable {
    private final Clock clock;
    private boolean isOpen;

    public ConditionVariable() {
        this(Clock.DEFAULT);
    }

    public ConditionVariable(Clock clock) {
        this.clock = clock;
    }

    public synchronized boolean open() {
        if (this.isOpen) {
            return false;
        }
        this.isOpen = true;
        this.notifyAll();
        return true;
    }

    public synchronized boolean close() {
        boolean wasOpen = this.isOpen;
        this.isOpen = false;
        return wasOpen;
    }

    public synchronized void block() throws InterruptedException {
        while (!this.isOpen) {
            this.wait();
        }
    }

    public synchronized boolean block(long timeoutMs) throws InterruptedException {
        if (timeoutMs <= 0L) {
            return this.isOpen;
        }
        long nowMs = this.clock.elapsedRealtime();
        long endMs = nowMs + timeoutMs;
        if (endMs < nowMs) {
            this.block();
        } else {
            while (!this.isOpen && nowMs < endMs) {
                this.wait(endMs - nowMs);
                nowMs = this.clock.elapsedRealtime();
            }
        }
        return this.isOpen;
    }

    public synchronized void blockUninterruptible() {
        boolean wasInterrupted = false;
        while (!this.isOpen) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                wasInterrupted = true;
            }
        }
        if (wasInterrupted) {
            Thread.currentThread().interrupt();
        }
    }

    public synchronized boolean isOpen() {
        return this.isOpen;
    }
}

