/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.common.util;

import android.annotation.SuppressLint;
import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.content.Context;
import androidx.annotation.Nullable;
import androidx.annotation.StringRes;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@SuppressLint(value={"InlinedApi"})
@UnstableApi
public final class NotificationUtil {
    public static final int IMPORTANCE_UNSPECIFIED = -1000;
    public static final int IMPORTANCE_NONE = 0;
    public static final int IMPORTANCE_MIN = 1;
    public static final int IMPORTANCE_LOW = 2;
    public static final int IMPORTANCE_DEFAULT = 3;
    public static final int IMPORTANCE_HIGH = 4;

    public static void createNotificationChannel(Context context, String id, @StringRes int nameResourceId, @StringRes int descriptionResourceId, int importance) {
        if (Util.SDK_INT >= 26) {
            NotificationManager notificationManager = Assertions.checkNotNull((NotificationManager)context.getSystemService("notification"));
            NotificationChannel channel = new NotificationChannel(id, (CharSequence)context.getString(nameResourceId), importance);
            if (descriptionResourceId != 0) {
                channel.setDescription(context.getString(descriptionResourceId));
            }
            notificationManager.createNotificationChannel(channel);
        }
    }

    public static void setNotification(Context context, int id, @Nullable Notification notification) {
        NotificationManager notificationManager = Assertions.checkNotNull((NotificationManager)context.getSystemService("notification"));
        if (notification != null) {
            notificationManager.notify(id, notification);
        } else {
            notificationManager.cancel(id);
        }
    }

    private NotificationUtil() {
    }

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.TYPE_USE})
    public static @interface Importance {
    }
}

