/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.datasource;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.BitmapLoader;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.datasource.DataSource;
import androidx.media3.datasource.DataSourceUtil;
import androidx.media3.datasource.DataSpec;
import androidx.media3.datasource.DefaultDataSource;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

@UnstableApi
public final class DataSourceBitmapLoader
implements BitmapLoader {
    public static final Supplier<ListeningExecutorService> DEFAULT_EXECUTOR_SERVICE = Suppliers.memoize(() -> MoreExecutors.listeningDecorator((ExecutorService)Executors.newSingleThreadExecutor()));
    private final ListeningExecutorService listeningExecutorService;
    private final DataSource.Factory dataSourceFactory;

    public DataSourceBitmapLoader(Context context) {
        this((ListeningExecutorService)Assertions.checkStateNotNull((Object)((ListeningExecutorService)DEFAULT_EXECUTOR_SERVICE.get())), new DefaultDataSource.Factory(context));
    }

    public DataSourceBitmapLoader(ListeningExecutorService listeningExecutorService, DataSource.Factory dataSourceFactory) {
        this.listeningExecutorService = listeningExecutorService;
        this.dataSourceFactory = dataSourceFactory;
    }

    public ListenableFuture<Bitmap> decodeBitmap(byte[] data) {
        return this.listeningExecutorService.submit(() -> DataSourceBitmapLoader.decode(data));
    }

    public ListenableFuture<Bitmap> loadBitmap(Uri uri) {
        return this.listeningExecutorService.submit(() -> DataSourceBitmapLoader.load(this.dataSourceFactory.createDataSource(), uri));
    }

    private static Bitmap decode(byte[] data) {
        Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)data.length);
        Assertions.checkArgument((bitmap != null ? 1 : 0) != 0, (Object)"Could not decode image data");
        return bitmap;
    }

    private static Bitmap load(DataSource dataSource, Uri uri) throws IOException {
        DataSpec dataSpec = new DataSpec(uri);
        dataSource.open(dataSpec);
        byte[] readData = DataSourceUtil.readToEnd(dataSource);
        return DataSourceBitmapLoader.decode(readData);
    }
}

