/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.extractor;

import androidx.annotation.Nullable;
import androidx.media3.common.ParserException;
import androidx.media3.common.util.CodecSpecificDataUtil;
import androidx.media3.common.util.ParsableByteArray;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.container.NalUnitUtil;
import java.util.ArrayList;
import java.util.List;

@UnstableApi
public final class AvcConfig {
    public final List<byte[]> initializationData;
    public final int nalUnitLengthFieldLength;
    public final int width;
    public final int height;
    public final int colorSpace;
    public final int colorRange;
    public final int colorTransfer;
    public final float pixelWidthHeightRatio;
    @Nullable
    public final String codecs;

    public static AvcConfig parse(ParsableByteArray data) throws ParserException {
        try {
            data.skipBytes(4);
            int nalUnitLengthFieldLength = (data.readUnsignedByte() & 3) + 1;
            if (nalUnitLengthFieldLength == 3) {
                throw new IllegalStateException();
            }
            ArrayList<byte[]> initializationData = new ArrayList<byte[]>();
            int numSequenceParameterSets = data.readUnsignedByte() & 0x1F;
            for (int j = 0; j < numSequenceParameterSets; ++j) {
                initializationData.add(AvcConfig.buildNalUnitForChild(data));
            }
            int numPictureParameterSets = data.readUnsignedByte();
            for (int j = 0; j < numPictureParameterSets; ++j) {
                initializationData.add(AvcConfig.buildNalUnitForChild(data));
            }
            int width = -1;
            int height = -1;
            int colorSpace = -1;
            int colorRange = -1;
            int colorTransfer = -1;
            float pixelWidthHeightRatio = 1.0f;
            String codecs = null;
            if (numSequenceParameterSets > 0) {
                byte[] sps = (byte[])initializationData.get(0);
                NalUnitUtil.SpsData spsData = NalUnitUtil.parseSpsNalUnit((byte[])((byte[])initializationData.get(0)), (int)nalUnitLengthFieldLength, (int)sps.length);
                width = spsData.width;
                height = spsData.height;
                colorSpace = spsData.colorSpace;
                colorRange = spsData.colorRange;
                colorTransfer = spsData.colorTransfer;
                pixelWidthHeightRatio = spsData.pixelWidthHeightRatio;
                codecs = CodecSpecificDataUtil.buildAvcCodecString((int)spsData.profileIdc, (int)spsData.constraintsFlagsAndReservedZero2Bits, (int)spsData.levelIdc);
            }
            return new AvcConfig(initializationData, nalUnitLengthFieldLength, width, height, colorSpace, colorRange, colorTransfer, pixelWidthHeightRatio, codecs);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw ParserException.createForMalformedContainer((String)"Error parsing AVC config", (Throwable)e);
        }
    }

    private AvcConfig(List<byte[]> initializationData, int nalUnitLengthFieldLength, int width, int height, int colorSpace, int colorRange, int colorTransfer, float pixelWidthHeightRatio, @Nullable String codecs) {
        this.initializationData = initializationData;
        this.nalUnitLengthFieldLength = nalUnitLengthFieldLength;
        this.width = width;
        this.height = height;
        this.colorSpace = colorSpace;
        this.colorRange = colorRange;
        this.colorTransfer = colorTransfer;
        this.pixelWidthHeightRatio = pixelWidthHeightRatio;
        this.codecs = codecs;
    }

    private static byte[] buildNalUnitForChild(ParsableByteArray data) {
        int length = data.readUnsignedShort();
        int offset = data.getPosition();
        data.skipBytes(length);
        return CodecSpecificDataUtil.buildNalUnit((byte[])data.getData(), (int)offset, (int)length);
    }
}

