/*
 * Decompiled with CFR 0.152.
 */
package com.renderheads.AVPro.Video;

import androidx.media3.common.audio.AudioProcessor;
import androidx.media3.common.audio.BaseAudioProcessor;
import androidx.media3.common.util.Assertions;
import com.renderheads.AVPro.Video.Manager;
import com.renderheads.AVPro.Video.ZeroingAudioProcessor$AudioBufferSink;
import com.renderheads.resamplerh.Resample;
import java.nio.Buffer;
import java.nio.ByteBuffer;

public final class ZeroingAudioProcessor
extends BaseAudioProcessor {
    private ZeroingAudioProcessor$AudioBufferSink m_AudioBufferSink;
    private ByteBuffer m_OutputBuffer;
    private int m_iPlayerIndex;
    private Resample m_Resampler;
    private int m_iBufferSize;
    private float[] m_TempOutBuffer;
    private float[] m_afPullSamplesCachedBuffer;
    private int m_iPullSamplesCachedBufferSize;
    private boolean m_bInputEnded;
    private int m_iOutputSampleRate;
    private double m_DebugRunningTime;
    private long m_DebugRunningCount;
    private int m_DebugRunningLog;

    public ZeroingAudioProcessor() {
        this.m_AudioBufferSink = null;
        this.m_OutputBuffer = BaseAudioProcessor.EMPTY_BUFFER;
        this.m_iPlayerIndex = -1;
        this.m_Resampler = new Resample();
        this.m_iBufferSize = 0;
        this.m_TempOutBuffer = null;
        this.m_afPullSamplesCachedBuffer = null;
        this.m_iPullSamplesCachedBufferSize = 0;
        this.m_bInputEnded = false;
        this.m_iOutputSampleRate = 48000;
        this.m_DebugRunningTime = 0.0;
        this.m_DebugRunningCount = 0L;
        this.m_DebugRunningLog = 0;
    }

    public ZeroingAudioProcessor(int n, ZeroingAudioProcessor$AudioBufferSink zeroingAudioProcessor$AudioBufferSink) {
        ZeroingAudioProcessor zeroingAudioProcessor = this;
        this.m_AudioBufferSink = null;
        this.m_OutputBuffer = BaseAudioProcessor.EMPTY_BUFFER;
        this.m_iPlayerIndex = -1;
        this.m_Resampler = new Resample();
        this.m_iBufferSize = 0;
        this.m_TempOutBuffer = null;
        this.m_afPullSamplesCachedBuffer = null;
        this.m_iPullSamplesCachedBufferSize = 0;
        this.m_bInputEnded = false;
        this.m_iOutputSampleRate = 48000;
        this.m_DebugRunningTime = 0.0;
        this.m_DebugRunningCount = 0L;
        this.m_DebugRunningLog = 0;
        this.m_iPlayerIndex = n;
        zeroingAudioProcessor.m_AudioBufferSink = (ZeroingAudioProcessor$AudioBufferSink)Assertions.checkNotNull((Object)zeroingAudioProcessor$AudioBufferSink);
        zeroingAudioProcessor.m_iPullSamplesCachedBufferSize = 2048;
        zeroingAudioProcessor.m_afPullSamplesCachedBuffer = new float[2048];
    }

    private void CreateAudioBuffers(int n, int n2, int n3, int n4, int n5) {
        float f = 5;
        int n6 = (int)((float)16 / 8.0f * (float)(n4 * n2) * f);
        if (this.m_iBufferSize != n6) {
            ZeroingAudioProcessor zeroingAudioProcessor = this;
            Manager.AudioCaptureBuffer_Initialise(zeroingAudioProcessor.m_iPlayerIndex, n6);
            Manager.AudioCaptureBuffer_Reset(zeroingAudioProcessor.m_iPlayerIndex);
            Resample.Initialise((int)zeroingAudioProcessor.m_iPlayerIndex, (int)n3, (int)this.m_iOutputSampleRate, (int)n2, (int)0);
            this.m_iBufferSize = n6;
        }
    }

    private void OfferBufferToAudioBuffer(ByteBuffer object) {
        if (this.m_iOutputSampleRate != this.inputAudioFormat.sampleRate) {
            int n;
            byte[] byArray = null;
            if (!((ByteBuffer)object).hasArray()) {
                ByteBuffer byteBuffer = object;
                byArray = new byte[byteBuffer.remaining()];
                byteBuffer.get(byArray);
            }
            int n2 = byArray != null ? byArray.length / 2 : ((Buffer)object).remaining() / 2;
            float f = n2;
            float f2 = this.m_iOutputSampleRate;
            AudioProcessor.AudioFormat audioFormat = this.inputAudioFormat;
            int n3 = (int)(f2 / (float)audioFormat.sampleRate * f + 0.5f);
            int n4 = audioFormat.channelCount;
            n3 = n4 * (int)Math.floor(Math.abs(n3 / n4));
            float[] fArray = this.m_TempOutBuffer;
            int n5 = n3 * 2;
            if (this.m_TempOutBuffer.length < n5) {
                int n6;
                for (n6 = fArray.length; n6 < n5; n6 += 10240) {
                }
                this.m_TempOutBuffer = new float[n6];
            }
            boolean bl = false;
            if (byArray != null) {
                object = this.m_TempOutBuffer;
                n = Resample.Resample((int)this.m_iPlayerIndex, (byte[])byArray, (int)0, (int)n2, (float[])object, (int)n3, (boolean)bl);
            } else {
                ByteBuffer byteBuffer = object;
                object = byteBuffer.array();
                int n7 = byteBuffer.arrayOffset();
                Object object2 = object;
                object = this.m_TempOutBuffer;
                n = Resample.Resample((int)this.m_iPlayerIndex, (byte[])object2, (int)n7, (int)n2, (float[])object, (int)n3, (boolean)bl);
            }
            Manager.AudioCaptureBuffer_OfferBytes(this.m_iPlayerIndex, this.m_TempOutBuffer, n);
        } else {
            byte[] byArray = null;
            if (!((ByteBuffer)object).hasArray()) {
                ByteBuffer byteBuffer = object;
                byArray = new byte[byteBuffer.remaining()];
                byteBuffer.get(byArray);
            }
            int n = byArray != null ? byArray.length : ((Buffer)object).limit() / 2;
            float[] fArray = this.m_TempOutBuffer;
            if (this.m_TempOutBuffer.length < n) {
                int n8;
                for (n8 = fArray.length; n8 < n; n8 += 10240) {
                }
                this.m_TempOutBuffer = new float[n8];
            }
            n = 0;
            float f = 3.051851E-5f;
            float f3 = 3.0517578E-5f;
            if (byArray == null) {
                int n9 = ((Buffer)object).limit();
                for (int i = 0; i < n9; i += 2) {
                    short s = (short)((short)((ByteBuffer)object).get(i + 1) << 8 & 0xFF00 | (short)((ByteBuffer)object).get(i) & 0xFF);
                    this.m_TempOutBuffer[n] = s > 0 ? Math.max(Math.min((float)s * f, 1.0f), -1.0f) : (s < 0 ? Math.max(Math.min((float)s * f3, 1.0f), -1.0f) : 0.0f);
                    ++n;
                }
            } else {
                for (int i = 0; i < byArray.length; i += 2) {
                    short s = (short)((short)byArray[i + 1] << 8 & 0xFF00 | (short)byArray[i] & 0xFF);
                    this.m_TempOutBuffer[n] = s > 0 ? Math.max(Math.min((float)s * f, 1.0f), -1.0f) : (s < 0 ? Math.max(Math.min((float)s * f3, 1.0f), -1.0f) : 0.0f);
                    ++n;
                }
            }
            Manager.AudioCaptureBuffer_OfferBytes(this.m_iPlayerIndex, this.m_TempOutBuffer, n);
        }
    }

    private void flushSinkIfActive() {
        ZeroingAudioProcessor zeroingAudioProcessor = this;
        zeroingAudioProcessor.isActive();
        Manager.AudioCaptureBuffer_GetSpaceUsed(zeroingAudioProcessor.m_iPlayerIndex);
        if (zeroingAudioProcessor.isActive() && !this.m_bInputEnded) {
            ZeroingAudioProcessor zeroingAudioProcessor2 = this;
            AudioProcessor.AudioFormat audioFormat = this.inputAudioFormat;
            int cfr_ignored_0 = audioFormat.sampleRate;
            int cfr_ignored_1 = audioFormat.channelCount;
            int cfr_ignored_2 = audioFormat.encoding;
            zeroingAudioProcessor2.m_AudioBufferSink.getClass();
            Resample.Flush((int)zeroingAudioProcessor2.m_iPlayerIndex);
            Manager.AudioCaptureBuffer_Reset(zeroingAudioProcessor2.m_iPlayerIndex);
        }
        this.m_bInputEnded = false;
    }

    public void SetOutputSampleRate(int n) {
        if (this.m_iPlayerIndex > -1 && n != this.m_iOutputSampleRate) {
            this.m_iOutputSampleRate = n;
            AudioProcessor.AudioFormat audioFormat = this.inputAudioFormat;
            int n2 = audioFormat.channelCount;
            if (n2 > 0) {
                AudioProcessor.AudioFormat audioFormat2 = audioFormat;
                int n3 = audioFormat2.encoding;
                int n4 = audioFormat2.sampleRate;
                this.CreateAudioBuffers(n3, n2, n4, n, n3);
            }
        }
    }

    public AudioProcessor.AudioFormat onConfigure(AudioProcessor.AudioFormat audioFormat) {
        audioFormat.toString();
        this.m_bInputEnded = false;
        if (this.m_TempOutBuffer == null) {
            this.m_TempOutBuffer = new float[32768];
        }
        if (this.m_iPlayerIndex < 0) {
            return audioFormat;
        }
        ZeroingAudioProcessor zeroingAudioProcessor = this;
        AudioProcessor.AudioFormat audioFormat2 = audioFormat;
        int n = audioFormat2.encoding;
        int n2 = audioFormat2.channelCount;
        int n3 = audioFormat2.sampleRate;
        int n4 = zeroingAudioProcessor.m_iOutputSampleRate;
        zeroingAudioProcessor.CreateAudioBuffers(n, n2, n3, n4, n);
        return audioFormat;
    }

    public int GetAudioBufferedSampleCount() {
        return Manager.AudioCaptureBuffer_GetSpaceUsed(this.m_iPlayerIndex);
    }

    public float[] PullAudioFromBuffer(int n, int n2) {
        if (n <= Manager.AudioCaptureBuffer_GetSpaceUsed(this.m_iPlayerIndex)) {
            if (n > this.m_iPullSamplesCachedBufferSize) {
                this.m_iPullSamplesCachedBufferSize = n;
                this.m_afPullSamplesCachedBuffer = new float[n];
            }
            if (Manager.AudioCaptureBuffer_Poll(this.m_afPullSamplesCachedBuffer, n) == n) {
                return this.m_afPullSamplesCachedBuffer;
            }
        }
        return null;
    }

    public void queueInput(ByteBuffer byteBuffer) {
        int n = byteBuffer.remaining();
        if (n != 0) {
            int n2 = byteBuffer.limit();
            this.OfferBufferToAudioBuffer(byteBuffer);
            byteBuffer.position(n2);
            ByteBuffer byteBuffer2 = this.replaceOutputBuffer(n);
            for (int i = 0; i < n; ++i) {
                byteBuffer2.put((byte)0);
            }
            byteBuffer2.flip();
        }
    }

    public void onFlush() {
        ZeroingAudioProcessor zeroingAudioProcessor = this;
        super.onFlush();
        zeroingAudioProcessor.flushSinkIfActive();
    }

    public void onQueueEndOfStream() {
        super.onQueueEndOfStream();
        this.m_bInputEnded = true;
    }

    public void onReset() {
        ZeroingAudioProcessor zeroingAudioProcessor = this;
        super.onReset();
        zeroingAudioProcessor.flushSinkIfActive();
    }
}

