/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer.drm;

import androidx.annotation.Nullable;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.decoder.CryptoConfig;
import androidx.media3.exoplayer.drm.DrmSessionEventListener;
import java.io.IOException;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Map;
import java.util.UUID;

@UnstableApi
public interface DrmSession {
    public static final int STATE_RELEASED = 0;
    public static final int STATE_ERROR = 1;
    public static final int STATE_OPENING = 2;
    public static final int STATE_OPENED = 3;
    public static final int STATE_OPENED_WITH_KEYS = 4;

    public static void replaceSession(@Nullable DrmSession previousSession, @Nullable DrmSession newSession) {
        if (previousSession == newSession) {
            return;
        }
        if (newSession != null) {
            newSession.acquire(null);
        }
        if (previousSession != null) {
            previousSession.release(null);
        }
    }

    public int getState();

    default public boolean playClearSamplesWithoutKeys() {
        return false;
    }

    @Nullable
    public DrmSessionException getError();

    public UUID getSchemeUuid();

    @Nullable
    public CryptoConfig getCryptoConfig();

    @Nullable
    public Map<String, String> queryKeyStatus();

    @Nullable
    public byte[] getOfflineLicenseKeySetId();

    public boolean requiresSecureDecoder(String var1);

    public void acquire(@Nullable DrmSessionEventListener.EventDispatcher var1);

    public void release(@Nullable DrmSessionEventListener.EventDispatcher var1);

    @Documented
    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.FIELD, ElementType.METHOD, ElementType.PARAMETER, ElementType.LOCAL_VARIABLE, ElementType.TYPE_USE})
    public static @interface State {
    }

    public static class DrmSessionException
    extends IOException {
        public final int errorCode;

        public DrmSessionException(Throwable cause, int errorCode) {
            super(cause);
            this.errorCode = errorCode;
        }
    }
}

