/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer.source;

import android.os.Looper;
import androidx.annotation.Nullable;
import androidx.media3.common.MediaItem;
import androidx.media3.common.Timeline;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.datasource.DataSource;
import androidx.media3.datasource.TransferListener;
import androidx.media3.exoplayer.analytics.PlayerId;
import androidx.media3.exoplayer.drm.DefaultDrmSessionManagerProvider;
import androidx.media3.exoplayer.drm.DrmSessionManager;
import androidx.media3.exoplayer.drm.DrmSessionManagerProvider;
import androidx.media3.exoplayer.source.BaseMediaSource;
import androidx.media3.exoplayer.source.BundledExtractorsAdapter;
import androidx.media3.exoplayer.source.ForwardingTimeline;
import androidx.media3.exoplayer.source.MediaPeriod;
import androidx.media3.exoplayer.source.MediaSource;
import androidx.media3.exoplayer.source.MediaSourceFactory;
import androidx.media3.exoplayer.source.ProgressiveMediaExtractor;
import androidx.media3.exoplayer.source.ProgressiveMediaPeriod;
import androidx.media3.exoplayer.source.SinglePeriodTimeline;
import androidx.media3.exoplayer.upstream.Allocator;
import androidx.media3.exoplayer.upstream.DefaultLoadErrorHandlingPolicy;
import androidx.media3.exoplayer.upstream.LoadErrorHandlingPolicy;
import androidx.media3.extractor.DefaultExtractorsFactory;
import androidx.media3.extractor.ExtractorsFactory;
import com.google.errorprone.annotations.CanIgnoreReturnValue;

@UnstableApi
public final class ProgressiveMediaSource
extends BaseMediaSource
implements ProgressiveMediaPeriod.Listener {
    public static final int DEFAULT_LOADING_CHECK_INTERVAL_BYTES = 0x100000;
    private final MediaItem mediaItem;
    private final MediaItem.LocalConfiguration localConfiguration;
    private final DataSource.Factory dataSourceFactory;
    private final ProgressiveMediaExtractor.Factory progressiveMediaExtractorFactory;
    private final DrmSessionManager drmSessionManager;
    private final LoadErrorHandlingPolicy loadableLoadErrorHandlingPolicy;
    private final int continueLoadingCheckIntervalBytes;
    private boolean timelineIsPlaceholder;
    private long timelineDurationUs;
    private boolean timelineIsSeekable;
    private boolean timelineIsLive;
    @Nullable
    private TransferListener transferListener;

    private ProgressiveMediaSource(MediaItem mediaItem, DataSource.Factory dataSourceFactory, ProgressiveMediaExtractor.Factory progressiveMediaExtractorFactory, DrmSessionManager drmSessionManager, LoadErrorHandlingPolicy loadableLoadErrorHandlingPolicy, int continueLoadingCheckIntervalBytes) {
        this.localConfiguration = (MediaItem.LocalConfiguration)Assertions.checkNotNull((Object)mediaItem.localConfiguration);
        this.mediaItem = mediaItem;
        this.dataSourceFactory = dataSourceFactory;
        this.progressiveMediaExtractorFactory = progressiveMediaExtractorFactory;
        this.drmSessionManager = drmSessionManager;
        this.loadableLoadErrorHandlingPolicy = loadableLoadErrorHandlingPolicy;
        this.continueLoadingCheckIntervalBytes = continueLoadingCheckIntervalBytes;
        this.timelineIsPlaceholder = true;
        this.timelineDurationUs = -9223372036854775807L;
    }

    @Override
    public MediaItem getMediaItem() {
        return this.mediaItem;
    }

    @Override
    protected void prepareSourceInternal(@Nullable TransferListener mediaTransferListener) {
        this.transferListener = mediaTransferListener;
        this.drmSessionManager.setPlayer((Looper)Assertions.checkNotNull((Object)Looper.myLooper()), this.getPlayerId());
        this.drmSessionManager.prepare();
        this.notifySourceInfoRefreshed();
    }

    @Override
    public void maybeThrowSourceInfoRefreshError() {
    }

    @Override
    public MediaPeriod createPeriod(MediaSource.MediaPeriodId id, Allocator allocator, long startPositionUs) {
        DataSource dataSource = this.dataSourceFactory.createDataSource();
        if (this.transferListener != null) {
            dataSource.addTransferListener(this.transferListener);
        }
        return new ProgressiveMediaPeriod(this.localConfiguration.uri, dataSource, this.progressiveMediaExtractorFactory.createProgressiveMediaExtractor(this.getPlayerId()), this.drmSessionManager, this.createDrmEventDispatcher(id), this.loadableLoadErrorHandlingPolicy, this.createEventDispatcher(id), this, allocator, this.localConfiguration.customCacheKey, this.continueLoadingCheckIntervalBytes);
    }

    @Override
    public void releasePeriod(MediaPeriod mediaPeriod) {
        ((ProgressiveMediaPeriod)mediaPeriod).release();
    }

    @Override
    protected void releaseSourceInternal() {
        this.drmSessionManager.release();
    }

    @Override
    public void onSourceInfoRefreshed(long durationUs, boolean isSeekable, boolean isLive) {
        long l = durationUs = durationUs == -9223372036854775807L ? this.timelineDurationUs : durationUs;
        if (!this.timelineIsPlaceholder && this.timelineDurationUs == durationUs && this.timelineIsSeekable == isSeekable && this.timelineIsLive == isLive) {
            return;
        }
        this.timelineDurationUs = durationUs;
        this.timelineIsSeekable = isSeekable;
        this.timelineIsLive = isLive;
        this.timelineIsPlaceholder = false;
        this.notifySourceInfoRefreshed();
    }

    private void notifySourceInfoRefreshed() {
        Timeline timeline = new SinglePeriodTimeline(this.timelineDurationUs, this.timelineIsSeekable, false, this.timelineIsLive, (Object)null, this.mediaItem);
        if (this.timelineIsPlaceholder) {
            timeline = new ForwardingTimeline(timeline){

                @Override
                public Timeline.Window getWindow(int windowIndex, Timeline.Window window, long defaultPositionProjectionUs) {
                    super.getWindow(windowIndex, window, defaultPositionProjectionUs);
                    window.isPlaceholder = true;
                    return window;
                }

                @Override
                public Timeline.Period getPeriod(int periodIndex, Timeline.Period period, boolean setIds) {
                    super.getPeriod(periodIndex, period, setIds);
                    period.isPlaceholder = true;
                    return period;
                }
            };
        }
        this.refreshSourceInfo(timeline);
    }

    public static final class Factory
    implements MediaSourceFactory {
        private final DataSource.Factory dataSourceFactory;
        private ProgressiveMediaExtractor.Factory progressiveMediaExtractorFactory;
        private DrmSessionManagerProvider drmSessionManagerProvider;
        private LoadErrorHandlingPolicy loadErrorHandlingPolicy;
        private int continueLoadingCheckIntervalBytes;
        @Nullable
        private String customCacheKey;
        @Nullable
        private Object tag;

        public Factory(DataSource.Factory dataSourceFactory) {
            this(dataSourceFactory, (ExtractorsFactory)new DefaultExtractorsFactory());
        }

        public Factory(DataSource.Factory dataSourceFactory, ExtractorsFactory extractorsFactory) {
            this(dataSourceFactory, (PlayerId playerId) -> new BundledExtractorsAdapter(extractorsFactory));
        }

        public Factory(DataSource.Factory dataSourceFactory, ProgressiveMediaExtractor.Factory progressiveMediaExtractorFactory) {
            this(dataSourceFactory, progressiveMediaExtractorFactory, new DefaultDrmSessionManagerProvider(), new DefaultLoadErrorHandlingPolicy(), 0x100000);
        }

        public Factory(DataSource.Factory dataSourceFactory, ProgressiveMediaExtractor.Factory progressiveMediaExtractorFactory, DrmSessionManagerProvider drmSessionManagerProvider, LoadErrorHandlingPolicy loadErrorHandlingPolicy, int continueLoadingCheckIntervalBytes) {
            this.dataSourceFactory = dataSourceFactory;
            this.progressiveMediaExtractorFactory = progressiveMediaExtractorFactory;
            this.drmSessionManagerProvider = drmSessionManagerProvider;
            this.loadErrorHandlingPolicy = loadErrorHandlingPolicy;
            this.continueLoadingCheckIntervalBytes = continueLoadingCheckIntervalBytes;
        }

        @Override
        @CanIgnoreReturnValue
        public Factory setLoadErrorHandlingPolicy(LoadErrorHandlingPolicy loadErrorHandlingPolicy) {
            this.loadErrorHandlingPolicy = (LoadErrorHandlingPolicy)Assertions.checkNotNull((Object)loadErrorHandlingPolicy, (Object)"MediaSource.Factory#setLoadErrorHandlingPolicy no longer handles null by instantiating a new DefaultLoadErrorHandlingPolicy. Explicitly construct and pass an instance in order to retain the old behavior.");
            return this;
        }

        @CanIgnoreReturnValue
        public Factory setContinueLoadingCheckIntervalBytes(int continueLoadingCheckIntervalBytes) {
            this.continueLoadingCheckIntervalBytes = continueLoadingCheckIntervalBytes;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Factory setDrmSessionManagerProvider(DrmSessionManagerProvider drmSessionManagerProvider) {
            this.drmSessionManagerProvider = (DrmSessionManagerProvider)Assertions.checkNotNull((Object)drmSessionManagerProvider, (Object)"MediaSource.Factory#setDrmSessionManagerProvider no longer handles null by instantiating a new DefaultDrmSessionManagerProvider. Explicitly construct and pass an instance in order to retain the old behavior.");
            return this;
        }

        @Override
        public ProgressiveMediaSource createMediaSource(MediaItem mediaItem) {
            boolean needsCustomCacheKey;
            Assertions.checkNotNull((Object)mediaItem.localConfiguration);
            boolean needsTag = mediaItem.localConfiguration.tag == null && this.tag != null;
            boolean bl = needsCustomCacheKey = mediaItem.localConfiguration.customCacheKey == null && this.customCacheKey != null;
            if (needsTag && needsCustomCacheKey) {
                mediaItem = mediaItem.buildUpon().setTag(this.tag).setCustomCacheKey(this.customCacheKey).build();
            } else if (needsTag) {
                mediaItem = mediaItem.buildUpon().setTag(this.tag).build();
            } else if (needsCustomCacheKey) {
                mediaItem = mediaItem.buildUpon().setCustomCacheKey(this.customCacheKey).build();
            }
            return new ProgressiveMediaSource(mediaItem, this.dataSourceFactory, this.progressiveMediaExtractorFactory, this.drmSessionManagerProvider.get(mediaItem), this.loadErrorHandlingPolicy, this.continueLoadingCheckIntervalBytes);
        }

        @Override
        public int[] getSupportedTypes() {
            return new int[]{4};
        }
    }
}

