/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer.source.chunk;

import androidx.annotation.Nullable;
import androidx.media3.common.Format;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import androidx.media3.datasource.DataSource;
import androidx.media3.datasource.DataSourceUtil;
import androidx.media3.datasource.DataSpec;
import androidx.media3.exoplayer.source.chunk.Chunk;
import java.io.IOException;
import java.util.Arrays;

@UnstableApi
public abstract class DataChunk
extends Chunk {
    private static final int READ_GRANULARITY = 16384;
    private byte[] data;
    private volatile boolean loadCanceled;

    public DataChunk(DataSource dataSource, DataSpec dataSpec, int type, Format trackFormat, int trackSelectionReason, @Nullable Object trackSelectionData, @Nullable byte[] data) {
        super(dataSource, dataSpec, type, trackFormat, trackSelectionReason, trackSelectionData, -9223372036854775807L, -9223372036854775807L);
        this.data = data == null ? Util.EMPTY_BYTE_ARRAY : data;
    }

    public byte[] getDataHolder() {
        return this.data;
    }

    @Override
    public final void cancelLoad() {
        this.loadCanceled = true;
    }

    @Override
    public final void load() throws IOException {
        try {
            this.dataSource.open(this.dataSpec);
            int limit = 0;
            int bytesRead = 0;
            while (bytesRead != -1 && !this.loadCanceled) {
                this.maybeExpandData(limit);
                bytesRead = this.dataSource.read(this.data, limit, 16384);
                if (bytesRead == -1) continue;
                limit += bytesRead;
            }
            if (!this.loadCanceled) {
                this.consume(this.data, limit);
            }
        }
        finally {
            DataSourceUtil.closeQuietly((DataSource)this.dataSource);
        }
    }

    protected abstract void consume(byte[] var1, int var2) throws IOException;

    private void maybeExpandData(int limit) {
        if (this.data.length < limit + 16384) {
            this.data = Arrays.copyOf(this.data, this.data.length + 16384);
        }
    }
}

