/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer.upstream;

import androidx.annotation.Nullable;
import androidx.media3.common.MediaItem;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.UnstableApi;
import com.google.common.collect.ImmutableMap;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.UUID;

@UnstableApi
public final class CmcdConfiguration {
    public static final int MAX_ID_LENGTH = 64;
    public static final String KEY_CMCD_OBJECT = "CMCD-Object";
    public static final String KEY_CMCD_REQUEST = "CMCD-Request";
    public static final String KEY_CMCD_SESSION = "CMCD-Session";
    public static final String KEY_CMCD_STATUS = "CMCD-Status";
    public static final String KEY_BITRATE = "br";
    public static final String KEY_BUFFER_LENGTH = "bl";
    public static final String KEY_CONTENT_ID = "cid";
    public static final String KEY_SESSION_ID = "sid";
    public static final String KEY_MAXIMUM_REQUESTED_BITRATE = "rtp";
    @Nullable
    public final String sessionId;
    @Nullable
    public final String contentId;
    public final RequestConfig requestConfig;

    public CmcdConfiguration(@Nullable String sessionId, @Nullable String contentId, RequestConfig requestConfig) {
        Assertions.checkArgument((sessionId == null || sessionId.length() <= 64 ? 1 : 0) != 0);
        Assertions.checkArgument((contentId == null || contentId.length() <= 64 ? 1 : 0) != 0);
        Assertions.checkNotNull((Object)requestConfig);
        this.sessionId = sessionId;
        this.contentId = contentId;
        this.requestConfig = requestConfig;
    }

    public boolean isBitrateLoggingAllowed() {
        return this.requestConfig.isKeyAllowed(KEY_BITRATE);
    }

    public boolean isBufferLengthLoggingAllowed() {
        return this.requestConfig.isKeyAllowed(KEY_BUFFER_LENGTH);
    }

    public boolean isContentIdLoggingAllowed() {
        return this.requestConfig.isKeyAllowed(KEY_CONTENT_ID);
    }

    public boolean isSessionIdLoggingAllowed() {
        return this.requestConfig.isKeyAllowed(KEY_SESSION_ID);
    }

    public boolean isMaximumRequestThroughputLoggingAllowed() {
        return this.requestConfig.isKeyAllowed(KEY_MAXIMUM_REQUESTED_BITRATE);
    }

    public static interface RequestConfig {
        default public boolean isKeyAllowed(String key) {
            return true;
        }

        default public ImmutableMap<String, String> getCustomData() {
            return ImmutableMap.of();
        }

        default public int getRequestedMaximumThroughputKbps(int throughputKbps) {
            return -2147483647;
        }
    }

    public static interface Factory {
        public static final Factory DEFAULT = mediaItem -> new CmcdConfiguration(UUID.randomUUID().toString(), mediaItem.mediaId != null ? mediaItem.mediaId : "", new RequestConfig(){});

        public CmcdConfiguration createCmcdConfiguration(MediaItem var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Documented
    @Target(value={ElementType.TYPE_USE})
    public static @interface CmcdKey {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Documented
    @Target(value={ElementType.TYPE_USE})
    public static @interface HeaderKey {
    }
}

