/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer.rtsp;

import androidx.annotation.Nullable;
import androidx.media3.common.ParserException;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.Util;
import androidx.media3.exoplayer.rtsp.RtspMessageUtil;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.HashMap;

@UnstableApi
final class MediaDescription {
    public static final String MEDIA_TYPE_AUDIO = "audio";
    public static final String MEDIA_TYPE_VIDEO = "video";
    public static final String RTP_AVP_PROFILE = "RTP/AVP";
    public final String mediaType;
    public final int port;
    public final String transportProtocol;
    public final int payloadType;
    public final int bitrate;
    @Nullable
    public final String mediaTitle;
    @Nullable
    public final String connection;
    @Nullable
    public final String key;
    public final ImmutableMap<String, String> attributes;
    public final RtpMapAttribute rtpMapAttribute;

    private MediaDescription(Builder builder, ImmutableMap<String, String> attributes, RtpMapAttribute rtpMapAttribute) {
        this.mediaType = builder.mediaType;
        this.port = builder.port;
        this.transportProtocol = builder.transportProtocol;
        this.payloadType = builder.payloadType;
        this.mediaTitle = builder.mediaTitle;
        this.connection = builder.connection;
        this.bitrate = builder.bitrate;
        this.key = builder.key;
        this.attributes = attributes;
        this.rtpMapAttribute = rtpMapAttribute;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MediaDescription other = (MediaDescription)o;
        return this.mediaType.equals(other.mediaType) && this.port == other.port && this.transportProtocol.equals(other.transportProtocol) && this.payloadType == other.payloadType && this.bitrate == other.bitrate && this.attributes.equals(other.attributes) && this.rtpMapAttribute.equals(other.rtpMapAttribute) && Util.areEqual((Object)this.mediaTitle, (Object)other.mediaTitle) && Util.areEqual((Object)this.connection, (Object)other.connection) && Util.areEqual((Object)this.key, (Object)other.key);
    }

    public int hashCode() {
        int result = 7;
        result = 31 * result + this.mediaType.hashCode();
        result = 31 * result + this.port;
        result = 31 * result + this.transportProtocol.hashCode();
        result = 31 * result + this.payloadType;
        result = 31 * result + this.bitrate;
        result = 31 * result + this.attributes.hashCode();
        result = 31 * result + this.rtpMapAttribute.hashCode();
        result = 31 * result + (this.mediaTitle == null ? 0 : this.mediaTitle.hashCode());
        result = 31 * result + (this.connection == null ? 0 : this.connection.hashCode());
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        return result;
    }

    public ImmutableMap<String, String> getFmtpParametersAsMap() {
        String fmtpAttributeValue = (String)this.attributes.get((Object)"fmtp");
        if (fmtpAttributeValue == null) {
            return ImmutableMap.of();
        }
        String[] fmtpComponents = Util.splitAtFirst((String)fmtpAttributeValue, (String)" ");
        Assertions.checkArgument((fmtpComponents.length == 2 ? 1 : 0) != 0, (Object)fmtpAttributeValue);
        String[] parameters = fmtpComponents[1].split(";\\s?", 0);
        ImmutableMap.Builder formatParametersBuilder = new ImmutableMap.Builder();
        for (String parameter : parameters) {
            String[] parameterPair = Util.splitAtFirst((String)parameter, (String)"=");
            formatParametersBuilder.put((Object)parameterPair[0], (Object)parameterPair[1]);
        }
        return formatParametersBuilder.buildOrThrow();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Documented
    public static @interface MediaType {
    }

    public static final class Builder {
        private static final String RTP_MAP_ATTR_AUDIO_FMT = "%d %s/%d/%d";
        private static final int RTP_STATIC_PAYLOAD_TYPE_PCMU = 0;
        private static final int RTP_STATIC_PAYLOAD_TYPE_PCMA = 8;
        private static final int RTP_STATIC_PAYLOAD_TYPE_L16_STEREO = 10;
        private static final int RTP_STATIC_PAYLOAD_TYPE_L16_MONO = 11;
        private final String mediaType;
        private final int port;
        private final String transportProtocol;
        private final int payloadType;
        private final HashMap<String, String> attributes;
        private int bitrate;
        @Nullable
        private String mediaTitle;
        @Nullable
        private String connection;
        @Nullable
        private String key;

        public Builder(String mediaType, int port, String transportProtocol, int payloadType) {
            this.mediaType = mediaType;
            this.port = port;
            this.transportProtocol = transportProtocol;
            this.payloadType = payloadType;
            this.attributes = new HashMap();
            this.bitrate = -1;
        }

        @CanIgnoreReturnValue
        public Builder setMediaTitle(String mediaTitle) {
            this.mediaTitle = mediaTitle;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setConnection(String connection) {
            this.connection = connection;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setBitrate(int bitrate) {
            this.bitrate = bitrate;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setKey(String key) {
            this.key = key;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addAttribute(String attributeName, String attributeValue) {
            this.attributes.put(attributeName, attributeValue);
            return this;
        }

        public MediaDescription build() {
            try {
                RtpMapAttribute rtpMapAttribute = this.attributes.containsKey("rtpmap") ? RtpMapAttribute.parse((String)Util.castNonNull((Object)this.attributes.get("rtpmap"))) : RtpMapAttribute.parse(Builder.getRtpMapStringByPayloadType(this.payloadType));
                return new MediaDescription(this, ImmutableMap.copyOf(this.attributes), rtpMapAttribute);
            }
            catch (ParserException e) {
                throw new IllegalStateException(e);
            }
        }

        private static String getRtpMapStringByPayloadType(int rtpPayloadType) {
            Assertions.checkArgument((rtpPayloadType < 96 ? 1 : 0) != 0);
            switch (rtpPayloadType) {
                case 0: {
                    return Builder.constructAudioRtpMap(0, "PCMU", 8000, 1);
                }
                case 8: {
                    return Builder.constructAudioRtpMap(8, "PCMA", 8000, 1);
                }
                case 10: {
                    return Builder.constructAudioRtpMap(10, "L16", 44100, 2);
                }
                case 11: {
                    return Builder.constructAudioRtpMap(11, "L16", 44100, 1);
                }
            }
            throw new IllegalStateException("Unsupported static paylod type " + rtpPayloadType);
        }

        private static String constructAudioRtpMap(int payloadType, String mediaEncoding, int clockRate, int channelCount) {
            return Util.formatInvariant((String)RTP_MAP_ATTR_AUDIO_FMT, (Object[])new Object[]{payloadType, mediaEncoding, clockRate, channelCount});
        }
    }

    public static final class RtpMapAttribute {
        public final int payloadType;
        public final String mediaEncoding;
        public final int clockRate;
        public final int encodingParameters;

        public static RtpMapAttribute parse(String rtpmapString) throws ParserException {
            String[] rtpmapInfo = Util.splitAtFirst((String)rtpmapString, (String)" ");
            Assertions.checkArgument((rtpmapInfo.length == 2 ? 1 : 0) != 0);
            int payloadType = RtspMessageUtil.parseInt(rtpmapInfo[0]);
            String[] mediaInfo = Util.split((String)rtpmapInfo[1].trim(), (String)"/");
            Assertions.checkArgument((mediaInfo.length >= 2 ? 1 : 0) != 0);
            int clockRate = RtspMessageUtil.parseInt(mediaInfo[1]);
            int encodingParameters = -1;
            if (mediaInfo.length == 3) {
                encodingParameters = RtspMessageUtil.parseInt(mediaInfo[2]);
            }
            return new RtpMapAttribute(payloadType, mediaInfo[0], clockRate, encodingParameters);
        }

        private RtpMapAttribute(int payloadType, String mediaEncoding, int clockRate, int encodingParameters) {
            this.payloadType = payloadType;
            this.mediaEncoding = mediaEncoding;
            this.clockRate = clockRate;
            this.encodingParameters = encodingParameters;
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RtpMapAttribute that = (RtpMapAttribute)o;
            return this.payloadType == that.payloadType && this.mediaEncoding.equals(that.mediaEncoding) && this.clockRate == that.clockRate && this.encodingParameters == that.encodingParameters;
        }

        public int hashCode() {
            int result = 7;
            result = 31 * result + this.payloadType;
            result = 31 * result + this.mediaEncoding.hashCode();
            result = 31 * result + this.clockRate;
            result = 31 * result + this.encodingParameters;
            return result;
        }
    }
}

