/*
 * Decompiled with CFR 0.152.
 */
package androidx.media3.exoplayer.rtsp;

import android.net.Uri;
import androidx.annotation.VisibleForTesting;
import androidx.media3.common.ParserException;
import androidx.media3.common.util.Assertions;
import androidx.media3.common.util.UnstableApi;
import androidx.media3.common.util.UriUtil;
import androidx.media3.common.util.Util;
import com.google.common.collect.ImmutableList;

@UnstableApi
final class RtspTrackTiming {
    public final long rtpTimestamp;
    public final int sequenceNumber;
    public final Uri uri;

    public static ImmutableList<RtspTrackTiming> parseTrackTiming(String rtpInfoString, Uri sessionUri) throws ParserException {
        ImmutableList.Builder listBuilder = new ImmutableList.Builder();
        for (String perTrackTimingString : Util.split((String)rtpInfoString, (String)",")) {
            long rtpTime = -9223372036854775807L;
            int sequenceNumber = -1;
            Uri uri = null;
            for (String attributePair : Util.split((String)perTrackTimingString, (String)";")) {
                try {
                    String[] attributes = Util.splitAtFirst((String)attributePair, (String)"=");
                    String attributeName = attributes[0];
                    String attributeValue = attributes[1];
                    switch (attributeName) {
                        case "url": {
                            uri = RtspTrackTiming.resolveUri(attributeValue, sessionUri);
                            break;
                        }
                        case "seq": {
                            sequenceNumber = Integer.parseInt(attributeValue);
                            break;
                        }
                        case "rtptime": {
                            rtpTime = Long.parseLong(attributeValue);
                            break;
                        }
                        default: {
                            throw ParserException.createForMalformedManifest((String)attributeName, null);
                        }
                    }
                }
                catch (Exception e) {
                    throw ParserException.createForMalformedManifest((String)attributePair, (Throwable)e);
                }
            }
            if (uri == null || uri.getScheme() == null || sequenceNumber == -1 && rtpTime == -9223372036854775807L) {
                throw ParserException.createForMalformedManifest((String)perTrackTimingString, null);
            }
            listBuilder.add((Object)new RtspTrackTiming(rtpTime, sequenceNumber, uri));
        }
        return listBuilder.build();
    }

    @VisibleForTesting
    static Uri resolveUri(String urlString, Uri sessionUri) {
        Assertions.checkArgument((boolean)((String)Assertions.checkNotNull((Object)sessionUri.getScheme())).equals("rtsp"));
        Uri uri = Uri.parse((String)urlString);
        if (uri.isAbsolute()) {
            return uri;
        }
        uri = Uri.parse((String)("rtsp://" + urlString));
        String sessionUriString = sessionUri.toString();
        String host = (String)Assertions.checkNotNull((Object)uri.getHost());
        if (host.equals(sessionUri.getHost())) {
            return uri;
        }
        return sessionUriString.endsWith("/") ? UriUtil.resolveToUri((String)sessionUriString, (String)urlString) : UriUtil.resolveToUri((String)(sessionUriString + "/"), (String)urlString);
    }

    private RtspTrackTiming(long rtpTimestamp, int sequenceNumber, Uri uri) {
        this.rtpTimestamp = rtpTimestamp;
        this.sequenceNumber = sequenceNumber;
        this.uri = uri;
    }
}

